/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.init;

import codechicken.chunkloader.client.ChunkLoaderItemModel;
import codechicken.chunkloader.client.TileChunkLoaderRenderer;
import codechicken.chunkloader.init.ChickenChunksModContent;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;

public class ClientInit {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");

    public static void init(IEventBus modBus) {
        LOCK.lock();
        modBus.addListener(ClientInit::onRegisterRenderers);
        modBus.addListener(ClientInit::onRegisterGeometryLoaders);
    }

    private static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)ChickenChunksModContent.CHUNK_LOADER_TILE.get()), TileChunkLoaderRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)ChickenChunksModContent.SPOT_LOADER_TILE.get()), TileChunkLoaderRenderer::new);
    }

    private static void onRegisterGeometryLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"chickenchunks", (String)"chunk_loader"), (IGeometryLoader)new ChunkLoaderItemModel());
    }
}

