/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.init;

import codechicken.chunkloader.block.BlockChunkLoader;
import codechicken.chunkloader.block.BlockSpotLoader;
import codechicken.chunkloader.tile.TileChunkLoader;
import codechicken.chunkloader.tile.TileSpotLoader;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ChickenChunksModContent {
    private static final CrashLock LOCK = new CrashLock("Already Initialized");
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"chickenchunks");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"chickenchunks");
    private static final DeferredRegister<BlockEntityType<?>> TILES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"chickenchunks");
    public static final DeferredHolder<Block, BlockChunkLoader> CHUNK_LOADER_BLOCK = BLOCKS.register("chunk_loader", BlockChunkLoader::new);
    public static final DeferredHolder<Block, BlockSpotLoader> SPOT_LOADER_BLOCK = BLOCKS.register("spot_loader", BlockSpotLoader::new);
    private static final Item.Properties itemProps = new Item.Properties();
    public static final DeferredHolder<Item, BlockItem> CHUNK_LOADER_ITEM = ITEMS.register("chunk_loader", () -> new BlockItem((Block)CHUNK_LOADER_BLOCK.get(), itemProps));
    public static final DeferredHolder<Item, BlockItem> SPOT_LOADER_ITEM = ITEMS.register("spot_loader", () -> new BlockItem((Block)SPOT_LOADER_BLOCK.get(), itemProps));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileChunkLoader>> CHUNK_LOADER_TILE = TILES.register("chunk_loader", () -> BlockEntityType.Builder.of(TileChunkLoader::new, (Block[])new Block[]{(Block)CHUNK_LOADER_BLOCK.get()}).build(null));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileSpotLoader>> SPOT_LOADER_TILE = TILES.register("spot_loader", () -> BlockEntityType.Builder.of(TileSpotLoader::new, (Block[])new Block[]{(Block)SPOT_LOADER_BLOCK.get()}).build(null));

    public static void init(IEventBus modBus) {
        LOCK.lock();
        BLOCKS.register(modBus);
        ITEMS.register(modBus);
        TILES.register(modBus);
        modBus.addListener(ChickenChunksModContent::onCreativeTabBuild);
    }

    private static void onCreativeTabBuild(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            event.accept((ItemLike)CHUNK_LOADER_BLOCK.get());
            event.accept((ItemLike)SPOT_LOADER_BLOCK.get());
        }
    }
}

