/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.handler;

import codechicken.lib.config.ConfigCategory;
import codechicken.lib.config.ConfigCategoryImpl;
import codechicken.lib.config.ConfigFile;
import codechicken.lib.config.ConfigTag;
import codechicken.lib.config.ConfigValue;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class ChickenChunksConfig {
    @Nullable
    private static ConfigCategory playerRestrictions;
    private static final Map<UUID, Restrictions> perPlayerRestrictions;
    private static boolean opsBypassRestrictions;
    private static boolean opsAccessAllLoaders;
    private static boolean globalAllowOffline;
    private static int globalOfflineTimeout;
    private static int globalTotalAllowedChunks;
    private static int globalChunksPerLoader;

    public static void load() {
        ConfigCategory config = new ConfigFile("chickenchunks").path(Paths.get("./config/ChickenChunks.cfg", new String[0])).load();
        opsBypassRestrictions = config.getValue("opsBypassRestrictions").setComment("If Players with OP permissions bypass chunk loading restrictions.").setDefaultBoolean(false).getBoolean();
        opsAccessAllLoaders = config.getValue("opsAccessAllLoaders").setComment("If Players with OP permissions can manage other users ChunkLoaders").setDefaultBoolean(true).getBoolean();
        globalAllowOffline = config.getValue("allowOffline").setComment("If chunks should stay loaded when a ChunkLoader's owner is offline.").setDefaultBoolean(true).getBoolean();
        globalOfflineTimeout = config.getValue("offlineTimeout").setComment("How long in minutes ChickenChunks should wait after a Player logs out to unload their chunks. Only effective when allowOffline=false").setDefaultInt(0).getInt();
        globalTotalAllowedChunks = config.getValue("totalAllowedChunks").setComment("The number of chunks each player is allowed to load in total.").setDefaultInt(5000).getInt();
        globalChunksPerLoader = config.getValue("chunksPerLoader").setComment("The number of chunks each ChunkLoader is allowed to load in total.").setDefaultInt(400).getInt();
        playerRestrictions = config.getCategory("playerRestrictions").setComment("Specifies restrictions for each player, Use /chickenchunks instead.");
        playerRestrictions.onSync((tag, syncType) -> {
            perPlayerRestrictions.clear();
            for (ConfigTag child : tag.getChildren()) {
                UUID uuid = UUID.fromString(child.getName());
                perPlayerRestrictions.put(uuid, new Restrictions((ConfigCategory)child));
            }
        });
        config.save();
        playerRestrictions.forceSync();
    }

    public static boolean doesBypassRestrictions(MinecraftServer server, UUID playerUUID) {
        ServerPlayer player = server.getPlayerList().getPlayer(playerUUID);
        if (player != null && server.getPlayerList().getOps().get((Object)player.getGameProfile()) != null) {
            return opsBypassRestrictions;
        }
        return false;
    }

    public static boolean doesBypassLoaderAccess(ServerPlayer player) {
        if (Objects.requireNonNull(player.getServer()).getPlayerList().getOps().get((Object)player.getGameProfile()) != null) {
            return opsAccessAllLoaders;
        }
        return false;
    }

    public static Restrictions getOrCreateRestrictions(UUID player) {
        return perPlayerRestrictions.computeIfAbsent(player, e -> {
            ConfigCategory tag = Objects.requireNonNull(playerRestrictions).getCategory(player.toString());
            tag.save();
            return new Restrictions(tag);
        });
    }

    public static void resetRestrictions(UUID player) {
        perPlayerRestrictions.remove(player);
        Objects.requireNonNull(playerRestrictions);
        playerRestrictions.delete(player.toString());
        playerRestrictions.save();
    }

    public static Restrictions getRestrictions(UUID player) {
        return perPlayerRestrictions.getOrDefault(player, Restrictions.EMPTY);
    }

    static {
        perPlayerRestrictions = new HashMap<UUID, Restrictions>();
    }

    public static class Restrictions {
        public static final Restrictions EMPTY = new Restrictions((ConfigCategory)new ConfigCategoryImpl("", null));
        private Optional<Boolean> allowOffline;
        private Optional<Integer> offlineTimeout;
        private Optional<Integer> totalAllowedChunks;
        private Optional<Integer> chunksPerLoader;
        private final ConfigCategory tag;

        public Restrictions(ConfigCategory tag) {
            this.tag = tag;
            this.allowOffline = Optional.ofNullable(tag.findValue("allowOffline")).map(ConfigValue::getBoolean);
            this.offlineTimeout = Optional.ofNullable(tag.findValue("offlineTimeout")).map(ConfigValue::getInt);
            this.totalAllowedChunks = Optional.ofNullable(tag.findValue("totalAllowedChunks")).map(ConfigValue::getInt);
            this.chunksPerLoader = Optional.ofNullable(tag.findValue("chunksPerLoader")).map(ConfigValue::getInt);
        }

        public boolean canLoadOffline() {
            return this.allowOffline.orElse(globalAllowOffline);
        }

        public int getOfflineTimeout() {
            return this.offlineTimeout.orElse(globalOfflineTimeout);
        }

        public int getTotalAllowedChunks() {
            return this.totalAllowedChunks.orElse(globalTotalAllowedChunks);
        }

        public int getChunksPerLoader() {
            return this.chunksPerLoader.orElse(globalChunksPerLoader);
        }

        public void setAllowOffline(boolean state) {
            this.tag.getValue("allowOffline").setBoolean(state).save();
            this.allowOffline = Optional.of(state);
        }

        public void setOfflineTimeout(int num) {
            this.tag.getValue("offlineTimeout").setInt(num).save();
            this.offlineTimeout = Optional.of(num);
        }

        public void setTotalAllowedChunks(int num) {
            this.tag.getValue("totalAllowedChunks").setInt(num).save();
            this.totalAllowedChunks = Optional.of(num);
        }

        public void setChunksPerLoader(int num) {
            this.tag.getValue("chunksPerLoader").setInt(num).save();
            this.chunksPerLoader = Optional.of(num);
        }

        public void remAllowOffline() {
            this.tag.delete("allowOffline").save();
            this.allowOffline = Optional.empty();
        }

        public void remOfflineTimeout() {
            this.tag.delete("offlineTimeout").save();
            this.offlineTimeout = Optional.empty();
        }

        public void remTotalAllowedChunks() {
            this.tag.delete("totalAllowedChunks").save();
            this.totalAllowedChunks = Optional.empty();
        }

        public void remChunksPerLoader() {
            this.tag.delete("chunksPerLoader").save();
            this.chunksPerLoader = Optional.empty();
        }

        public boolean isEmpty() {
            return this.allowOffline.isEmpty() && this.offlineTimeout.isEmpty() && this.totalAllowedChunks.isEmpty() && this.chunksPerLoader.isEmpty();
        }
    }
}

