/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.gui;

import codechicken.chunkloader.api.ChunkLoaderShape;
import codechicken.chunkloader.network.ChunkLoaderCPH;
import codechicken.chunkloader.tile.TileChunkLoader;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class GuiChunkLoader
extends Screen {
    @Nullable
    public Button laserButton;
    @Nullable
    public Button shapeButton;
    public TileChunkLoader tile;
    private int lastRadius = -1;
    @Nullable
    private ChunkLoaderShape lastShape = null;
    private int lastButton;
    private long warningEnd = -1L;
    @Nullable
    private Component warningText;

    public GuiChunkLoader(TileChunkLoader tile) {
        super((Component)Component.empty());
        this.tile = tile;
    }

    public void init() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"+"), e -> ChunkLoaderCPH.sendShapeChange(this.tile, this.tile.shape, this.tile.radius + 1)).bounds(this.width / 2 - 20, this.height / 2 - 45, 20, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"-"), e -> ChunkLoaderCPH.sendShapeChange(this.tile, this.tile.shape, this.tile.radius - 1)).bounds(this.width / 2 - 80, this.height / 2 - 45, 20, 20).build());
        this.laserButton = Button.builder((Component)Component.literal((String)"-"), e -> {
            this.tile.renderInfo.showLasers = !this.tile.renderInfo.showLasers;
        }).bounds(this.width / 2 + 7, this.height / 2 - 60, 75, 20).build();
        this.addRenderableWidget((GuiEventListener)this.laserButton);
        this.shapeButton = Button.builder((Component)Component.literal((String)"-"), e -> ChunkLoaderCPH.sendShapeChange(this.tile, this.lastButton == 1 ? this.tile.shape.prev() : this.tile.shape.next(), this.tile.radius)).bounds(this.width / 2 + 7, this.height / 2 - 37, 75, 20).build();
        this.addRenderableWidget((GuiEventListener)this.shapeButton);
        this.updateNames();
        super.init();
    }

    public void updateNames() {
        assert (this.laserButton != null);
        assert (this.shapeButton != null);
        assert (this.tile.renderInfo != null);
        this.laserButton.setMessage((Component)Component.translatable((String)(this.tile.renderInfo.showLasers ? "chickenchunks.gui.hidelasers" : "chickenchunks.gui.showlasers")));
        this.shapeButton.setMessage(this.tile.shape.getTranslation());
        if (this.lastRadius != this.tile.radius || this.lastShape != this.tile.shape) {
            this.warningEnd = -1L;
            this.warningText = null;
            this.lastRadius = this.tile.radius;
            this.lastShape = this.tile.shape;
        }
    }

    public void addWarning(Component text) {
        this.warningText = text;
        this.warningEnd = System.currentTimeMillis() + 3500L;
    }

    public void tick() {
        assert (this.minecraft != null);
        assert (this.minecraft.level != null);
        if (this.minecraft.level.getBlockEntity(this.tile.getBlockPos()) != this.tile) {
            this.minecraft.screen = null;
            this.minecraft.mouseHandler.grabMouse();
        }
        this.updateNames();
        super.tick();
    }

    protected void renderMenuBackground(GuiGraphics graphics) {
        ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"chickenchunks", (String)"textures/gui/gui_small.png");
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        int posx = this.width / 2 - 88;
        int posy = this.height / 2 - 83;
        graphics.blit(texture, posx, posy, 0, 0, 176, 166);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.drawCentered(graphics, (Component)Component.translatable((String)"chickenchunks.gui.name"), this.width / 2 - 40, this.height / 2 - 74, 0x303030);
        if (this.tile.owner != null) {
            assert (this.tile.ownerName != null);
            this.drawCentered(graphics, this.tile.ownerName, this.width / 2 + 44, this.height / 2 - 72, 0x801080);
        }
        this.drawCentered(graphics, (Component)Component.translatable((String)"chickenchunks.gui.radius"), this.width / 2 - 40, this.height / 2 - 57, 0x404040);
        this.drawCentered(graphics, (Component)Component.literal((String)("" + this.tile.radius)), this.width / 2 - 40, this.height / 2 - 39, 0xFFFFFF);
        int chunks = this.tile.countLoadedChunks();
        this.drawCentered(graphics, (Component)Component.translatable((String)(chunks == 1 ? "chickenchunks.gui.chunk" : "chickenchunks.gui.chunks"), (Object[])new Object[]{chunks}), this.width / 2 - 39, this.height / 2 - 21, 0x108000);
        if (this.warningText != null && this.warningEnd != -1L) {
            float fade = (float)(this.warningEnd - System.currentTimeMillis()) / 1000.0f;
            if ((double)fade <= 0.1) {
                this.warningEnd = -1L;
                this.warningText = null;
            } else {
                int alpha = fade <= 1.0f ? (int)(255.0f * fade) : 255;
                this.drawCentered(graphics, this.warningText, this.width / 2, this.height / 2 - 8, 0xFF5555 | (alpha & 0xFF) << 24);
            }
        }
    }

    private void drawCentered(GuiGraphics graphics, Component s, int x, int y, int colour) {
        graphics.drawString(this.font, s.getVisualOrderText(), x - this.font.width((FormattedText)s) / 2, y, colour, false);
    }

    public boolean mouseClicked(double x, double y, int button) {
        this.lastButton = button;
        if (button == 1) {
            button = 0;
        }
        return super.mouseClicked(x, y, button);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

