/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.command;

import codechicken.chunkloader.handler.ChickenChunksConfig;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public class ChickenChunksCommand {
    private static final String RESTRICTIONS_RESET_FOR = "chickenchunks:commands.restrictions.player.reset";
    private static final String OFFLINE_ENABLE_FOR = "chickenchunks:commands.restrictions.player.offline.enable";
    private static final String OFFLINE_DISABLE_FOR = "chickenchunks:commands.restrictions.player.offline.disable";
    private static final String OFFLINE_RESET_FOR = "chickenchunks:commands.restrictions.player.offline.reset";
    private static final String TIMEOUT_SET_FOR = "chickenchunks:commands.restrictions.player.timeout.set";
    private static final String TIMEOUT_RESET_FOR = "chickenchunks:commands.restrictions.player.timeout.reset";
    private static final String ALLOWED_CHUNKS_SET_FOR = "chickenchunks:commands.restrictions.player.allowed_chunks.set";
    private static final String ALLOWED_CHUNKS_RESET_FOR = "chickenchunks:commands.restrictions.player.allowed_chunks.reset";
    private static final String CHUNKS_PER_LOADER_SET_FOR = "chickenchunks:commands.restrictions.player.chunks_per_loader.set";
    private static final String CHUNKS_PER_LOADER_RESET_FOR = "chickenchunks:commands.restrictions.player.chunks_per_loader.reset";

    public static void init() {
        NeoForge.EVENT_BUS.addListener(ChickenChunksCommand::onRegisterCommands);
    }

    private static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"chickenchunks").requires(e -> e.hasPermission(4))).then(Commands.literal((String)"restrict").then(Commands.literal((String)"player").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).then(Commands.literal((String)"reset").executes(ChickenChunksCommand::resetRestrictions))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"allow_offline").then(Commands.literal((String)"toggle").executes(ChickenChunksCommand::toggleOfflineFor))).then(Commands.literal((String)"enable").executes(ChickenChunksCommand::enableOfflineFor))).then(Commands.literal((String)"disable").executes(ChickenChunksCommand::disableOfflineFor))).then(Commands.literal((String)"reset").executes(ChickenChunksCommand::resetOfflineFor)))).then(((LiteralArgumentBuilder)Commands.literal((String)"offline_timeout").then(Commands.argument((String)"timeout", (ArgumentType)IntegerArgumentType.integer()).executes(ChickenChunksCommand::setTimeoutFor))).then(Commands.literal((String)"reset").executes(ChickenChunksCommand::resetTimeoutFor)))).then(((LiteralArgumentBuilder)Commands.literal((String)"allowed_chunks").then(Commands.argument((String)"allowed_chunks", (ArgumentType)IntegerArgumentType.integer()).executes(ChickenChunksCommand::setAllowedChunksFor))).then(Commands.literal((String)"reset").executes(ChickenChunksCommand::resetAllowedChunksFor)))).then(((LiteralArgumentBuilder)Commands.literal((String)"chunks_per_loader").then(Commands.argument((String)"chunks_per_loader", (ArgumentType)IntegerArgumentType.integer()).executes(ChickenChunksCommand::setChunksPerLoaderFor))).then(Commands.literal((String)"reset").executes(ChickenChunksCommand::resetChunksPerLoaderFor)))))));
    }

    private static int resetRestrictions(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        Collection profiles = GameProfileArgument.getGameProfiles(ctx, (String)"players");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.resetRestrictions(profile.getId());
            src.sendSuccess(() -> Component.translatable((String)RESTRICTIONS_RESET_FOR, (Object[])new Object[]{profile.getName()}), true);
        }
        return profiles.size();
    }

    private static int toggleOfflineFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        Collection profiles = GameProfileArgument.getGameProfiles(ctx, (String)"players");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            boolean state = !restrictions.canLoadOffline();
            restrictions.setAllowOffline(state);
            src.sendSuccess(() -> Component.translatable((String)(state ? OFFLINE_ENABLE_FOR : OFFLINE_DISABLE_FOR), (Object[])new Object[]{profile.getName()}), true);
        }
        return profiles.size();
    }

    private static int enableOfflineFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return ChickenChunksCommand.setOfflineFor(ctx, true);
    }

    private static int disableOfflineFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return ChickenChunksCommand.setOfflineFor(ctx, false);
    }

    private static int setOfflineFor(CommandContext<CommandSourceStack> ctx, boolean state) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        Collection profiles = GameProfileArgument.getGameProfiles(ctx, (String)"players");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.setAllowOffline(state);
            src.sendSuccess(() -> Component.translatable((String)(state ? OFFLINE_ENABLE_FOR : OFFLINE_DISABLE_FOR), (Object[])new Object[]{profile.getName()}), true);
        }
        return profiles.size();
    }

    private static int resetOfflineFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        Collection profiles = GameProfileArgument.getGameProfiles(ctx, (String)"players");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.remAllowOffline();
            src.sendSuccess(() -> Component.translatable((String)OFFLINE_RESET_FOR, (Object[])new Object[]{profile.getName()}), true);
        }
        return profiles.size();
    }

    public static int setTimeoutFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        Collection profiles = GameProfileArgument.getGameProfiles(ctx, (String)"players");
        int timeout = IntegerArgumentType.getInteger(ctx, (String)"timeout");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.setOfflineTimeout(timeout);
            src.sendSuccess(() -> Component.translatable((String)TIMEOUT_SET_FOR, (Object[])new Object[]{profile.getName(), timeout}), true);
        }
        return profiles.size();
    }

    private static int resetTimeoutFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        Collection profiles = GameProfileArgument.getGameProfiles(ctx, (String)"players");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.remOfflineTimeout();
            src.sendSuccess(() -> Component.translatable((String)TIMEOUT_RESET_FOR, (Object[])new Object[]{profile.getName()}), true);
        }
        return profiles.size();
    }

    public static int setAllowedChunksFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        Collection profiles = GameProfileArgument.getGameProfiles(ctx, (String)"players");
        int chunks = IntegerArgumentType.getInteger(ctx, (String)"allowed_chunks");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.setTotalAllowedChunks(chunks);
            src.sendSuccess(() -> Component.translatable((String)ALLOWED_CHUNKS_SET_FOR, (Object[])new Object[]{profile.getName(), chunks}), true);
        }
        return profiles.size();
    }

    private static int resetAllowedChunksFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        Collection profiles = GameProfileArgument.getGameProfiles(ctx, (String)"players");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.remTotalAllowedChunks();
            src.sendSuccess(() -> Component.translatable((String)ALLOWED_CHUNKS_RESET_FOR, (Object[])new Object[]{profile.getName()}), true);
        }
        return profiles.size();
    }

    public static int setChunksPerLoaderFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        Collection profiles = GameProfileArgument.getGameProfiles(ctx, (String)"players");
        int chunks = IntegerArgumentType.getInteger(ctx, (String)"chunks_per_loader");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.setChunksPerLoader(chunks);
            src.sendSuccess(() -> Component.translatable((String)CHUNKS_PER_LOADER_SET_FOR, (Object[])new Object[]{profile.getName(), chunks}), true);
        }
        return profiles.size();
    }

    private static int resetChunksPerLoaderFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        Collection profiles = GameProfileArgument.getGameProfiles(ctx, (String)"players");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.remChunksPerLoader();
            src.sendSuccess(() -> Component.translatable((String)CHUNKS_PER_LOADER_RESET_FOR, (Object[])new Object[]{profile.getName()}), true);
        }
        return profiles.size();
    }

    private static ChickenChunksConfig.Restrictions getPlayerRestrictions(UUID player) {
        return ChickenChunksConfig.getOrCreateRestrictions(player);
    }
}

