/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.block;

import codechicken.chunkloader.block.BlockChunkLoaderBase;
import codechicken.chunkloader.handler.ChickenChunksConfig;
import codechicken.chunkloader.init.ChickenChunksModContent;
import codechicken.chunkloader.network.ChickenChunksNetwork;
import codechicken.chunkloader.tile.TileChunkLoader;
import codechicken.lib.packet.PacketCustom;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockChunkLoader
extends BlockChunkLoaderBase {
    public static final VoxelShape SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.75, (double)1.0);

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileChunkLoader(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!world.isClientSide) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (!(blockEntity instanceof TileChunkLoader)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            TileChunkLoader tile = (TileChunkLoader)blockEntity;
            if (tile.owner == null) {
                player.sendSystemMessage((Component)Component.translatable((String)"chickenchunks.brokentile"));
            } else if (tile.owner.equals(player.getUUID()) || ChickenChunksConfig.doesBypassLoaderAccess((ServerPlayer)player)) {
                PacketCustom packet = new PacketCustom(ChickenChunksNetwork.NET_CHANNEL, 1, world.registryAccess());
                packet.writePos(pos);
                packet.sendToPlayer((ServerPlayer)player);
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"chickenchunks.accessdenied"));
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> actual) {
        if (level.isClientSide) {
            return BlockChunkLoader.createTickerHelper(actual, (BlockEntityType)((BlockEntityType)ChickenChunksModContent.CHUNK_LOADER_TILE.get()), (a, b, c, d) -> d.tickClient());
        }
        return BlockChunkLoader.createTickerHelper(actual, (BlockEntityType)((BlockEntityType)ChickenChunksModContent.CHUNK_LOADER_TILE.get()), (a, b, c, d) -> d.tickServer());
    }
}

