/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.pipe;

import com.google.common.base.Preconditions;
import dev.technici4n.moderndynamics.MdBlock;
import dev.technici4n.moderndynamics.network.NodeHost;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.pipe.PipeBoundingBoxes;
import dev.technici4n.moderndynamics.pipe.PipeItem;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PipeBlock
extends MdBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private PipeItem item;
    private boolean transparent = true;

    public PipeBlock(String id) {
        super(id, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).noOcclusion().isRedstoneConductor((state, world, pos) -> false).destroyTime(0.2f));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public PipeItem getItem() {
        Preconditions.checkState((this.item != null ? 1 : 0) != 0, (String)"Item has not been set on %s", (Object)((Object)this));
        return this.item;
    }

    public void setItem(PipeItem item) {
        Preconditions.checkState((this.item == null ? 1 : 0) != 0, (String)"Item has already been set on %s", (Object)((Object)this));
        this.item = item;
    }

    public PipeBlock setTransparent(boolean transparent) {
        this.transparent = transparent;
        return this;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        FluidState fluidState = context.getLevel().getFluidState(pos);
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        List drops = super.getDrops(state, params);
        NodeHost[] nodeHostArray = params.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (nodeHostArray instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)nodeHostArray;
            for (NodeHost host : pipe.getHosts()) {
                host.addDrops(drops);
            }
        }
        return drops;
    }

    public int getLightBlock(BlockState state, BlockGetter blockView, BlockPos pos) {
        return 0;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block param4, BlockPos param5, boolean param6) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)blockEntity;
            pipe.scheduleHostUpdates();
        }
    }

    public boolean hasDynamicShape() {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)blockEntity;
            return pipe.getCachedShape();
        }
        return PipeBoundingBoxes.CORE_SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)blockEntity;
            return pipe.useItemOn(player, hand, hitResult);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)blockEntity;
            return pipe.useWithoutItem(player, hitResult);
        }
        return InteractionResult.PASS;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = world.getBlockEntity(pos)) instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)blockEntity;
            pipe.onRemoved();
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return (l, p, s, pipeBe) -> ((PipeBlockEntity)pipeBe).clientTick();
        }
        return null;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        PipeBlockEntity pipe;
        ItemStack result;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PipeBlockEntity && !(result = (pipe = (PipeBlockEntity)blockEntity).overridePickBlock(target)).isEmpty()) {
            return result;
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }
}

