/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.item.sync;

import dev.technici4n.moderndynamics.network.item.sync.ClientTravelingItem;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;

public class ClientTravelingItemSmoothing {
    private static final double SMOOTHING_EXP = 0.15;
    private static final Int2ObjectMap<SmoothingInfo> INFOS = new Int2ObjectOpenHashMap();
    private static long clientTick = 0L;

    public static void onUnpausedTick() {
        ObjectIterator it = INFOS.values().iterator();
        while (it.hasNext()) {
            SmoothingInfo info = (SmoothingInfo)it.next();
            info.wrongOffset *= ClientTravelingItemSmoothing.smooth(1.0);
            --info.deadTimer;
            if (info.deadTimer > 0) continue;
            it.remove();
        }
        ++clientTick;
    }

    public static void onReceiveItem(ClientTravelingItem item) {
        SmoothingInfo info = (SmoothingInfo)INFOS.get(item.id);
        if (info == null) {
            info = new SmoothingInfo();
            info.lastTraveledDistance = item.traveledDistance;
            info.wrongOffset = 0.0;
            INFOS.put(item.id, (Object)info);
        } else {
            info.wrongOffset += info.lastTraveledDistance - item.traveledDistance;
            info.lastTraveledDistance = item.traveledDistance;
        }
        info.resetTimer();
    }

    public static void onTickItem(ClientTravelingItem item) {
        SmoothingInfo info = (SmoothingInfo)INFOS.get(item.id);
        if (info == null) {
            return;
        }
        info.resetTimer();
        info.lastTraveledDistance = item.traveledDistance;
    }

    public static double getDistanceDelta(ClientTravelingItem item, float partialTick) {
        SmoothingInfo info = (SmoothingInfo)INFOS.get(item.id);
        if (info == null) {
            return 0.0;
        }
        return info.wrongOffset * ClientTravelingItemSmoothing.smooth(partialTick);
    }

    private static double smooth(double ticks) {
        return Math.exp(-0.15 * ticks);
    }

    public static long getClientTick() {
        return clientTick;
    }

    private static class SmoothingInfo {
        double lastTraveledDistance;
        double wrongOffset;
        int deadTimer;

        private SmoothingInfo() {
        }

        void resetTimer() {
            this.deadTimer = 10;
        }
    }
}

