/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.compat.emi;

import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.neoforge.NeoForgeEmiStack;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.emi.emi.api.widget.Bounds;
import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.attachment.upgrade.LoadedUpgrades;
import dev.technici4n.moderndynamics.client.compat.emi.DragDropHandler;
import dev.technici4n.moderndynamics.client.compat.emi.UpgradeRecipe;
import dev.technici4n.moderndynamics.client.screen.AttachedIoScreen;
import dev.technici4n.moderndynamics.gui.menu.FluidConfigSlot;
import dev.technici4n.moderndynamics.init.MdItems;
import dev.technici4n.moderndynamics.util.FluidVariant;
import java.util.List;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

@EmiEntrypoint
public class MdEmiPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        registry.addCategory(UpgradeRecipe.CATEGORY);
        for (AttachmentItem workstation : List.of(MdItems.ATTRACTOR, MdItems.EXTRACTOR, MdItems.FILTER)) {
            registry.addWorkstation(UpgradeRecipe.CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)workstation));
        }
        for (Item u : LoadedUpgrades.get().list) {
            registry.addRecipe((EmiRecipe)new UpgradeRecipe(u, LoadedUpgrades.getType(u)));
        }
        registry.addGenericExclusionArea((screen, bounds) -> {
            if (screen instanceof AttachedIoScreen) {
                AttachedIoScreen ioScreen = (AttachedIoScreen)screen;
                ioScreen.appendExclusionZones(r -> bounds.accept(new Bounds(r.getX(), r.getY(), r.getWidth(), r.getHeight())));
            }
        });
        registry.addGenericStackProvider((screen, mouseX, mouseY) -> {
            FluidConfigSlot fluidConfig;
            FluidVariant variant;
            AttachedIoScreen ioScreen;
            Slot patt0$temp;
            if (screen instanceof AttachedIoScreen && (patt0$temp = (ioScreen = (AttachedIoScreen)screen).getHoveredSlot()) instanceof FluidConfigSlot && !(variant = (fluidConfig = (FluidConfigSlot)patt0$temp).getFilter()).isBlank()) {
                return new EmiStackInteraction((EmiIngredient)NeoForgeEmiStack.of((FluidStack)variant.toStack(1000)), null, false);
            }
            return EmiStackInteraction.EMPTY;
        });
        registry.addGenericDragDropHandler((EmiDragDropHandler)new DragDropHandler());
    }
}

