/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.blockentity;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityCableConnectableInventory;
import org.cyclops.integratedscripting.RegistryEntries;
import org.cyclops.integratedscripting.core.network.ScriptingDriveNetworkElement;
import org.cyclops.integratedscripting.core.network.ScriptingNetworkHelpers;
import org.cyclops.integratedscripting.inventory.container.ContainerScriptingDrive;
import org.cyclops.integratedscripting.item.ItemScriptingDisk;

public class BlockEntityScriptingDrive
extends BlockEntityCableConnectableInventory
implements IDirtyMarkListener,
MenuProvider {
    public static final int ROWS = 1;
    public static final int COLS = 1;
    public static final int INVENTORY_SIZE = 1;
    private int exposedDiskId = -1;

    public BlockEntityScriptingDrive(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_SCRIPTING_DRIVE.get(), blockPos, blockState, 1, 1);
        this.getInventory().addDirtyMarkListener((IDirtyMarkListener)this);
    }

    public INetworkElementProvider getNetworkElementProvider() {
        return new NetworkElementProviderSingleton(){

            public INetworkElement createNetworkElement(Level world, BlockPos blockPos) {
                return new ScriptingDriveNetworkElement(DimPos.of((Level)world, (BlockPos)blockPos), () -> BlockEntityScriptingDrive.this.getExposedDiskId());
            }
        };
    }

    public void read(CompoundTag tag, HolderLookup.Provider provider) {
        super.read(tag, provider);
        this.exposedDiskId = tag.getInt("exposedDiskId");
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("exposedDiskId", this.exposedDiskId);
    }

    public int getExposedDiskId() {
        return this.exposedDiskId;
    }

    public void setExposedDiskId(int exposedDiskId) {
        int oldExposedDiskId = this.exposedDiskId;
        this.exposedDiskId = exposedDiskId;
        if (oldExposedDiskId != exposedDiskId) {
            this.onDirty();
            ScriptingNetworkHelpers.getScriptingNetwork(this.getNetwork()).ifPresent(scriptingNetwork -> {
                if (exposedDiskId == -1) {
                    scriptingNetwork.removeDisk(oldExposedDiskId);
                } else {
                    scriptingNetwork.addDisk(exposedDiskId);
                }
            });
        }
    }

    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize){

            public boolean canPlaceItem(int slot, ItemStack itemStack) {
                return super.canPlaceItem(slot, itemStack) && (itemStack.isEmpty() || itemStack.getItem() instanceof ItemScriptingDisk);
            }

            protected void onInventoryChanged() {
                super.onInventoryChanged();
                ItemStack itemStack = this.getItem(0);
                int id = -1;
                Item item = itemStack.getItem();
                if (item instanceof ItemScriptingDisk) {
                    ItemScriptingDisk itemScriptingDisk = (ItemScriptingDisk)item;
                    id = itemScriptingDisk.getOrCreateDiskId(itemStack);
                }
                BlockEntityScriptingDrive.this.setExposedDiskId(id);
            }
        };
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerScriptingDrive(id, playerInventory, (Container)this.getInventory());
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.integratedscripting.scripting_drive");
    }

    public static class CapabilityRegistrar
    extends BlockEntityCableConnectableInventory.CapabilityRegistrar<BlockEntityScriptingDrive> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntityScriptingDrive>> blockEntityType) {
            super(blockEntityType);
        }

        public void populate() {
            super.populate();
            this.add(Capabilities.ItemHandler.BLOCK, (blockEntity, context) -> blockEntity.getInventory().getItemHandler());
            this.add(Capabilities.NetworkElementProvider.BLOCK, (blockEntity, context) -> blockEntity.getNetworkElementProvider());
        }
    }
}

