/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalParserRecord;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TemporalParser {
    private static final String patternDate = "^([+\\-\\u2212]\\d\\d\\d\\d\\d\\d|\\d\\d\\d\\d)[\\-]?(\\d\\d)[\\-]?(\\d\\d)";
    private static final String patternTime = "^(\\d\\d)(:?(\\d\\d):?(?:(\\d\\d)(?:[\\.,]([\\d]*)?)?)?)?";
    private static final String patternCalendarName = "^(\\w*)$";
    private static final String patternTimeZoneBracketedAnnotation = "(\\[!?((?:[-+\\u2212](?:0[0-9]|1[0-9]|2[0-3])(?::?[0-5][0-9])?)|(?:[A-Za-z._][A-Za-z._0-9+-]*(?:/[A-Za-z._][A-Za-z._0-9+-]*)*))\\])";
    private static final String patternTimeZoneNumericUTCOffset = "^([+\\-\\u2212])(\\d\\d):?((\\d\\d):?(?:(\\d\\d)(?:[\\.,]([\\d]*)?)?)?)?";
    private static final String patternDateSpecYearMonth = "^([+\\-\\u2212]\\d\\d\\d\\d\\d\\d|\\d\\d\\d\\d)[\\-]?(\\d\\d)";
    private static final String patternDateSpecMonthDay = "^(?:\\-\\-)?(\\d\\d)[\\-]?(\\d\\d)";
    private static final String patternTimeZoneIANANameComponent = "^([A-Za-z_]+(/[A-Za-z\\-_]+)*)";
    private static final String patternAnnotation = "(\\[(!?)([a-z_][0-9a-z_-]*)=([A-Za-z0-9]+(?:-[A-Za-z0-9]+)*)\\])";
    private final JSContext context = JavaScriptLanguage.get(null).getJSContext();
    private static final TruffleString UC_T = Strings.constant("T");
    private static final TruffleString T = Strings.constant("t");
    private static final TruffleString U_CA_EQUALS = Strings.constant("u-ca=");
    private static final TruffleString ETC_GMT = Strings.constant("Etc/GMT");
    private static final TruffleString SIX_ZEROS = Strings.constant("000000");
    private final TruffleString input;
    private TruffleString rest;
    private int pos;
    private TruffleString year;
    private TruffleString month;
    private TruffleString day;
    private TruffleString hour;
    private TruffleString minute;
    private TruffleString second;
    private TruffleString fraction;
    private TruffleString calendar;
    private TruffleString timeZoneIANAName;
    private TruffleString timeZoneUTCOffsetName;
    private TruffleString timeZoneNumericUTCOffset;
    private TruffleString timeZoneEtcName;
    private TruffleString utcDesignator;
    private TruffleString offsetSign;
    private TruffleString offsetHour;
    private TruffleString offsetMinute;
    private TruffleString offsetSecond;
    private TruffleString offsetFraction;

    public TemporalParser(TruffleString input) {
        this.input = input;
    }

    public JSTemporalParserRecord parseISODateTime() {
        JSTemporalParserRecord rec = this.parseCalendarDateTime();
        if (rec != null) {
            return rec;
        }
        rec = this.parseCalendarTime();
        if (rec != null) {
            return rec;
        }
        rec = this.parseCalendarDateTimeTimeRequired();
        if (rec != null) {
            return rec;
        }
        rec = this.parseDateSpecYearMonth();
        if (rec != null) {
            return rec;
        }
        rec = this.parseDateSpecMonthDay();
        if (rec != null) {
            return rec;
        }
        rec = this.parseTemporalInstantString();
        if (rec != null) {
            return rec;
        }
        rec = this.parseZonedDateTimeString();
        if (rec != null) {
            return rec;
        }
        return null;
    }

    private JSTemporalParserRecord parseCalendarTime() {
        boolean hasTimeDesignator;
        this.reset();
        boolean bl = hasTimeDesignator = Strings.startsWith(this.rest, UC_T) || Strings.startsWith(this.rest, T);
        if (hasTimeDesignator) {
            this.move(1);
        }
        if (this.tryParseTimeSpec()) {
            this.parseTimeZone();
            boolean hasCalendar = this.parseCalendar();
            if ((hasTimeDesignator || hasCalendar) && this.atEnd()) {
                return this.result();
            }
        }
        this.reset();
        JSTemporalParserRecord rec = this.parseTimeSpecWithOptionalTimeZoneNotAmbiguous();
        return rec;
    }

    private JSTemporalParserRecord parseTimeSpecWithOptionalTimeZoneNotAmbiguous() {
        this.reset();
        if (this.tryParseHour()) {
            this.tryParseTimeZoneNumericUTCOffset(true);
            this.tryParseTimeZoneBracketedAnnotation();
            if (this.atEnd()) {
                return this.result();
            }
        }
        this.reset();
        if (this.tryParseTimeHourNotValidMonth() && this.parseTimeZone() && this.atEnd()) {
            return this.result();
        }
        this.reset();
        TruffleString previousRest = this.rest;
        if (this.tryParseTimeSpec()) {
            long h2 = TemporalParser.getNumber(this.hour);
            long min = TemporalParser.getNumber(this.minute);
            long s2 = TemporalParser.getNumber(this.second);
            if (s2 < 0L && Strings.length(previousRest) >= 3 && Strings.charAt(previousRest, 2) == ':' && TemporalParser.isValidMinute(min)) {
                this.parseTimeZone();
                if (this.atEnd()) {
                    return this.result();
                }
            }
            if (s2 < 0L && Strings.length(previousRest) >= 3 && Strings.charAt(previousRest, 2) != ':') {
                boolean ok = false;
                if ((h2 == 0L || 13L <= h2 && h2 <= 23L) && TemporalParser.isValidMinute(min)) {
                    ok = true;
                }
                if (TemporalParser.isValidHour(h2) && (min == 0L || 32L <= min && min <= 60L)) {
                    ok = true;
                }
                if (min == 31L && (h2 == 2L || h2 == 4L || h2 == 6L || h2 == 9L || h2 == 11L)) {
                    ok = true;
                }
                if (h2 == 2L && min == 30L) {
                    ok = true;
                }
                if (ok) {
                    this.tryParseTimeZoneBracketedAnnotation();
                    if (this.atEnd()) {
                        return this.result();
                    }
                }
            }
            if (s2 < 0L && this.tryParseTimeZoneNumericUTCOffset(true)) {
                this.tryParseTimeZoneBracketedAnnotation();
                if (this.atEnd()) {
                    return this.result();
                }
            }
            if (this.tryParseNegativeTimeHourNotValidMonth()) {
                this.tryParseTimeZoneBracketedAnnotation();
                if (this.atEnd()) {
                    return this.result();
                }
            }
            if (Strings.length(previousRest) > 5 && Strings.charAt(previousRest, 2) == ':' && Strings.charAt(previousRest, 5) == ':') {
                this.parseTimeZone();
                if (this.atEnd()) {
                    return this.result();
                }
            }
            if (Strings.length(previousRest) > 2 && Strings.charAt(previousRest, 2) != ':' && (s2 == 0L || 13L <= s2 && s2 <= 60L)) {
                this.parseTimeZone();
                if (this.atEnd()) {
                    return this.result();
                }
            }
            if (Strings.length(previousRest) > 2 && Strings.charAt(previousRest, 2) != ':' && this.fraction != null) {
                this.parseTimeZone();
                if (this.atEnd()) {
                    return this.result();
                }
            }
        }
        return null;
    }

    private boolean tryParseNegativeTimeHourNotValidMonth() {
        int h2;
        if (Strings.length(this.rest) > 0 && Strings.charAt(this.rest, 0) == '-' && (0 == (h2 = this.parseTwoDigits(1)) || 13 <= h2 && h2 <= 23)) {
            this.offsetHour = Strings.lazySubstring(this.rest, 1, 2);
            this.move(3);
            return true;
        }
        return false;
    }

    private static boolean isValidMinute(long min) {
        return 0L <= min && min <= 59L;
    }

    private static boolean isValidHour(long h2) {
        return 0L <= h2 && h2 <= 23L;
    }

    private static long getNumber(TruffleString s2) {
        if (s2 == null) {
            return -1L;
        }
        try {
            return Strings.parseLong(s2);
        }
        catch (TruffleString.NumberFormatException ex) {
            return -1L;
        }
    }

    private boolean tryParseHour() {
        int num = this.parseTwoDigits(0);
        if (0 <= num && num <= 23) {
            this.hour = Strings.lazySubstring(this.rest, 0, 2);
            this.move(2);
            return true;
        }
        return false;
    }

    private boolean tryParseTimeHourNotValidMonth() {
        int num = this.parseTwoDigits(0);
        if (num == 0 || 13 <= num && num <= 23) {
            this.hour = Strings.lazySubstring(this.rest, 0, 2);
            this.move(2);
            return true;
        }
        return false;
    }

    private int parseTwoDigits(int at) {
        if (Strings.length(this.rest) >= at + 2) {
            char next0 = Strings.charAt(this.rest, at + 0);
            char next1 = Strings.charAt(this.rest, at + 1);
            if (TemporalParser.isDigit(next0) && TemporalParser.isDigit(next1)) {
                return TemporalParser.toDigit(next0) * 10 + TemporalParser.toDigit(next1);
            }
        }
        return -1;
    }

    private static boolean isDigit(char c2) {
        return '0' <= c2 && c2 <= '9';
    }

    private static int toDigit(char c2) {
        assert (TemporalParser.isDigit(c2));
        return c2 - 48;
    }

    public JSTemporalParserRecord parseCalendarDateTime() {
        this.reset();
        if (this.parseDateTime()) {
            this.parseCalendar();
            if (this.atEnd()) {
                return this.result();
            }
        }
        return null;
    }

    private boolean parseDateTime() {
        if (!this.parseDate()) {
            return false;
        }
        if (this.parseTimeSpecSeparator(false)) {
            this.tryParseTimeZoneUTCOffset();
        }
        this.tryParseTimeZoneBracketedAnnotation();
        return true;
    }

    private JSTemporalParserRecord parseCalendarDateTimeTimeRequired() {
        this.reset();
        if (this.parseDate()) {
            if (!this.parseTimeSpecSeparator(false)) {
                return null;
            }
            this.parseTimeZone();
            this.parseCalendar();
            if (this.atEnd()) {
                return this.result();
            }
        }
        return null;
    }

    private boolean parseTimeSpecSeparator(boolean optional) {
        int posBackup = this.pos;
        TruffleString restBackup = this.rest;
        if (!this.tryParseDateTimeSeparator()) {
            return optional;
        }
        if (!this.tryParseTimeSpec()) {
            this.pos = posBackup;
            this.rest = restBackup;
            return false;
        }
        return true;
    }

    public JSTemporalParserRecord parseYearMonth() {
        JSTemporalParserRecord rec = this.parseDateSpecYearMonth();
        if (rec != null) {
            return rec;
        }
        rec = this.parseCalendarDateTime();
        if (rec != null) {
            return rec;
        }
        return null;
    }

    private JSTemporalParserRecord parseDateSpecYearMonth() {
        this.reset();
        if (this.tryParseDateSpecYearMonth() && this.atEnd()) {
            return this.result();
        }
        return null;
    }

    public JSTemporalParserRecord parseMonthDay() {
        JSTemporalParserRecord rec = this.parseDateSpecMonthDay();
        if (rec != null) {
            return rec;
        }
        rec = this.parseCalendarDateTime();
        if (rec != null) {
            return rec;
        }
        return null;
    }

    private JSTemporalParserRecord parseDateSpecMonthDay() {
        this.reset();
        if (this.tryParseDateSpecMonthDay() && this.atEnd()) {
            return this.result();
        }
        return null;
    }

    private boolean parseTimeZoneIANAName() {
        TruffleString ianaName = this.rest;
        if (Strings.startsWith(this.rest, ETC_GMT)) {
            this.move(Strings.length(ETC_GMT));
            if (Strings.charAt(this.rest, 0) == '+' || Strings.charAt(this.rest, 0) == '-') {
                this.move(1);
                try {
                    int unpaddedHour = this.rest.parseIntUncached();
                    if (0 <= unpaddedHour && unpaddedHour <= 23) {
                        this.timeZoneIANAName = ianaName;
                        return true;
                    }
                }
                catch (TruffleString.NumberFormatException unpaddedHour) {
                    // empty catch block
                }
            }
        }
        this.reset();
        Matcher matcher = TemporalParser.createMatch(patternTimeZoneIANANameComponent, this.rest);
        if (matcher.matches()) {
            this.timeZoneIANAName = this.group(this.rest, matcher, 1);
            assert (this.timeZoneIANAName == null || TemporalParser.isTZLeadingChar(Strings.charAt(this.timeZoneIANAName, 0)));
            this.move(matcher.end(1));
            return true;
        }
        return false;
    }

    public JSTemporalParserRecord parseTimeZoneNumericUTCOffset() {
        this.reset();
        if (this.tryParseTimeZoneNumericUTCOffset(false) && this.atEnd()) {
            return this.result();
        }
        return null;
    }

    public JSTemporalParserRecord parseCalendarString() {
        JSTemporalParserRecord rec = this.parseCalendarName();
        if (rec != null) {
            return rec;
        }
        rec = this.parseTemporalInstantString();
        if (rec != null) {
            return rec;
        }
        rec = this.parseCalendarDateTime();
        if (rec != null) {
            return rec;
        }
        rec = this.parseCalendarTime();
        if (rec != null) {
            return rec;
        }
        rec = this.parseDateSpecYearMonth();
        if (rec != null) {
            return rec;
        }
        rec = this.parseDateSpecMonthDay();
        if (rec != null) {
            return rec;
        }
        return null;
    }

    private JSTemporalParserRecord parseTemporalInstantString() {
        this.reset();
        if (this.parseDate() && this.parseTimeSpecSeparator(true) && this.tryParseTimeZoneOffsetRequired() && this.atEnd()) {
            return this.result();
        }
        return null;
    }

    private boolean tryParseTimeZoneOffsetRequired() {
        if (!this.tryParseTimeZoneUTCOffset()) {
            return false;
        }
        this.tryParseTimeZoneBracketedAnnotation();
        return true;
    }

    private JSTemporalParserRecord parseCalendarName() {
        this.reset();
        if (this.tryParseCalendarName()) {
            return this.result();
        }
        return null;
    }

    private JSTemporalParserRecord parseZonedDateTimeString() {
        this.reset();
        if (this.parseDate()) {
            this.tryParseDateTimeSeparator();
            this.tryParseTimeSpec();
            if (!this.tryParseTimeZoneNameRequired()) {
                return null;
            }
            this.parseCalendar();
            if (this.atEnd()) {
                return this.result();
            }
        }
        return null;
    }

    public boolean isTemporalZonedDateTimeString() {
        return this.parseZonedDateTimeString() != null;
    }

    public boolean isTemporalDateTimeString() {
        this.reset();
        JSTemporalParserRecord rec = this.parseCalendarDateTime();
        return rec != null;
    }

    private boolean tryParseTimeZoneNameRequired() {
        this.tryParseTimeZoneUTCOffset();
        return this.tryParseTimeZoneBracketedAnnotation();
    }

    private boolean tryParseCalendarName() {
        Matcher matcher = TemporalParser.createMatch(patternCalendarName, this.rest);
        if (matcher.matches()) {
            this.calendar = this.group(this.rest, matcher, 1);
            this.move(matcher.end(1));
            return true;
        }
        return false;
    }

    public JSTemporalParserRecord result() {
        try {
            return new JSTemporalParserRecord(this.utcDesignator != null, TemporalParser.prepare(this.year, Long.MAX_VALUE, true), TemporalParser.prepare(this.month, 12L), TemporalParser.prepare(this.day, 31L), TemporalParser.prepare(this.hour, 23L), TemporalParser.prepare(this.minute, 59L), TemporalParser.prepare(this.second, 60L), this.fraction, this.offsetSign, TemporalParser.prepare(this.offsetHour, 23L), TemporalParser.prepare(this.offsetMinute, 59L), TemporalParser.prepare(this.offsetSecond, 59L), this.offsetFraction, this.timeZoneIANAName, this.timeZoneEtcName, this.timeZoneUTCOffsetName, this.calendar, this.timeZoneNumericUTCOffset);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static long prepare(TruffleString value, long max) {
        return TemporalParser.prepare(value, max, false);
    }

    private static long prepare(TruffleString value, long max, boolean canBeNegative) {
        if (value == null) {
            return Long.MIN_VALUE;
        }
        long l2 = 0L;
        try {
            l2 = Strings.parseLong(value);
        }
        catch (TruffleString.NumberFormatException e2) {
            throw CompilerDirectives.shouldNotReachHere(e2);
        }
        if (!canBeNegative && l2 < 0L || l2 > max) {
            throw new RuntimeException("date value out of bounds");
        }
        return l2;
    }

    private boolean atEnd() {
        return this.pos >= Strings.length(this.input);
    }

    private void reset() {
        this.pos = 0;
        this.rest = this.input;
        this.year = null;
        this.month = null;
        this.day = null;
        this.hour = null;
        this.minute = null;
        this.second = null;
        this.fraction = null;
        this.calendar = null;
        this.timeZoneIANAName = null;
        this.timeZoneUTCOffsetName = null;
        this.timeZoneNumericUTCOffset = null;
        this.timeZoneEtcName = null;
        this.utcDesignator = null;
        this.offsetSign = null;
        this.offsetHour = null;
        this.offsetMinute = null;
        this.offsetSecond = null;
        this.offsetFraction = null;
    }

    private void move(int newPos) {
        this.pos += newPos;
        this.rest = this.pos >= 0 && Strings.length(this.input) > this.pos ? Strings.lazySubstring(this.input, this.pos) : Strings.EMPTY_STRING;
    }

    private boolean tryParseDateSpecYearMonth() {
        Matcher matcher = TemporalParser.createMatch(patternDateSpecYearMonth, this.rest);
        if (matcher.matches()) {
            this.year = this.group(this.rest, matcher, 1);
            this.month = this.group(this.rest, matcher, 2);
            if (Strings.charAt(this.year, 0) == '\u2212') {
                this.year = Strings.concat(Strings.DASH, Strings.lazySubstring(this.year, 1));
            }
            this.move(matcher.end(2));
            return true;
        }
        return false;
    }

    private boolean tryParseDateSpecMonthDay() {
        Matcher matcher = TemporalParser.createMatch(patternDateSpecMonthDay, this.rest);
        if (matcher.matches()) {
            this.month = this.group(this.rest, matcher, 1);
            this.day = this.group(this.rest, matcher, 2);
            this.move(matcher.end(2));
            return true;
        }
        return false;
    }

    private boolean parseDate() {
        Matcher matcher = TemporalParser.createMatch(patternDate, this.rest);
        if (matcher.matches()) {
            this.year = this.group(this.rest, matcher, 1);
            this.month = this.group(this.rest, matcher, 2);
            this.day = this.group(this.rest, matcher, 3);
            char yearCh0 = Strings.charAt(this.year, 0);
            if ((yearCh0 == '-' || yearCh0 == '\u2212') && Strings.startsWith(this.year, SIX_ZEROS, 1)) {
                return false;
            }
            if (yearCh0 == '\u2212') {
                this.year = Strings.concat(Strings.DASH, Strings.lazySubstring(this.year, 1));
            }
            this.move(matcher.end(3));
            return true;
        }
        return false;
    }

    private boolean tryParseTimeSpec() {
        Matcher matcher = TemporalParser.createMatch(patternTime, this.rest);
        if (matcher.matches()) {
            this.hour = this.group(this.rest, matcher, 1);
            this.minute = this.group(this.rest, matcher, 3);
            this.second = this.group(this.rest, matcher, 4);
            this.fraction = this.group(this.rest, matcher, 5);
            this.move(matcher.end(2) < 0 ? matcher.end(1) : matcher.end(2));
            return true;
        }
        return false;
    }

    private boolean tryParseDateTimeSeparator() {
        if (Strings.length(this.rest) <= 0) {
            return false;
        }
        char ch = Strings.charAt(this.rest, 0);
        if (ch == 't' || ch == 'T' || ch == ' ') {
            this.move(1);
            return true;
        }
        return false;
    }

    private boolean parseCalendar() {
        Matcher matcher;
        String foundCalendar = null;
        boolean calendarWasCritical = false;
        while ((matcher = TemporalParser.createMatch(patternAnnotation, this.rest)).matches()) {
            boolean critical;
            String key = matcher.group(3);
            boolean bl = critical = !matcher.group(2).isEmpty();
            if ("u-ca".equals(key)) {
                if (this.calendar == null) {
                    foundCalendar = matcher.group(4).toLowerCase();
                    this.calendar = this.group(this.rest, matcher, 4);
                    calendarWasCritical = critical;
                } else {
                    if (!"iso8601".equals(foundCalendar)) {
                        return false;
                    }
                    if (critical || calendarWasCritical) {
                        return false;
                    }
                }
            } else if (critical) {
                return false;
            }
            this.move(matcher.end(1));
        }
        return this.calendar != null;
    }

    private boolean parseTimeZone() {
        if (this.tryParseTimeZoneUTCOffset()) {
            this.tryParseTimeZoneBracketedAnnotation();
            if (this.atEnd()) {
                return true;
            }
        }
        return this.tryParseTimeZoneBracketedAnnotation();
    }

    private boolean tryParseTimeZoneUTCOffset() {
        if (this.tryParseTimeZoneNumericUTCOffset(false)) {
            return true;
        }
        return this.tryParseUTCDesignator();
    }

    private boolean tryParseUTCDesignator() {
        if (Strings.startsWith(this.rest, Strings.UC_Z) || Strings.startsWith(this.rest, Strings.Z)) {
            this.move(1);
            this.timeZoneIANAName = TemporalConstants.UTC;
            this.utcDesignator = Strings.Z;
            return true;
        }
        return false;
    }

    private boolean tryParseTimeZoneNumericUTCOffset(boolean nonAmbiguous) {
        Matcher matcher = TemporalParser.createMatch(patternTimeZoneNumericUTCOffset, this.rest, true);
        if (matcher.matches()) {
            this.offsetSign = this.group(this.rest, matcher, 1);
            this.offsetHour = this.group(this.rest, matcher, 2);
            this.offsetMinute = this.group(this.rest, matcher, 4);
            this.offsetSecond = this.group(this.rest, matcher, 5);
            this.offsetFraction = this.group(this.rest, matcher, 6);
            this.timeZoneNumericUTCOffset = Strings.substring(this.context, this.rest, matcher.start(1), matcher.end(3) != -1 ? matcher.end(3) : Strings.length(this.rest));
            if (this.offsetHour == null) {
                return false;
            }
            if (nonAmbiguous && matcher.start(3) < 0 && Strings.charAt(this.rest, 0) == '-') {
                return false;
            }
            this.move(this.offsetMinute != null ? matcher.end(3) : matcher.end(2));
            return true;
        }
        return false;
    }

    public JSTemporalParserRecord parseTimeZoneIdentifier() {
        this.reset();
        if (this.tryParseTimeZoneIdentifier() && this.atEnd()) {
            return this.result();
        }
        return null;
    }

    private boolean tryParseTimeZoneIdentifier() {
        this.reset();
        if (this.parseTimeZoneIANAName()) {
            return true;
        }
        this.reset();
        if (this.tryParseTimeZoneNumericUTCOffset(false)) {
            return this.offsetSecond == null && this.offsetFraction == null;
        }
        return false;
    }

    private boolean tryParseTimeZoneBracketedAnnotation() {
        Matcher matcher = TemporalParser.createMatch(patternTimeZoneBracketedAnnotation, this.rest);
        if (matcher.matches()) {
            TruffleString content = this.group(this.rest, matcher, 2);
            if (Strings.startsWith(content, U_CA_EQUALS)) {
                return false;
            }
            if (content != null) {
                if (Strings.startsWith(content, Strings.UC_ETC)) {
                    this.timeZoneEtcName = content;
                } else if (TemporalParser.isSign(Strings.charAt(content, 0))) {
                    this.timeZoneUTCOffsetName = content;
                } else {
                    assert (TemporalParser.isTZLeadingChar(Strings.charAt(content, 0)));
                    this.timeZoneIANAName = content;
                }
            }
            this.move(matcher.end(1));
            return true;
        }
        return false;
    }

    private static boolean isTZLeadingChar(char c2) {
        return 'a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z' || c2 == '.' || c2 == '_';
    }

    private static boolean isSign(char c2) {
        return c2 == '+' || c2 == '-' || c2 == '\u2212';
    }

    private static Matcher createMatch(String pattern, TruffleString input) {
        return TemporalParser.createMatch(pattern, input, true);
    }

    private static Matcher createMatch(String pattern, TruffleString input, boolean addMatchAll) {
        Pattern patternObj = Pattern.compile(pattern + (addMatchAll ? ".*" : ""));
        return patternObj.matcher(Strings.toJavaString(input));
    }

    private TruffleString group(TruffleString string, Matcher matcher, int groupNumber) {
        int start = matcher.start(groupNumber);
        return start < 0 ? null : Strings.substring(this.context, string, start, matcher.end(groupNumber) - start);
    }
}

