/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerThrowOnInfinityNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.temporal.CalendarMethodsRecordLookupNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarObjectNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;

public abstract class TemporalCalendarGetterNode
extends JavaScriptBaseNode {
    @Node.Child
    private CalendarMethodsRecordLookupNode getMethodNode;
    @Node.Child
    private JSToIntegerThrowOnInfinityNode toIntegerThrowOnInfinityNode;
    @Node.Child
    private JSToStringNode toStringNode;

    protected TemporalCalendarGetterNode() {
    }

    public abstract Object execute(Object var1, JSDynamicObject var2, CalendarMethodsRecordLookupNode.Key var3);

    public final Number executeInteger(Object calendar, JSDynamicObject dateLike, CalendarMethodsRecordLookupNode.Key key) {
        if (this.toIntegerThrowOnInfinityNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toIntegerThrowOnInfinityNode = this.insert(JSToIntegerThrowOnInfinityNode.create());
        }
        return (Number)this.toIntegerThrowOnInfinityNode.execute(this.execute(calendar, dateLike, key));
    }

    public final TruffleString executeString(Object calendar, JSDynamicObject dateLike, CalendarMethodsRecordLookupNode.Key key) {
        if (this.toStringNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toStringNode = this.insert(JSToStringNode.create());
        }
        return this.toStringNode.executeString(this.execute(calendar, dateLike, key));
    }

    @Specialization
    protected Object calendarGetter(Object calendarSlotValue, JSDynamicObject dateLike, CalendarMethodsRecordLookupNode.Key key, @Cached ToTemporalCalendarObjectNode toCalendarObject, @Cached(value="createCall()") JSFunctionCallNode callNode) {
        Object calendar = toCalendarObject.execute(calendarSlotValue);
        Object fn = this.getMethod(calendarSlotValue, key);
        return callNode.executeCall(JSArguments.create(calendar, fn, dateLike));
    }

    private Object getMethod(Object calendar, CalendarMethodsRecordLookupNode.Key key) {
        if (this.getMethodNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getMethodNode = this.insert(CalendarMethodsRecordLookupNode.create(key));
        }
        assert (this.getMethodNode.getKey() == key);
        return this.getMethodNode.execute(calendar);
    }
}

