/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.memory;

import com.oracle.truffle.api.memory.ByteArraySupport;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;

final class UnsafeByteArraySupport
extends ByteArraySupport {
    private static final Unsafe UNSAFE = AccessController.doPrivileged(new PrivilegedAction<Unsafe>(){

        @Override
        public Unsafe run() {
            assert (Unsafe.ARRAY_BYTE_INDEX_SCALE == 1) : "cannot use Unsafe for ByteArrayAccess if ARRAY_BYTE_INDEX_SCALE != 1";
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e2) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e2);
            }
        }
    });

    UnsafeByteArraySupport() {
    }

    @Override
    public byte getByte(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return UNSAFE.getByte(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + Integer.toUnsignedLong(byteOffset));
    }

    @Override
    public byte getByte(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        return UNSAFE.getByte(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset);
    }

    @Override
    public void putByte(byte[] buffer, int byteOffset, byte value) throws IndexOutOfBoundsException {
        UNSAFE.putByte(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + Integer.toUnsignedLong(byteOffset), value);
    }

    @Override
    public void putByte(byte[] buffer, long byteOffset, byte value) throws IndexOutOfBoundsException {
        UNSAFE.putByte(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset, value);
    }

    @Override
    public short getShort(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return UNSAFE.getShort(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + Integer.toUnsignedLong(byteOffset));
    }

    @Override
    public short getShort(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        return UNSAFE.getShort(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset);
    }

    @Override
    public void putShort(byte[] buffer, int byteOffset, short value) throws IndexOutOfBoundsException {
        UNSAFE.putShort(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + Integer.toUnsignedLong(byteOffset), value);
    }

    @Override
    public void putShort(byte[] buffer, long byteOffset, short value) throws IndexOutOfBoundsException {
        UNSAFE.putShort(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset, value);
    }

    @Override
    public int getInt(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return UNSAFE.getInt(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + Integer.toUnsignedLong(byteOffset));
    }

    @Override
    public int getInt(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        return UNSAFE.getInt(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset);
    }

    @Override
    public void putInt(byte[] buffer, int byteOffset, int value) throws IndexOutOfBoundsException {
        UNSAFE.putInt(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + Integer.toUnsignedLong(byteOffset), value);
    }

    @Override
    public void putInt(byte[] buffer, long byteOffset, int value) throws IndexOutOfBoundsException {
        UNSAFE.putInt(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset, value);
    }

    @Override
    public long getLong(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return UNSAFE.getLong(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + Integer.toUnsignedLong(byteOffset));
    }

    @Override
    public long getLong(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        return UNSAFE.getLong(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset);
    }

    @Override
    public void putLong(byte[] buffer, int byteOffset, long value) throws IndexOutOfBoundsException {
        UNSAFE.putLong(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + Integer.toUnsignedLong(byteOffset), value);
    }

    @Override
    public void putLong(byte[] buffer, long byteOffset, long value) throws IndexOutOfBoundsException {
        UNSAFE.putLong(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset, value);
    }

    @Override
    public float getFloat(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return UNSAFE.getFloat(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + Integer.toUnsignedLong(byteOffset));
    }

    @Override
    public float getFloat(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        return UNSAFE.getFloat(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset);
    }

    @Override
    public void putFloat(byte[] buffer, int byteOffset, float value) throws IndexOutOfBoundsException {
        UNSAFE.putFloat(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + Integer.toUnsignedLong(byteOffset), value);
    }

    @Override
    public void putFloat(byte[] buffer, long byteOffset, float value) throws IndexOutOfBoundsException {
        UNSAFE.putFloat(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset, value);
    }

    @Override
    public double getDouble(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return UNSAFE.getDouble(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + Integer.toUnsignedLong(byteOffset));
    }

    @Override
    public double getDouble(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        return UNSAFE.getDouble(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset);
    }

    @Override
    public void putDouble(byte[] buffer, int byteOffset, double value) throws IndexOutOfBoundsException {
        UNSAFE.putDouble(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + Integer.toUnsignedLong(byteOffset), value);
    }

    @Override
    public void putDouble(byte[] buffer, long byteOffset, double value) throws IndexOutOfBoundsException {
        UNSAFE.putDouble(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset, value);
    }

    @Override
    public byte getByteVolatile(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        return UNSAFE.getByteVolatile(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset);
    }

    @Override
    public void putByteVolatile(byte[] buffer, long byteOffset, byte value) throws IndexOutOfBoundsException {
        UNSAFE.putByteVolatile(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset, value);
    }

    @Override
    public short getShortVolatile(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        return UNSAFE.getShortVolatile(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset);
    }

    @Override
    public void putShortVolatile(byte[] buffer, long byteOffset, short value) throws IndexOutOfBoundsException {
        UNSAFE.putShortVolatile(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset, value);
    }

    @Override
    public int getIntVolatile(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        return UNSAFE.getIntVolatile(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset);
    }

    @Override
    public void putIntVolatile(byte[] buffer, long byteOffset, int value) throws IndexOutOfBoundsException {
        UNSAFE.putIntVolatile(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset, value);
    }

    @Override
    public long getLongVolatile(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        return UNSAFE.getLongVolatile(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset);
    }

    @Override
    public void putLongVolatile(byte[] buffer, long byteOffset, long value) throws IndexOutOfBoundsException {
        UNSAFE.putLongVolatile(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset, value);
    }

    @Override
    public byte getAndAddByte(byte[] buffer, long byteOffset, byte delta) throws IndexOutOfBoundsException {
        byte v2;
        while (this.compareAndExchangeByte(buffer, byteOffset, v2 = this.getByteVolatile(buffer, byteOffset), (byte)(v2 + delta)) != v2) {
        }
        return v2;
    }

    @Override
    public short getAndAddShort(byte[] buffer, long byteOffset, short delta) throws IndexOutOfBoundsException {
        short v2;
        while (this.compareAndExchangeShort(buffer, byteOffset, v2 = this.getShortVolatile(buffer, byteOffset), (short)(v2 + delta)) != v2) {
        }
        return v2;
    }

    @Override
    public int getAndAddInt(byte[] buffer, long byteOffset, int delta) throws IndexOutOfBoundsException {
        return UNSAFE.getAndAddInt(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset, delta);
    }

    @Override
    public long getAndAddLong(byte[] buffer, long byteOffset, long delta) throws IndexOutOfBoundsException {
        return UNSAFE.getAndAddLong(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset, delta);
    }

    @Override
    public byte getAndBitwiseAndByte(byte[] buffer, long byteOffset, byte mask) throws IndexOutOfBoundsException {
        byte v2;
        while (this.compareAndExchangeByte(buffer, byteOffset, v2 = this.getByteVolatile(buffer, byteOffset), (byte)(v2 & mask)) != v2) {
        }
        return v2;
    }

    @Override
    public short getAndBitwiseAndShort(byte[] buffer, long byteOffset, short mask) throws IndexOutOfBoundsException {
        short v2;
        while (this.compareAndExchangeShort(buffer, byteOffset, v2 = this.getShortVolatile(buffer, byteOffset), (short)(v2 & mask)) != v2) {
        }
        return v2;
    }

    @Override
    public int getAndBitwiseAndInt(byte[] buffer, long byteOffset, int mask) throws IndexOutOfBoundsException {
        int v2;
        while (this.compareAndExchangeInt(buffer, byteOffset, v2 = this.getIntVolatile(buffer, byteOffset), v2 & mask) != v2) {
        }
        return v2;
    }

    @Override
    public long getAndBitwiseAndLong(byte[] buffer, long byteOffset, long mask) throws IndexOutOfBoundsException {
        long v2;
        while (this.compareAndExchangeLong(buffer, byteOffset, v2 = this.getLongVolatile(buffer, byteOffset), v2 & mask) != v2) {
        }
        return v2;
    }

    @Override
    public byte getAndBitwiseOrByte(byte[] buffer, long byteOffset, byte mask) throws IndexOutOfBoundsException {
        byte v2;
        while (this.compareAndExchangeByte(buffer, byteOffset, v2 = this.getByteVolatile(buffer, byteOffset), (byte)(v2 | mask)) != v2) {
        }
        return v2;
    }

    @Override
    public short getAndBitwiseOrShort(byte[] buffer, long byteOffset, short mask) throws IndexOutOfBoundsException {
        short v2;
        while (this.compareAndExchangeShort(buffer, byteOffset, v2 = this.getShortVolatile(buffer, byteOffset), (short)(v2 | mask)) != v2) {
        }
        return v2;
    }

    @Override
    public int getAndBitwiseOrInt(byte[] buffer, long byteOffset, int mask) throws IndexOutOfBoundsException {
        int v2;
        while (this.compareAndExchangeInt(buffer, byteOffset, v2 = this.getIntVolatile(buffer, byteOffset), v2 | mask) != v2) {
        }
        return v2;
    }

    @Override
    public long getAndBitwiseOrLong(byte[] buffer, long byteOffset, long mask) throws IndexOutOfBoundsException {
        long v2;
        while (this.compareAndExchangeLong(buffer, byteOffset, v2 = this.getLongVolatile(buffer, byteOffset), v2 | mask) != v2) {
        }
        return v2;
    }

    @Override
    public byte getAndBitwiseXorByte(byte[] buffer, long byteOffset, byte mask) throws IndexOutOfBoundsException {
        byte v2;
        while (this.compareAndExchangeByte(buffer, byteOffset, v2 = this.getByteVolatile(buffer, byteOffset), (byte)(v2 ^ mask)) != v2) {
        }
        return v2;
    }

    @Override
    public short getAndBitwiseXorShort(byte[] buffer, long byteOffset, short mask) throws IndexOutOfBoundsException {
        short v2;
        while (this.compareAndExchangeShort(buffer, byteOffset, v2 = this.getShortVolatile(buffer, byteOffset), (short)(v2 ^ mask)) != v2) {
        }
        return v2;
    }

    @Override
    public int getAndBitwiseXorInt(byte[] buffer, long byteOffset, int mask) throws IndexOutOfBoundsException {
        int v2;
        while (this.compareAndExchangeInt(buffer, byteOffset, v2 = this.getIntVolatile(buffer, byteOffset), v2 ^ mask) != v2) {
        }
        return v2;
    }

    @Override
    public long getAndBitwiseXorLong(byte[] buffer, long byteOffset, long mask) throws IndexOutOfBoundsException {
        long v2;
        while (this.compareAndExchangeLong(buffer, byteOffset, v2 = this.getLongVolatile(buffer, byteOffset), v2 ^ mask) != v2) {
        }
        return v2;
    }

    @Override
    public byte getAndSetByte(byte[] buffer, long byteOffset, byte newValue) throws IndexOutOfBoundsException {
        byte v2;
        while (this.compareAndExchangeByte(buffer, byteOffset, v2 = this.getByteVolatile(buffer, byteOffset), newValue) != v2) {
        }
        return v2;
    }

    @Override
    public short getAndSetShort(byte[] buffer, long byteOffset, short newValue) throws IndexOutOfBoundsException {
        short v2;
        while (this.compareAndExchangeShort(buffer, byteOffset, v2 = this.getShortVolatile(buffer, byteOffset), newValue) != v2) {
        }
        return v2;
    }

    @Override
    public int getAndSetInt(byte[] buffer, long byteOffset, int newValue) throws IndexOutOfBoundsException {
        return UNSAFE.getAndSetInt(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset, newValue);
    }

    @Override
    public long getAndSetLong(byte[] buffer, long byteOffset, long newValue) throws IndexOutOfBoundsException {
        return UNSAFE.getAndSetLong(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + byteOffset, newValue);
    }

    @Override
    public byte compareAndExchangeByte(byte[] buffer, long byteOffset, byte expected, byte x2) {
        int fullWord;
        long wordOffset = byteOffset & 0xFFFFFFFFFFFFFFFCL;
        int shift = (int)(byteOffset & 3L) << 3;
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            shift = 24 - shift;
        }
        int mask = 255 << shift;
        int maskedExpected = (expected & 0xFF) << shift;
        int maskedX = (x2 & 0xFF) << shift;
        do {
            if (((fullWord = this.getIntVolatile(buffer, wordOffset)) & mask) == maskedExpected) continue;
            return (byte)((fullWord & mask) >> shift);
        } while (!UNSAFE.compareAndSwapInt(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + wordOffset, fullWord, fullWord & ~mask | maskedX));
        return expected;
    }

    @Override
    public short compareAndExchangeShort(byte[] buffer, long byteOffset, short expected, short x2) {
        int fullWord;
        if ((byteOffset & 3L) == 3L) {
            throw new IllegalArgumentException("Update spans the word, not supported");
        }
        long wordOffset = byteOffset & 0xFFFFFFFFFFFFFFFCL;
        int shift = (int)(byteOffset & 3L) << 3;
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            shift = 16 - shift;
        }
        int mask = 65535 << shift;
        int maskedExpected = (expected & 0xFFFF) << shift;
        int maskedX = (x2 & 0xFFFF) << shift;
        do {
            if (((fullWord = this.getIntVolatile(buffer, wordOffset)) & mask) == maskedExpected) continue;
            return (short)((fullWord & mask) >> shift);
        } while (!UNSAFE.compareAndSwapInt(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + wordOffset, fullWord, fullWord & ~mask | maskedX));
        return expected;
    }

    @Override
    public int compareAndExchangeInt(byte[] buffer, long byteOffset, int expected, int x2) throws IndexOutOfBoundsException {
        int fullWord;
        if ((byteOffset & 3L) != 0L) {
            throw new IllegalArgumentException("Update spans the word, not supported");
        }
        long wordOffset = byteOffset & 0xFFFFFFFFFFFFFFFCL;
        do {
            if ((fullWord = this.getIntVolatile(buffer, wordOffset)) == expected) continue;
            return fullWord;
        } while (!UNSAFE.compareAndSwapInt(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + wordOffset, fullWord, x2));
        return expected;
    }

    @Override
    public long compareAndExchangeLong(byte[] buffer, long byteOffset, long expected, long x2) throws IndexOutOfBoundsException {
        long fullWord;
        if ((byteOffset & 7L) != 0L) {
            throw new IllegalArgumentException("Update spans the word, not supported");
        }
        long wordOffset = byteOffset & 0xFFFFFFFFFFFFFFF8L;
        do {
            if ((fullWord = this.getLongVolatile(buffer, wordOffset)) == expected) continue;
            return fullWord;
        } while (!UNSAFE.compareAndSwapLong(buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + wordOffset, fullWord, x2));
        return expected;
    }
}

