/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.animationcontroller;

import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationControllerEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationControllerElement;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.ElementSelectorScreen;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public class TargetElementManagerScreen
extends CellScreen {
    protected final AnimationControllerElement element;
    protected final LayoutEditorScreen parentLayoutEditor;
    protected final Consumer<List<AnimationControllerElement.TargetElement>> callback;
    protected final List<AnimationControllerElement.TargetElement> targets;

    public TargetElementManagerScreen(@NotNull AnimationControllerEditorElement editorElement, @NotNull Consumer<List<AnimationControllerElement.TargetElement>> callback) {
        super((Component)Component.translatable((String)"fancymenu.elements.animation_controller.manage_targets"));
        this.element = editorElement.getElement();
        this.parentLayoutEditor = editorElement.editor;
        this.callback = callback;
        this.targets = new ArrayList<AnimationControllerElement.TargetElement>(this.element.targetElements);
    }

    @Override
    protected void initCells() {
        this.addStartEndSpacerCell();
        this.addLabelCell((Component)Component.translatable((String)"fancymenu.elements.animation_controller.manage_targets.info").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(true))));
        this.addCellGroupEndSpacerCell();
        this.addCellGroupEndSpacerCell();
        if (this.targets.isEmpty()) {
            this.addLabelCell((Component)Component.translatable((String)"fancymenu.elements.animation_controller.manage_targets.no_targets").setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().error_text_color.getColorInt())));
        } else {
            for (AnimationControllerElement.TargetElement target : this.targets) {
                AbstractEditorElement e = this.parentLayoutEditor.getElementByInstanceIdentifier(target.targetElementId);
                MutableComponent label = e != null ? e.element.getDisplayName().copy() : Component.literal((String)"---");
                label = label.setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().warning_text_color.getColorInt()));
                label = label.append((Component)Component.literal((String)(" [" + target.targetElementId + "]")).setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().generic_text_base_color.getColorInt())));
                this.addLabelCell((Component)label);
            }
        }
        this.addStartEndSpacerCell();
    }

    @Override
    protected void initRightSideWidgets() {
        this.addRightSideButton(20, (Component)Component.translatable((String)"fancymenu.elements.animation_controller.manage_targets.add"), button -> {
            ElementSelectorScreen selector = new ElementSelectorScreen(this.parentLayoutEditor, this, this.getElementIds(), selectedElement -> {
                if (selectedElement != null) {
                    String elementId = selectedElement.element.getInstanceIdentifier();
                    if (this.targets.stream().anyMatch(t -> t.targetElementId.equals(elementId))) {
                        Minecraft.getInstance().setScreen((Screen)ConfirmationScreen.warning(result -> Minecraft.getInstance().setScreen((Screen)this), LocalizationUtils.splitLocalizedLines("fancymenu.elements.animation_controller.manage_targets.already_exists", new String[0])));
                    } else {
                        this.targets.add(new AnimationControllerElement.TargetElement(elementId));
                        Minecraft.getInstance().setScreen((Screen)this);
                    }
                } else {
                    Minecraft.getInstance().setScreen((Screen)this);
                }
            });
            Minecraft.getInstance().setScreen((Screen)selector);
        });
        this.addRightSideButton(20, (Component)Component.translatable((String)"fancymenu.elements.animation_controller.manage_targets.remove"), button -> {
            ElementSelectorScreen selector = new ElementSelectorScreen(this.parentLayoutEditor, this, this.getElementIds(), selectedElement -> {
                if (selectedElement != null) {
                    String elementId = selectedElement.element.getInstanceIdentifier();
                    this.targets.removeIf(t -> t.targetElementId.equals(elementId));
                }
                Minecraft.getInstance().setScreen((Screen)this);
            }, element -> this.targets.stream().anyMatch(t -> t.targetElementId.equals(element.element.getInstanceIdentifier())));
            Minecraft.getInstance().setScreen((Screen)selector);
        });
        this.addRightSideDefaultSpacer();
    }

    protected List<String> getElementIds() {
        ArrayList<String> ids = new ArrayList<String>();
        this.targets.forEach(targetElement -> ids.add(targetElement.targetElementId));
        return ids;
    }

    @Override
    protected void onCancel() {
        this.callback.accept(null);
    }

    @Override
    protected void onDone() {
        this.callback.accept(this.targets);
    }
}

