/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.misc.tile;

import com.buuz135.industrial.block.misc.tile.EnchantmentApplicatorTile;
import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.misc.EnchantmentFactoryConfig;
import com.buuz135.industrial.gui.component.TextureScreenAddon;
import com.buuz135.industrial.module.ModuleMisc;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.WidgetScreenAddon;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.network.Message;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.instance.TileEntityLocatorInstance;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class EnchantmentFactoryTile
extends IndustrialProcessingTile<EnchantmentFactoryTile> {
    private static final int XP_30 = 1410;
    @Save
    private SidedFluidTankComponent<EnchantmentFactoryTile> tank = (SidedFluidTankComponent)new SidedFluidTankComponent("essence", EnchantmentFactoryConfig.tankSize, 34, 20, 0).setColor(DyeColor.LIME).setTankAction(FluidTankComponent.Action.FILL).setOnContentChange(() -> this.syncObject(this.tank)).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().is(IndustrialTags.Fluids.EXPERIENCE));
    @Save
    private SidedInventoryComponent<EnchantmentFactoryTile> inputFirst;
    @Save
    private SidedInventoryComponent<EnchantmentFactoryTile> output;
    @Save
    private int selectedLevel = 30;

    public EnchantmentFactoryTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleMisc.ENCHANTMENT_FACTORY, 100, 54, blockPos, blockState);
        this.addTank(this.tank);
        this.inputFirst = (SidedInventoryComponent)new SidedInventoryComponent("input", 70, 54, 1, 1).setColor(DyeColor.BLUE).setInputFilter((stack, integer) -> !this.isEnchanted((ItemStack)stack) && stack.isEnchantable() || stack.getItem().equals(Items.BOOK)).setSlotLimit(1).setOutputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.inputFirst);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 135, 54, 1, 2).setColor(DyeColor.ORANGE).setInputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.output);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new TextScreenAddon(Component.translatable((String)"text.industrialforegoing.display.enchantment_level").getString(), 60, 24, false));
        this.addGuiAddonFactory(() -> new TextScreenAddon(Component.translatable((String)"text.industrialforegoing.display.cost").getString(), 60, 38, false){

            public String getText() {
                return super.getText() + String.valueOf(ChatFormatting.DARK_GREEN) + new DecimalFormat().format(EnchantmentApplicatorTile.getEssenceConsumed(EnchantmentFactoryTile.this.selectedLevel)) + String.valueOf(ChatFormatting.DARK_GRAY) + "mb";
            }
        });
        this.addGuiAddonFactory(() -> {
            EditBox edit = new EditBox(Minecraft.getInstance().font, 80, 26, 40, 12, (Component)Component.literal((String)("" + this.selectedLevel))){

                public String getValue() {
                    return "" + EnchantmentFactoryTile.this.selectedLevel;
                }
            };
            edit.setValue("" + this.selectedLevel);
            edit.setFilter(string -> {
                if (string.isEmpty()) {
                    return true;
                }
                try {
                    Integer.decode(string);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            });
            edit.setResponder(string -> {
                if (!string.isEmpty()) {
                    CompoundTag compoundTag = new CompoundTag();
                    compoundTag.putInt("EnchantmentLevel", Integer.decode(string).intValue());
                    Titanium.NETWORK.sendToServer((Message)new ButtonClickNetworkMessage((LocatorInstance)new TileEntityLocatorInstance(this.getBlockPos()), 5487, compoundTag));
                }
            });
            return new WidgetScreenAddon(120, 22, (AbstractWidget)edit);
        });
        ResourceLocation res = ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"textures/gui/machines.png");
        this.addGuiAddonFactory(() -> new TextureScreenAddon(this, 158, 4, 14, 14, res, 96, 233){

            @Override
            public List<Component> getTooltipLines() {
                ArrayList<Component> components = new ArrayList<Component>();
                components.add((Component)Component.translatable((String)"text.industrialforegoing.tooltip.accepts_fluid_on_top"));
                return components;
            }
        });
    }

    public void handleButtonMessage(int id, Player playerEntity, CompoundTag compound) {
        super.handleButtonMessage(id, playerEntity, compound);
        if (id == 5487) {
            this.selectedLevel = compound.getInt("EnchantmentLevel");
            this.syncObject(this.selectedLevel);
        }
    }

    @Override
    public boolean canIncrease() {
        long amount = this.tank.getFluidAmount();
        IFluidHandler capability = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.worldPosition.above(), (Object)Direction.DOWN);
        if (capability != null) {
            amount += (long)EnchantmentApplicatorTile.getMatchingAmount(capability);
        }
        return this.selectedLevel > 0 && amount >= (long)EnchantmentApplicatorTile.getEssenceConsumed(this.selectedLevel) && !this.inputFirst.getStackInSlot(0).isEmpty() && this.output.getStackInSlot(0).isEmpty();
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            ItemStack output = EnchantmentHelper.enchantItem((RandomSource)this.level.random, (ItemStack)this.inputFirst.getStackInSlot(0).copy(), (int)this.selectedLevel, (RegistryAccess)this.level.registryAccess(), Optional.empty());
            this.inputFirst.setStackInSlot(0, ItemStack.EMPTY);
            this.output.setStackInSlot(0, output);
            int amount = EnchantmentApplicatorTile.getEssenceConsumed(this.selectedLevel);
            IFluidHandler capability = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.worldPosition.above(), (Object)Direction.DOWN);
            if (capability != null) {
                amount = EnchantmentApplicatorTile.drainAmount(amount, capability);
            }
            if (amount > 0) {
                this.tank.drainForced(amount, IFluidHandler.FluidAction.EXECUTE);
            }
        };
    }

    @Override
    protected int getTickPower() {
        return EnchantmentFactoryConfig.powerPerTick;
    }

    public EnchantmentFactoryTile getSelf() {
        return this;
    }

    private boolean isEnchanted(ItemStack stack) {
        return stack.isEnchanted() || stack.getItem() instanceof EnchantedBookItem;
    }

    protected EnergyStorageComponent<EnchantmentFactoryTile> createEnergyStorage() {
        return new EnergyStorageComponent(EnchantmentFactoryConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return EnchantmentFactoryConfig.maxProgress;
    }

    @Override
    public void loadSettings(Player player, CompoundTag tag) {
        super.loadSettings(player, tag);
        this.selectedLevel = tag.getInt("SelectedLevel");
    }

    @Override
    public void saveSettings(Player player, CompoundTag tag) {
        super.saveSettings(player, tag);
        tag.putInt("SelectedLevel", this.selectedLevel);
    }
}

