/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.datagen.assets;

import com.satherov.crystalix.content.CrystalixRegistry;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class CrystalixBlockModelProvider
extends BlockModelProvider {
    public CrystalixBlockModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "crystalix", existingFileHelper);
    }

    protected void registerModels() {
        CrystalixRegistry.BLOCKS_MAP.forEach((color, set) -> set.forEach((type, block) -> {
            this.shadedBlock((DeferredHolder<Block, ? extends Block>)block, (DyeColor)color, (CrystalixRegistry.BlockTypes)((Object)((Object)type)));
            this.shadelessBlock((DeferredHolder<Block, ? extends Block>)block, (DyeColor)color, (CrystalixRegistry.BlockTypes)((Object)((Object)type)));
        }));
    }

    private void shadedBlock(DeferredHolder<Block, ? extends Block> block, DyeColor color, CrystalixRegistry.BlockTypes type) {
        ((BlockModelBuilder)this.singleTexture("block/" + type.getSerializedName() + "/" + block.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"block/cube_all"), "all", this.modLoc("block/" + type.getSerializedName() + "/" + color.getName()))).renderType(RenderType.translucent().name);
    }

    private void shadelessBlock(DeferredHolder<Block, ? extends Block> block, DyeColor color, CrystalixRegistry.BlockTypes type) {
        ((BlockModelBuilder)this.singleTexture("block/" + type.getSerializedName() + "/" + block.getId().getPath() + "_no_shade", this.modLoc("block/no_shade_block"), "all", this.modLoc("block/" + type.getSerializedName() + "/" + color.getName()))).renderType(RenderType.translucent().name);
    }
}

