/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.datagen;

import com.satherov.crystalix.datagen.CrystalixDataProvider;
import com.satherov.crystalix.datagen.assets.CrystalixBlockModelProvider;
import com.satherov.crystalix.datagen.assets.CrystalixBlockStateProvider;
import com.satherov.crystalix.datagen.assets.CrystalixFusionModelProvider;
import com.satherov.crystalix.datagen.assets.CrystalixItemModelProvider;
import com.satherov.crystalix.datagen.assets.lang.EN_USProvider;
import com.satherov.crystalix.datagen.data.CrystalixLootTableProvider;
import com.satherov.crystalix.datagen.data.CrystalixRecipeProvider;
import com.satherov.crystalix.datagen.data.tags.CrystalixBlockTagProvider;
import com.satherov.crystalix.datagen.data.tags.CrystalixItemTagProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="crystalix")
public class CrystalixDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture<HolderLookup.Provider> lookupProvider = CompletableFuture.supplyAsync(VanillaRegistries::createLookup, Util.backgroundExecutor());
        CrystalixDataProvider provider = new CrystalixDataProvider();
        provider.addSubProvider(event.includeClient(), (DataProvider)new CrystalixBlockModelProvider(packOutput, fileHelper));
        provider.addSubProvider(event.includeClient(), (DataProvider)new CrystalixFusionModelProvider(packOutput, fileHelper));
        provider.addSubProvider(event.includeClient(), (DataProvider)new CrystalixBlockStateProvider(packOutput, fileHelper));
        provider.addSubProvider(event.includeClient(), (DataProvider)new CrystalixItemModelProvider(packOutput, fileHelper));
        provider.addSubProvider(event.includeClient(), (DataProvider)new EN_USProvider(packOutput));
        CrystalixBlockTagProvider blockTags = new CrystalixBlockTagProvider(packOutput, lookupProvider, fileHelper);
        provider.addSubProvider(event.includeServer(), (DataProvider)blockTags);
        provider.addSubProvider(event.includeServer(), (DataProvider)new CrystalixItemTagProvider(packOutput, lookupProvider, blockTags.contentsGetter()));
        provider.addSubProvider(event.includeServer(), (DataProvider)new CrystalixRecipeProvider(packOutput, lookupProvider));
        provider.addSubProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(CrystalixLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(true, (DataProvider)provider);
    }
}

