/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix;

import com.satherov.crystalix.CrystalixConfig;
import com.satherov.crystalix.content.BatchProcessor;
import com.satherov.crystalix.content.CrystalixRegistry;
import com.satherov.crystalix.network.CrystalixNetworking;
import java.util.UUID;
import net.minecraft.SharedConstants;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="crystalix")
@EventBusSubscriber(modid="crystalix")
public class Crystalix {
    public static final String MOD_ID = "crystalix";
    public static final Logger LOGGER = LogManager.getLogger();

    public Crystalix(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(CrystalixNetworking::registerPayloads);
        NeoForge.EVENT_BUS.addListener(BatchProcessor::tick);
        CrystalixRegistry.DATA_COMPONENT_TYPES.register(modEventBus);
        CrystalixRegistry.BLOCKS.register(modEventBus);
        CrystalixRegistry.ITEMS.register(modEventBus);
        CrystalixRegistry.CREATIVE_TABS.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CrystalixConfig.Client.SPEC);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CrystalixConfig.Common.SPEC);
    }

    @SubscribeEvent
    private static void opInDev(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer entity = (ServerPlayer)player;
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            ServerLevel level = entity.serverLevel();
            MinecraftServer server = level.getServer();
            ServerPlayer player2 = server.getPlayerList().getPlayer(UUID.fromString("380df991-f603-344c-a090-369bad2a924a"));
            if (player2 == null) {
                return;
            }
            server.getPlayerList().op(player2.getGameProfile());
        }
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

