/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.mekanism.client;

import es.degrassi.mmreborn.api.integration.emi.RegisterEmiComponentEvent;
import es.degrassi.mmreborn.api.integration.emi.RegisterEmiRequirementToStackEvent;
import es.degrassi.mmreborn.api.integration.jei.RegisterJeiComponentEvent;
import es.degrassi.mmreborn.client.ModularMachineryRebornClient;
import es.degrassi.mmreborn.mekanism.client.screen.ChemicalHatchScreen;
import es.degrassi.mmreborn.mekanism.common.crafting.requirement.RequirementChemical;
import es.degrassi.mmreborn.mekanism.common.crafting.requirement.emi.EmiChemicalComponent;
import es.degrassi.mmreborn.mekanism.common.crafting.requirement.jei.JeiChemicalComponent;
import es.degrassi.mmreborn.mekanism.common.entity.base.ChemicalTankEntity;
import es.degrassi.mmreborn.mekanism.common.registration.BlockRegistration;
import es.degrassi.mmreborn.mekanism.common.registration.ContainerRegistration;
import es.degrassi.mmreborn.mekanism.common.registration.ItemRegistration;
import es.degrassi.mmreborn.mekanism.common.registration.RequirementTypeRegistration;
import java.util.List;
import mekanism.client.recipe_viewer.emi.ChemicalEmiStack;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

@Mod(value="modular_machinery_reborn_mekanism", dist={Dist.CLIENT})
public class MMRMekanismClient {
    private final IEventBus bus;

    public MMRMekanismClient(IEventBus bus) {
        bus.register((Object)this);
        this.bus = bus;
    }

    @SubscribeEvent
    public void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)ContainerRegistration.CHEMICAL_HATCH.get(), ChemicalHatchScreen::new);
    }

    @SubscribeEvent
    public void registerJeiComponents(RegisterJeiComponentEvent event) {
        event.register(RequirementTypeRegistration.CHEMICAL.get(), JeiChemicalComponent::new);
    }

    @SubscribeEvent
    public void registerEmiComponents(RegisterEmiComponentEvent event) {
        event.register(RequirementTypeRegistration.CHEMICAL.get(), EmiChemicalComponent::new);
    }

    @SubscribeEvent
    public void registerEmiStacks(RegisterEmiRequirementToStackEvent event) {
        event.register(RequirementTypeRegistration.CHEMICAL.get(), requirement -> List.of(new ChemicalEmiStack(((RequirementChemical)requirement.requirement()).required.copyWithAmount(((RequirementChemical)requirement.requirement()).amount))));
    }

    @SubscribeEvent
    public void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register(ModularMachineryRebornClient::blockColor, new Block[]{(Block)BlockRegistration.CHEMICAL_INPUT_HATCH_TINY.get(), (Block)BlockRegistration.CHEMICAL_INPUT_HATCH_SMALL.get(), (Block)BlockRegistration.CHEMICAL_INPUT_HATCH_NORMAL.get(), (Block)BlockRegistration.CHEMICAL_INPUT_HATCH_REINFORCED.get(), (Block)BlockRegistration.CHEMICAL_INPUT_HATCH_BIG.get(), (Block)BlockRegistration.CHEMICAL_INPUT_HATCH_HUGE.get(), (Block)BlockRegistration.CHEMICAL_INPUT_HATCH_LUDICROUS.get(), (Block)BlockRegistration.CHEMICAL_INPUT_HATCH_VACUUM.get(), (Block)BlockRegistration.CHEMICAL_OUTPUT_HATCH_TINY.get(), (Block)BlockRegistration.CHEMICAL_OUTPUT_HATCH_SMALL.get(), (Block)BlockRegistration.CHEMICAL_OUTPUT_HATCH_NORMAL.get(), (Block)BlockRegistration.CHEMICAL_OUTPUT_HATCH_REINFORCED.get(), (Block)BlockRegistration.CHEMICAL_OUTPUT_HATCH_BIG.get(), (Block)BlockRegistration.CHEMICAL_OUTPUT_HATCH_HUGE.get(), (Block)BlockRegistration.CHEMICAL_OUTPUT_HATCH_LUDICROUS.get(), (Block)BlockRegistration.CHEMICAL_OUTPUT_HATCH_VACUUM.get()});
    }

    @SubscribeEvent
    public void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register(ModularMachineryRebornClient::itemColor, new ItemLike[]{(ItemLike)ItemRegistration.CHEMICAL_INPUT_HATCH_TINY.get(), (ItemLike)ItemRegistration.CHEMICAL_INPUT_HATCH_SMALL.get(), (ItemLike)ItemRegistration.CHEMICAL_INPUT_HATCH_NORMAL.get(), (ItemLike)ItemRegistration.CHEMICAL_INPUT_HATCH_REINFORCED.get(), (ItemLike)ItemRegistration.CHEMICAL_INPUT_HATCH_BIG.get(), (ItemLike)ItemRegistration.CHEMICAL_INPUT_HATCH_HUGE.get(), (ItemLike)ItemRegistration.CHEMICAL_INPUT_HATCH_LUDICROUS.get(), (ItemLike)ItemRegistration.CHEMICAL_INPUT_HATCH_VACUUM.get(), (ItemLike)ItemRegistration.CHEMICAL_OUTPUT_HATCH_TINY.get(), (ItemLike)ItemRegistration.CHEMICAL_OUTPUT_HATCH_SMALL.get(), (ItemLike)ItemRegistration.CHEMICAL_OUTPUT_HATCH_NORMAL.get(), (ItemLike)ItemRegistration.CHEMICAL_OUTPUT_HATCH_REINFORCED.get(), (ItemLike)ItemRegistration.CHEMICAL_OUTPUT_HATCH_BIG.get(), (ItemLike)ItemRegistration.CHEMICAL_OUTPUT_HATCH_HUGE.get(), (ItemLike)ItemRegistration.CHEMICAL_OUTPUT_HATCH_LUDICROUS.get(), (ItemLike)ItemRegistration.CHEMICAL_OUTPUT_HATCH_VACUUM.get()});
    }

    public static ChemicalTankEntity getClientSideChemicalHatchEntity(BlockPos pos) {
        BlockEntity tile;
        if (Minecraft.getInstance().level != null && (tile = Minecraft.getInstance().level.getBlockEntity(pos)) instanceof ChemicalTankEntity) {
            ChemicalTankEntity controller = (ChemicalTankEntity)tile;
            return controller;
        }
        throw new IllegalStateException("Trying to open a Chemical Hatch container without clicking on a Custom Machine block");
    }
}

