/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.curios;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.compat.curios.CurioGearItemCapability;
import net.silentchaos512.gear.gear.trait.Trait;
import net.silentchaos512.gear.util.TraitHelper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public final class CuriosCompat {
    private CuriosCompat() {
    }

    public static int getHighestTraitLevel(LivingEntity entity, DataResource<Trait> trait) {
        AtomicInteger max = new AtomicInteger();
        CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(inventory -> inventory.getCurios().forEach((identifier, slotInventory) -> {
            IDynamicStackHandler stacks = slotInventory.getStacks();
            for (int i = 0; i < stacks.getSlots(); ++i) {
                ItemStack stack = stacks.getStackInSlot(i);
                if (!(stack.getItem() instanceof GearItem)) continue;
                max.set(Math.max(max.get(), TraitHelper.getTraitLevel(stack, trait)));
            }
        }));
        return max.get();
    }

    public static Collection<ItemStack> getEquippedCurios(LivingEntity entity) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(inventory -> inventory.getCurios().forEach((identifier, slotInventory) -> {
            IDynamicStackHandler stacks = slotInventory.getStacks();
            for (int i = 0; i < stacks.getSlots(); ++i) {
                ItemStack stack = stacks.getStackInSlot(i);
                if (!(stack.getItem() instanceof GearItem)) continue;
                ret.add(stack);
            }
        }));
        return ret;
    }

    public static void registerEventHandlers(IEventBus modEventBus) {
        modEventBus.addListener(CurioGearItemCapability::registerCapabilities);
    }
}

