/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.property;

import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.property.BooleanPropertyValue;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.util.GearComponentInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.client.util.GearTooltipFlag;

public class BooleanProperty
extends GearProperty<Boolean, BooleanPropertyValue> {
    public static final Codec<BooleanPropertyValue> CODEC = GearPropertyValue.createSimpleValueCodec(Codec.BOOL, BooleanPropertyValue::new);
    public static final StreamCodec<FriendlyByteBuf, BooleanPropertyValue> STREAM_CODEC = StreamCodec.of((buf, val) -> ByteBufCodecs.BOOL.encode(buf, (Object)((Boolean)val.value)), buf -> new BooleanPropertyValue((Boolean)ByteBufCodecs.BOOL.decode(buf)));

    public BooleanProperty(GearProperty.Builder<Boolean> builder) {
        super(builder);
    }

    @Override
    public Codec<BooleanPropertyValue> codec() {
        return CODEC;
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, BooleanPropertyValue> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public BooleanPropertyValue valueOf(Boolean value) {
        return new BooleanPropertyValue(value);
    }

    @Override
    public Boolean compute(Boolean baseValue, boolean clampResult, GearType itemType, GearType statType, Collection<BooleanPropertyValue> modifiers) {
        for (BooleanPropertyValue mod : modifiers) {
            if (!((Boolean)mod.value).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean getZeroValue() {
        return false;
    }

    @Override
    public boolean isZero(Boolean value) {
        return value == false;
    }

    @Override
    public List<BooleanPropertyValue> compressModifiers(Collection<BooleanPropertyValue> modifiers, PartGearKey key, List<? extends GearComponentInstance<?>> components) {
        return List.of(this.valueOf(this.compute((Boolean)this.getBaseValue(), true, key.gearType(), modifiers)));
    }

    @Override
    public Component formatValue(BooleanPropertyValue value, GearProperty.FormatContext formatContext) {
        return (Boolean)value.value != false ? Component.translatable((String)"property.silentgear.boolean_true") : Component.translatable((String)"property.silentgear.boolean_false");
    }

    @Override
    public MutableComponent formatValueWithColor(BooleanPropertyValue value, boolean addColor, GearProperty.FormatContext formatContext) {
        return this.formatValue(value, formatContext).plainCopy();
    }

    @Override
    public boolean isHidden(BooleanPropertyValue value, GearTooltipFlag flag) {
        return (Boolean)value.value == false;
    }
}

