/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block.decorative;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.ldtteam.domumornamentum.block.AbstractBlock;
import com.ldtteam.domumornamentum.block.ICachedItemGroupBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.components.SimpleRetexturableComponent;
import com.ldtteam.domumornamentum.block.types.PillarShapeType;
import com.ldtteam.domumornamentum.entity.block.MateriallyTexturedBlockEntity;
import com.ldtteam.domumornamentum.recipe.architectscutter.ArchitectsCutterRecipeBuilder;
import com.ldtteam.domumornamentum.tag.ModTags;
import com.ldtteam.domumornamentum.util.BlockUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PillarBlock
extends AbstractBlock<PillarBlock>
implements IMateriallyTexturedBlock,
ICachedItemGroupBlock,
EntityBlock {
    public static final List<IMateriallyTexturedBlockComponent> COMPONENTS = ImmutableList.builder().add((Object)new SimpleRetexturableComponent(ResourceLocation.withDefaultNamespace((String)"block/oak_planks"), ModTags.PILLAR_MATERIALS, Blocks.OAK_PLANKS)).build();
    public static final EnumProperty<PillarShapeType> COLUMN = EnumProperty.create((String)"column", PillarShapeType.class);
    private final List<ItemStack> fillItemGroupCache = Lists.newArrayList();
    private static final VoxelShape PILLAR = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final float BLOCK_HARDNESS = 3.0f;
    private static final float RESISTANCE = 1.0f;

    public PillarBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(3.0f, 1.0f));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(COLUMN, (Comparable)((Object)PillarShapeType.FULL_PILLAR)));
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return PILLAR;
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState p_60572_, @NotNull BlockGetter p_60573_, @NotNull BlockPos p_60574_, @NotNull CollisionContext p_60575_) {
        return Shapes.block();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{COLUMN});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        BlockPos blockAbove = blockPos.above();
        BlockPos blockBelow = blockPos.below();
        BlockState stateAbove = level.getBlockState(blockAbove);
        BlockState stateBelow = level.getBlockState(blockBelow);
        Boolean base = this.isMatchingPillar(stateBelow);
        Boolean capital = this.isMatchingPillar(stateAbove);
        return this.updateShape(this.defaultBlockState(), base, capital);
    }

    public void destroy(@NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockState state) {
        super.destroy(world, pos, state);
        Comparable column_property = state.getValue(COLUMN);
        if (column_property == PillarShapeType.PILLAR_COLUMN) {
            if (this.isMatchingPillar(world.getBlockState(pos.above())) && world.getBlockState(pos.above()).getValue(COLUMN) == PillarShapeType.PILLAR_COLUMN) {
                world.setBlock(pos.above(), (BlockState)state.setValue(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_BASE)), 3);
            } else if (this.isMatchingPillar(world.getBlockState(pos.above()))) {
                world.setBlock(pos.above(), (BlockState)state.setValue(COLUMN, (Comparable)((Object)PillarShapeType.FULL_PILLAR)), 3);
            }
            if (this.isMatchingPillar(world.getBlockState(pos.below())) && world.getBlockState(pos.below()).getValue(COLUMN) == PillarShapeType.PILLAR_COLUMN) {
                world.setBlock(pos.below(), (BlockState)state.setValue(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_CAPITAL)), 3);
            } else if (this.isMatchingPillar(world.getBlockState(pos.below()))) {
                world.setBlock(pos.below(), (BlockState)state.setValue(COLUMN, (Comparable)((Object)PillarShapeType.FULL_PILLAR)), 3);
            }
        }
        if (this.isMatchingPillar(world.getBlockState(pos.above())) && column_property == PillarShapeType.PILLAR_BASE) {
            if (world.getBlockState(pos.above()).getValue(COLUMN) == PillarShapeType.PILLAR_COLUMN) {
                world.setBlock(pos.above(), (BlockState)state.setValue(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_BASE)), 3);
            } else {
                world.setBlock(pos.above(), (BlockState)state.setValue(COLUMN, (Comparable)((Object)PillarShapeType.FULL_PILLAR)), 3);
            }
        }
        if (this.isMatchingPillar(world.getBlockState(pos.below())) && column_property == PillarShapeType.PILLAR_CAPITAL) {
            if (world.getBlockState(pos.below()).getValue(COLUMN) == PillarShapeType.PILLAR_COLUMN) {
                world.setBlock(pos.below(), (BlockState)state.setValue(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_CAPITAL)), 3);
            } else {
                world.setBlock(pos.below(), (BlockState)state.setValue(COLUMN, (Comparable)((Object)PillarShapeType.FULL_PILLAR)), 3);
            }
        }
    }

    private void updateBelow(Level level, BlockPos blockPos, BlockState state) {
        BlockPos checkBelow = blockPos.below();
        if (this.isMatchingPillar(level.getBlockState(checkBelow))) {
            level.setBlockAndUpdate(blockPos, (BlockState)state.setValue(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_COLUMN)));
        } else {
            level.setBlockAndUpdate(blockPos, (BlockState)state.setValue(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_BASE)));
        }
    }

    private void updateAbove(Level level, BlockPos blockPos, BlockState state) {
        BlockPos checkAbove = blockPos.above();
        if (this.isMatchingPillar(level.getBlockState(checkAbove))) {
            level.setBlockAndUpdate(blockPos, (BlockState)state.setValue(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_COLUMN)));
        } else {
            level.setBlockAndUpdate(blockPos, (BlockState)state.setValue(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_CAPITAL)));
        }
    }

    private BlockState updateShape(BlockState blockState, Boolean base, Boolean capital) {
        if (this.isMatchingPillar(blockState)) {
            if (base.booleanValue() && capital.booleanValue()) {
                return (BlockState)blockState.setValue(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_COLUMN));
            }
            if (!base.booleanValue() && capital.booleanValue()) {
                return (BlockState)blockState.setValue(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_BASE));
            }
            if (base.booleanValue() && !capital.booleanValue()) {
                return (BlockState)blockState.setValue(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_CAPITAL));
            }
            blockState.setValue(COLUMN, (Comparable)((Object)PillarShapeType.FULL_PILLAR));
        }
        return blockState;
    }

    private boolean isMatchingPillar(@NotNull BlockState state) {
        return state.getBlock() == this;
    }

    @NotNull
    public List<IMateriallyTexturedBlockComponent> getComponents() {
        return COMPONENTS;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new MateriallyTexturedBlockEntity(blockPos, blockState);
    }

    @Override
    public void resetCache() {
        this.fillItemGroupCache.clear();
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, LevelReader world, @NotNull BlockPos pos, @NotNull Player player) {
        return BlockUtils.getMaterializedItemStack(world.getBlockEntity(pos), (HolderLookup.Provider)world.registryAccess(), new Property[0]);
    }

    @Override
    public void buildRecipes(RecipeOutput recipeOutput) {
        new ArchitectsCutterRecipeBuilder(this, RecipeCategory.DECORATIONS).count(COMPONENTS.size()).save(recipeOutput);
    }

    public void setPlacedBy(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable LivingEntity pPlacer, @NotNull ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        BlockPos blockAbove = pPos.above();
        BlockPos blockBelow = pPos.below();
        BlockState stateAbove = pLevel.getBlockState(blockAbove);
        BlockState stateBelow = pLevel.getBlockState(blockBelow);
        boolean base = this.isMatchingPillar(stateBelow);
        boolean capital = this.isMatchingPillar(stateAbove);
        if (base) {
            this.updateBelow(pLevel, blockBelow, stateBelow);
        }
        if (capital) {
            this.updateAbove(pLevel, blockAbove, stateAbove);
        }
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.getDOExplosionResistance((x$0, x$1, x$2, x$3) -> Float.valueOf(super.getExplosionResistance(x$0, x$1, x$2, x$3)), state, level, pos, explosion);
    }

    public float getDestroyProgress(@NotNull BlockState state, @NotNull Player player, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return this.getDODestroyProgress((x$0, x$1, x$2, x$3) -> Float.valueOf(super.getDestroyProgress(x$0, x$1, x$2, x$3)), state, player, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getDOSoundType((x$0, x$1, x$2, x$3) -> super.getSoundType(x$0, x$1, x$2, x$3), state, level, pos, entity);
    }

    @Override
    public IMateriallyTexturedBlockComponent getMainComponent() {
        return COMPONENTS.get(0);
    }

    @Override
    public void fillItemCategory(@NotNull NonNullList<ItemStack> items) {
        this.fillDOItemCategory(this, items, this.fillItemGroupCache);
    }
}

