/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidContainerData;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import com.direwolf20.justdirethings.common.capabilities.JustDireFluidTank;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.MiscHelpers;
import com.direwolf20.justdirethings.util.interfacehelpers.RedstoneControlData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class FluidCollectorT1BE
extends BaseMachineBE
implements RedstoneControlledBE,
FluidMachineBE {
    public RedstoneControlData redstoneControlData = new RedstoneControlData();
    public final FluidContainerData fluidContainerData;
    List<BlockPos> positionsToPlace = new ArrayList<BlockPos>();

    public FluidCollectorT1BE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.MACHINE_SLOTS = 1;
        this.fluidContainerData = new FluidContainerData(this);
    }

    public FluidCollectorT1BE(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)Registration.FluidCollectorT1BE.get(), pPos, pBlockState);
    }

    @Override
    public int getMaxMB() {
        return 8000;
    }

    @Override
    public ContainerData getFluidContainerData() {
        return this.fluidContainerData;
    }

    @Override
    public RedstoneControlData getRedstoneControlData() {
        return this.redstoneControlData;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this;
    }

    @Override
    public void tickClient() {
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.handleItemStack();
        this.doFluidCollect();
    }

    public void handleItemStack() {
        FluidStack fluidStack = this.getFluidStack();
        if (fluidStack.isEmpty()) {
            return;
        }
        ItemStack itemStack = this.getItemStack();
        if (!this.isStackValid(itemStack, fluidStack)) {
            return;
        }
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        int insertAmt = fluidHandlerItem.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
        if (insertAmt > 0) {
            FluidStack extractedStack = this.getFluidTank().drain(Math.min(insertAmt, 1000), IFluidHandler.FluidAction.EXECUTE);
            fluidHandlerItem.fill(extractedStack, IFluidHandler.FluidAction.EXECUTE);
            if (itemStack.getItem() instanceof BucketItem) {
                this.getMachineHandler().setStackInSlot(0, fluidHandlerItem.getContainer());
            }
        }
    }

    public ItemStack getItemStack() {
        return this.getMachineHandler().getStackInSlot(0);
    }

    public boolean isStackValid(ItemStack itemStack, FluidStack fluidStack) {
        if (itemStack.isEmpty()) {
            return false;
        }
        if (fluidStack.isEmpty()) {
            return false;
        }
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandlerItem == null) {
            return false;
        }
        int amtFilled = fluidHandlerItem.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
        return amtFilled != 0;
    }

    public FluidStack getTankStack() {
        return this.getFluidTank().getFluid();
    }

    @Override
    public JustDireFluidTank getFluidTank() {
        return (JustDireFluidTank)((Object)this.getData(Registration.MACHINE_FLUID_HANDLER));
    }

    public boolean isStackValid(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return false;
        }
        return fluidStack.getAmount() >= 1000;
    }

    public boolean canCollect() {
        return true;
    }

    public boolean clearTrackerIfNeeded() {
        if (this.positionsToPlace.isEmpty()) {
            return false;
        }
        if (!this.canCollect()) {
            return true;
        }
        return !this.isActiveRedstone() && !this.redstoneControlData.redstoneMode.equals((Object)MiscHelpers.RedstoneMode.PULSE);
    }

    public void doFluidCollect() {
        if (this.clearTrackerIfNeeded()) {
            this.positionsToPlace.clear();
            return;
        }
        if (!this.canCollect()) {
            return;
        }
        FakePlayer fakePlayer = this.getFakePlayer((ServerLevel)this.level);
        if (this.isActiveRedstone() && this.canRun() && this.positionsToPlace.isEmpty()) {
            this.positionsToPlace = this.findSpotsToCollect(fakePlayer);
        }
        if (this.positionsToPlace.isEmpty()) {
            return;
        }
        if (this.canRun()) {
            BlockPos blockPos = this.positionsToPlace.removeFirst();
            this.collectFluid(blockPos);
        }
    }

    public LiquidBlock getLiquidBlockAt(BlockPos blockPos) {
        Block block = this.level.getBlockState(blockPos).getBlock();
        if (block instanceof LiquidBlock) {
            LiquidBlock liquidBlock = (LiquidBlock)block;
            return liquidBlock;
        }
        return null;
    }

    public boolean collectFluid(BlockPos blockPos) {
        LiquidBlock liquidBlock = this.getLiquidBlockAt(blockPos);
        if (liquidBlock == null) {
            return false;
        }
        if (!this.isBlockValidForTank(liquidBlock)) {
            return false;
        }
        FluidStack fluidStack = new FluidStack((Fluid)liquidBlock.fluid, 1000);
        if (this.getFluidTank().fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) < 1000) {
            return false;
        }
        if (this.level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3)) {
            this.getFluidTank().fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            this.level.playSound(null, blockPos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean isBlockValidForTank(LiquidBlock liquidBlock) {
        return this.getFluidStack().isEmpty() || this.getFluidStack().is((Fluid)liquidBlock.fluid);
    }

    public boolean isBlockPosValid(BlockPos blockPos, FakePlayer fakePlayer) {
        BlockState blockState = this.level.getBlockState(blockPos);
        Block block = blockState.getBlock();
        if (!(block instanceof LiquidBlock)) {
            return false;
        }
        LiquidBlock liquidBlock = (LiquidBlock)block;
        if ((Integer)blockState.getValue((Property)LiquidBlock.LEVEL) != 0) {
            return false;
        }
        if (!this.isBlockValidForTank(liquidBlock)) {
            return false;
        }
        return this.canPlaceAt(this.level, blockPos, fakePlayer);
    }

    public List<BlockPos> findSpotsToCollect(FakePlayer fakePlayer) {
        ArrayList<BlockPos> returnList = new ArrayList<BlockPos>();
        BlockPos blockPos = this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING));
        if (this.isBlockPosValid(blockPos, fakePlayer)) {
            returnList.add(blockPos);
        }
        return returnList;
    }

    @Override
    public boolean isFull() {
        return this.getFluidStack().getAmount() >= this.getMaxMB();
    }
}

