/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.screens.widgets;

import com.direwolf20.justdirethings.client.screens.widgets.BaseButton;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.AbilityParams;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class GrayscaleButton
extends BaseButton {
    private ResourceLocation texture;
    private boolean buttonActive;
    private int value;
    private Component localizationDisabled = Component.empty();

    public GrayscaleButton(int x, int y, int width, int height, ResourceLocation texture, Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.texture = texture;
        this.buttonActive = true;
        this.localization = this.localization;
        this.value = -1;
    }

    public GrayscaleButton(int x, int y, int width, int height, ResourceLocation texture, Component localization, Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.texture = texture;
        this.buttonActive = true;
        this.localization = localization;
        this.value = -1;
    }

    public GrayscaleButton(int x, int y, int width, int height, ResourceLocation texture, Component localization, boolean active, Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.texture = texture;
        this.buttonActive = active;
        this.localization = localization;
        this.value = -1;
    }

    public GrayscaleButton(int x, int y, int width, int height, ResourceLocation texture, Component localizationOn, Component localizationOff, boolean active, Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.texture = texture;
        this.buttonActive = active;
        this.localization = localizationOn;
        this.localizationDisabled = localizationOff;
        this.value = -1;
    }

    public GrayscaleButton(int x, int y, int width, int height, ResourceLocation texture, Component localization, boolean active, int value, Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.texture = texture;
        this.buttonActive = active;
        this.localization = localization;
        this.value = value;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        if (this.buttonActive) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)0.33f, (float)0.33f, (float)0.33f, (float)1.0f);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        guiGraphics.blit(this.texture, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void onClick(double p_onClick_1_, double p_onClick_3_) {
        super.onClick(p_onClick_1_, p_onClick_3_);
    }

    public boolean mouseClicked(double x, double y, int button) {
        return super.mouseClicked(x, y, button);
    }

    public boolean getButtonActive() {
        return this.buttonActive;
    }

    public void toggleActive() {
        this.buttonActive = !this.buttonActive;
    }

    public void cyleValue(Ability toolAbility, ItemStack stack) {
        AbilityParams abilityParams = ((ToggleableTool)stack.getItem()).getAbilityParams(toolAbility);
        int nextValue = Math.min(abilityParams.maxSlider, this.value + abilityParams.increment);
        if (nextValue == this.value && this.buttonActive) {
            this.buttonActive = false;
            nextValue = abilityParams.minSlider;
        } else if (this.value == abilityParams.minSlider && !this.buttonActive) {
            nextValue = abilityParams.minSlider;
            this.buttonActive = true;
        }
        this.value = nextValue;
    }

    @Override
    public Component getLocalization() {
        if (!this.localizationDisabled.equals((Object)Component.empty()) && !this.getButtonActive()) {
            return this.localizationDisabled;
        }
        if (this.getValue() == -1 || !this.getButtonActive()) {
            return this.localization;
        }
        return Component.translatable((String)(((TranslatableContents)this.localization.getContents()).getKey() + "value"), (Object[])new Object[]{this.getValue()});
    }

    public int getValue() {
        return this.value;
    }
}

