/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.screens;

import com.direwolf20.justdirethings.client.screens.standardbuttons.ToggleButtonFactory;
import com.direwolf20.justdirethings.client.screens.widgets.BaseButton;
import com.direwolf20.justdirethings.client.screens.widgets.GrayscaleButton;
import com.direwolf20.justdirethings.common.items.MachineSettingsCopier;
import com.direwolf20.justdirethings.common.network.data.CopyMachineSettingsPayload;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class MachineSettingsCopierScreen
extends Screen {
    public static final ResourceLocation SOCIALBACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"background");
    private ItemStack copyMachineSettingsItemstack;
    boolean area;
    boolean offset;
    boolean filter;
    boolean redstone;
    int topSectionWidth;
    int topSectionHeight;
    int topSectionLeft;
    int topSectionTop;

    public MachineSettingsCopierScreen(ItemStack itemStack) {
        super((Component)Component.literal((String)""));
        this.copyMachineSettingsItemstack = itemStack;
        this.area = MachineSettingsCopier.getCopyArea(itemStack);
        this.offset = MachineSettingsCopier.getCopyOffset(itemStack);
        this.filter = MachineSettingsCopier.getCopyFilter(itemStack);
        this.redstone = MachineSettingsCopier.getCopyRedstone(itemStack);
    }

    public void init() {
        super.init();
        this.setPositions();
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.COPY_AREA_BUTTON(this.topSectionLeft + this.topSectionWidth / 2 - 40, this.topSectionTop + 12, this.area, b -> {
            this.area = !this.area;
            ((GrayscaleButton)b).toggleActive();
            this.saveSettings();
        }));
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.COPY_OFFSET_BUTTON(this.topSectionLeft + this.topSectionWidth / 2 + 24, this.topSectionTop + 12, this.offset, b -> {
            this.offset = !this.offset;
            ((GrayscaleButton)b).toggleActive();
            this.saveSettings();
        }));
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.COPY_FILTER_BUTTON(this.topSectionLeft + this.topSectionWidth / 2 - 40, this.topSectionTop + 32, this.filter, b -> {
            this.filter = !this.filter;
            ((GrayscaleButton)b).toggleActive();
            this.saveSettings();
        }));
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.COPY_REDSTONE_BUTTON(this.topSectionLeft + this.topSectionWidth / 2 + 24, this.topSectionTop + 32, this.redstone, b -> {
            this.redstone = !this.redstone;
            ((GrayscaleButton)b).toggleActive();
            this.saveSettings();
        }));
    }

    public int getGuiLeft() {
        return (this.width - 176) / 2;
    }

    public int getGuiHeight() {
        return (this.height - 166) / 2;
    }

    public void setPositions() {
        this.topSectionWidth = 140;
        this.topSectionHeight = 60;
        this.topSectionLeft = this.getGuiLeft() - 10;
        this.topSectionTop = this.getGuiHeight();
    }

    public void renderBackground(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blitSprite(SOCIALBACKGROUND, this.topSectionLeft, this.topSectionTop - 20, this.topSectionWidth, 20);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blitSprite(SOCIALBACKGROUND, this.topSectionLeft, this.topSectionTop, this.topSectionWidth, this.topSectionHeight);
        Component title = this.copyMachineSettingsItemstack.getItem().getName(this.copyMachineSettingsItemstack);
        int titleX = this.topSectionLeft + 20 + (this.topSectionWidth - 40) / 2 - this.font.width((FormattedText)title) / 2;
        guiGraphics.drawString(this.font, title, titleX, this.topSectionTop - 14, 0x404040, false);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        for (Renderable renderable : this.renderables) {
            BaseButton button;
            if (!(renderable instanceof BaseButton) || (button = (BaseButton)renderable).getLocalization(mouseX, mouseY).equals((Object)Component.empty())) continue;
            guiGraphics.renderTooltip(this.font, button.getLocalization(mouseX, mouseY), mouseX, mouseY);
        }
    }

    public void saveSettings() {
        PacketDistributor.sendToServer((CustomPacketPayload)new CopyMachineSettingsPayload(this.area, this.offset, this.filter, this.redstone), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)pKeyCode, (int)pScanCode);
        if (super.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return true;
    }
}

