/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.ftbquestslangsplitter.mixin;

import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.integration.PermissionsHelper;
import dev.ftb.mods.ftbquests.quest.translation.TranslationManager;
import dev.ftb.mods.ftbquests.quest.translation.TranslationTable;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TranslationManager.class})
public abstract class TranslationManagerMixinClient {
    private static final AtomicBoolean kjstweaks$updatedAny = new AtomicBoolean();

    @Inject(method={"lambda$saveToNBT$1"}, at={@At(value="INVOKE", target="Ldev/ftb/mods/ftbquests/quest/translation/TranslationTable;setSaveNeeded(Z)V")})
    private static void remindPlayersToSplitRefSet(boolean force, Path langFolder, String locale, TranslationTable table, CallbackInfo ci) {
        kjstweaks$updatedAny.set(true);
    }

    @Inject(method={"saveToNBT"}, at={@At(value="RETURN")})
    private void remindPlayersToSplit(Path langFolder, boolean force, CallbackInfo ci) {
        ServerPlayer serverPlayer;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (!kjstweaks$updatedAny.get() || !ClientQuestFile.canClientPlayerEdit()) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && server.isSingleplayer() && (serverPlayer = server.getPlayerList().getPlayer(player.getUUID())) != null && PermissionsHelper.hasEditorPermission((ServerPlayer)serverPlayer, (boolean)false)) {
            MutableComponent message = Component.translatable((String)"ftbquestslangsplitter.split.lang_saved_reminder").withStyle(ChatFormatting.GREEN);
            serverPlayer.sendSystemMessage((Component)message);
        }
        kjstweaks$updatedAny.set(false);
    }
}

