/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.luminax.datagen.data;

import com.satherov.luminax.content.BlockSet;
import com.satherov.luminax.content.LuminaxRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;

public class LuminaxRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    private static final Map<Item, TagKey<Item>> colors = new HashMap<Item, TagKey<Item>>();

    public LuminaxRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    private ShapedRecipeBuilder tint(TagKey<Item> item, TagKey<Item> color, Item output) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)8).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), item).define(Character.valueOf('b'), color).unlockedBy(String.format("has_%s", item.location()), LuminaxRecipeProvider.has(item));
    }

    private ShapedRecipeBuilder block(TagKey<Item> color, Item output) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)4).pattern("aga").pattern("gbg").pattern("aga").define(Character.valueOf('a'), (ItemLike)Items.STONE).define(Character.valueOf('b'), color).define(Character.valueOf('g'), Tags.Items.DUSTS_GLOWSTONE).unlockedBy("has_stone", LuminaxRecipeProvider.has((ItemLike)Items.STONE));
    }

    private ShapedRecipeBuilder dimBlock(TagKey<Item> color, Item output) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)4).pattern("awa").pattern("wbw").pattern("awa").define(Character.valueOf('a'), (ItemLike)Items.STONE).define(Character.valueOf('b'), color).define(Character.valueOf('w'), (ItemLike)Blocks.WHITE_WOOL).unlockedBy("has_stone", LuminaxRecipeProvider.has((ItemLike)Items.STONE));
    }

    private ShapedRecipeBuilder slab(Item item, Item output) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)6).pattern("aaa").define(Character.valueOf('a'), (ItemLike)item).unlockedBy(String.format("has_%s", LuminaxRecipeProvider.getItemName((ItemLike)item)), LuminaxRecipeProvider.has((ItemLike)item));
    }

    private ShapedRecipeBuilder stair(Item item, Item output) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)4).pattern("a  ").pattern("aa ").pattern("aaa").define(Character.valueOf('a'), (ItemLike)item).unlockedBy(String.format("has_%s", LuminaxRecipeProvider.getItemName((ItemLike)item)), LuminaxRecipeProvider.has((ItemLike)item));
    }

    private ShapedRecipeBuilder wall(Item item, Item output) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)6).pattern("aaa").pattern("aaa").define(Character.valueOf('a'), (ItemLike)item).unlockedBy(String.format("has_%s", LuminaxRecipeProvider.getItemName((ItemLike)item)), LuminaxRecipeProvider.has((ItemLike)item));
    }

    private ShapedRecipeBuilder pressurePlate(Item item, Item output) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).pattern("aa").define(Character.valueOf('a'), (ItemLike)item).unlockedBy(String.format("has_%s", LuminaxRecipeProvider.getItemName((ItemLike)item)), LuminaxRecipeProvider.has((ItemLike)item));
    }

    private ShapelessRecipeBuilder button(Item item, Item output) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)output).requires((ItemLike)item).unlockedBy(String.format("has_%s", LuminaxRecipeProvider.getItemName((ItemLike)item)), LuminaxRecipeProvider.has((ItemLike)item));
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        BlockSet.apply(set -> {
            this.tint(LuminaxRegistry.ITEMTAG_BLOCK, colors.get(((Block)set.BLOCK.get()).asItem()), ((Block)set.BLOCK.get()).asItem()).save(recipeOutput, "tint_" + set.BLOCK.getId().getPath());
            this.block(colors.get(((Block)set.BLOCK.get()).asItem()), ((Block)set.BLOCK.get()).asItem()).save(recipeOutput);
            this.tint(LuminaxRegistry.ITEMTAG_DIM_BLOCK, colors.get(((Block)set.BLOCK.get()).asItem()), ((Block)set.DIM_BLOCK.get()).asItem()).save(recipeOutput, "tint_" + set.DIM_BLOCK.getId().getPath());
            this.dimBlock(colors.get(((Block)set.BLOCK.get()).asItem()), ((Block)set.DIM_BLOCK.get()).asItem()).save(recipeOutput);
            this.slab(((Block)set.BLOCK.get()).asItem(), ((SlabBlock)set.SLAB.get()).asItem()).save(recipeOutput);
            this.stair(((Block)set.BLOCK.get()).asItem(), ((StairBlock)set.STAIRS.get()).asItem()).save(recipeOutput);
            this.wall(((Block)set.BLOCK.get()).asItem(), ((WallBlock)set.WALL.get()).asItem()).save(recipeOutput);
            this.pressurePlate(((Block)set.BLOCK.get()).asItem(), ((PressurePlateBlock)set.PRESSURE_PLATE.get()).asItem()).save(recipeOutput);
            this.button(((Block)set.BLOCK.get()).asItem(), ((ButtonBlock)set.BUTTON.get()).asItem()).save(recipeOutput);
            this.slab(((Block)set.DIM_BLOCK.get()).asItem(), ((SlabBlock)set.DIM_SLAB.get()).asItem()).save(recipeOutput);
            this.stair(((Block)set.DIM_BLOCK.get()).asItem(), ((StairBlock)set.DIM_STAIRS.get()).asItem()).save(recipeOutput);
            this.wall(((Block)set.DIM_BLOCK.get()).asItem(), ((WallBlock)set.DIM_WALL.get()).asItem()).save(recipeOutput);
            this.pressurePlate(((Block)set.DIM_BLOCK.get()).asItem(), ((PressurePlateBlock)set.DIM_PRESSURE_PLATE.get()).asItem()).save(recipeOutput);
            this.button(((Block)set.DIM_BLOCK.get()).asItem(), ((ButtonBlock)set.DIM_BUTTON.get()).asItem()).save(recipeOutput);
        });
    }

    static {
        colors.put(((Block)LuminaxRegistry.WHITE.BLOCK.get()).asItem(), (TagKey<Item>)Tags.Items.DYES_WHITE);
        colors.put(((Block)LuminaxRegistry.LIGHT_GRAY.BLOCK.get()).asItem(), (TagKey<Item>)Tags.Items.DYES_LIGHT_GRAY);
        colors.put(((Block)LuminaxRegistry.GRAY.BLOCK.get()).asItem(), (TagKey<Item>)Tags.Items.DYES_GRAY);
        colors.put(((Block)LuminaxRegistry.BLACK.BLOCK.get()).asItem(), (TagKey<Item>)Tags.Items.DYES_BLACK);
        colors.put(((Block)LuminaxRegistry.BROWN.BLOCK.get()).asItem(), (TagKey<Item>)Tags.Items.DYES_BROWN);
        colors.put(((Block)LuminaxRegistry.RED.BLOCK.get()).asItem(), (TagKey<Item>)Tags.Items.DYES_RED);
        colors.put(((Block)LuminaxRegistry.ORANGE.BLOCK.get()).asItem(), (TagKey<Item>)Tags.Items.DYES_ORANGE);
        colors.put(((Block)LuminaxRegistry.YELLOW.BLOCK.get()).asItem(), (TagKey<Item>)Tags.Items.DYES_YELLOW);
        colors.put(((Block)LuminaxRegistry.LIME.BLOCK.get()).asItem(), (TagKey<Item>)Tags.Items.DYES_LIME);
        colors.put(((Block)LuminaxRegistry.GREEN.BLOCK.get()).asItem(), (TagKey<Item>)Tags.Items.DYES_GREEN);
        colors.put(((Block)LuminaxRegistry.LIGHT_BLUE.BLOCK.get()).asItem(), (TagKey<Item>)Tags.Items.DYES_LIGHT_BLUE);
        colors.put(((Block)LuminaxRegistry.CYAN.BLOCK.get()).asItem(), (TagKey<Item>)Tags.Items.DYES_CYAN);
        colors.put(((Block)LuminaxRegistry.BLUE.BLOCK.get()).asItem(), (TagKey<Item>)Tags.Items.DYES_BLUE);
        colors.put(((Block)LuminaxRegistry.PURPLE.BLOCK.get()).asItem(), (TagKey<Item>)Tags.Items.DYES_PURPLE);
        colors.put(((Block)LuminaxRegistry.MAGENTA.BLOCK.get()).asItem(), (TagKey<Item>)Tags.Items.DYES_MAGENTA);
        colors.put(((Block)LuminaxRegistry.PINK.BLOCK.get()).asItem(), (TagKey<Item>)Tags.Items.DYES_PINK);
    }
}

