/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.core;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.setup.GemsAttachmentTypes;
import net.silentchaos512.gems.setup.GemsItems;
import net.silentchaos512.gems.setup.GemsTags;
import net.silentchaos512.lib.util.TimeUtils;

@EventBusSubscriber
public class GemsEvents {
    public static final int COFFEE_TIMER_DELAY = TimeUtils.ticksFromMinutes((float)10.0f);

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Post event) {
        GemsEvents.handleCoffeeTimerTicks(event);
    }

    private static void handleCoffeeTimerTicks(EntityTickEvent.Post event) {
        LivingEntity livingEntity;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).getType().is(GemsTags.EntityTypes.COFFEE_PRODUCERS)) {
            int coffeeTimer = (Integer)livingEntity.getData(GemsAttachmentTypes.COFFEE_TIMER);
            if (coffeeTimer >= COFFEE_TIMER_DELAY) {
                GemsEvents.spawnCoffeeAtEntity(livingEntity);
                livingEntity.setData(GemsAttachmentTypes.COFFEE_TIMER, (Object)0);
            } else {
                livingEntity.setData(GemsAttachmentTypes.COFFEE_TIMER, (Object)(coffeeTimer + 1));
            }
        }
    }

    private static void spawnCoffeeAtEntity(LivingEntity livingEntity) {
        ItemEntity itemEntity = livingEntity.spawnAtLocation(GemsItems.CUP_OF_COFFEE);
        if (itemEntity != null) {
            itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().add((double)((SilentGems.RANDOM.nextFloat() - SilentGems.RANDOM.nextFloat()) * 0.1f), (double)(SilentGems.RANDOM.nextFloat() * 0.05f), (double)((SilentGems.RANDOM.nextFloat() - SilentGems.RANDOM.nextFloat()) * 0.1f)));
            livingEntity.level().playSound(null, livingEntity.position().x, livingEntity.position().y, livingEntity.position().z, SoundEvents.FROGLIGHT_STEP, SoundSource.NEUTRAL);
        }
    }
}

