/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common;

import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.Platform;
import com.ultramega.cabletiers.common.registry.Tags;
import com.ultramega.cabletiers.common.utils.ContentIds;
import com.ultramega.cabletiers.common.utils.ContentNames;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public enum CableTiers {
    ELITE(18, 73),
    ULTRA(36, 109),
    MEGA(54, 145),
    CREATIVE(54, 145);

    private final int filterSlotsCount;
    private final int playerInventoryY;

    private CableTiers(int filterSlotsCount, int playerInventoryY) {
        this.filterSlotsCount = filterSlotsCount;
        this.playerInventoryY = playerInventoryY;
    }

    public ResourceLocation getContentId(CableType type) {
        return ContentIds.getContentId(this, type);
    }

    public MutableComponent getContentName(CableType type) {
        return ContentNames.getContentName(this, type);
    }

    public TagKey<Item> getItemTag(CableType type) {
        return Tags.getItemTag(this, type);
    }

    public TagKey<Block> getBlockTag(CableType type) {
        return Tags.getBlockTag(this, type);
    }

    public int getSpeed(CableType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case CableType.IMPORTER -> Platform.getConfig().getTieredImporters().getSpeed(this);
            case CableType.EXPORTER -> Platform.getConfig().getTieredExporters().getSpeed(this);
            case CableType.DESTRUCTOR -> Platform.getConfig().getTieredDestructors().getSpeed(this);
            case CableType.CONSTRUCTOR -> Platform.getConfig().getTieredConstructors().getSpeed(this);
            case CableType.DISK_INTERFACE -> Platform.getConfig().getTieredDiskInterfaces().getSpeed(this);
            case CableType.AUTOCRAFTER -> Platform.getConfig().getTieredAutocrafters().getSpeed(this);
        };
    }

    public boolean hasIntegratedStackUpgrade(CableType type) {
        return switch (type) {
            case CableType.IMPORTER -> Platform.getConfig().getTieredImporters().hasStackUpgradeIntegrated(this);
            case CableType.EXPORTER -> Platform.getConfig().getTieredExporters().hasStackUpgradeIntegrated(this);
            case CableType.CONSTRUCTOR -> Platform.getConfig().getTieredConstructors().hasStackUpgradeIntegrated(this);
            case CableType.DISK_INTERFACE -> Platform.getConfig().getTieredDiskInterfaces().hasStackUpgradeIntegrated(this);
            default -> false;
        };
    }

    public long getEnergyUsage(CableType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case CableType.IMPORTER -> Platform.getConfig().getTieredImporters().getEnergyUsage(this);
            case CableType.EXPORTER -> Platform.getConfig().getTieredExporters().getEnergyUsage(this);
            case CableType.DESTRUCTOR -> Platform.getConfig().getTieredDestructors().getEnergyUsage(this);
            case CableType.CONSTRUCTOR -> Platform.getConfig().getTieredConstructors().getEnergyUsage(this);
            case CableType.DISK_INTERFACE -> Platform.getConfig().getTieredDiskInterfaces().getEnergyUsage(this);
            case CableType.AUTOCRAFTER -> Platform.getConfig().getTieredAutocrafters().getEnergyUsage(this);
        };
    }

    public int getFilterSlotsCount() {
        return this.filterSlotsCount;
    }

    public int getPlayerInventoryY() {
        return this.playerInventoryY;
    }

    public String getLowercaseName() {
        return this.toString().toLowerCase(Locale.ROOT);
    }

    @Nullable
    public static CableTiers byName(String search) {
        return Arrays.stream(CableTiers.values()).filter(each -> each.name().equalsIgnoreCase(search)).findFirst().orElse(null);
    }
}

