/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc.special;

import de.ellpeck.actuallyadditions.mod.misc.special.RenderSpecial;
import de.ellpeck.actuallyadditions.mod.misc.special.ThreadSpecialFetcher;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;

public class SpecialRenderInit {
    public static final HashMap<String, RenderSpecial> SPECIAL_LIST = new HashMap();

    public SpecialRenderInit() {
        new ThreadSpecialFetcher();
    }

    public static void parse(Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            ResourceLocation resLoc;
            ItemStack stack;
            String value = properties.getProperty(key);
            if (value.isEmpty() || (stack = SpecialRenderInit.findItem(resLoc = ResourceLocation.tryParse((String)value))).isEmpty()) continue;
            SPECIAL_LIST.put(key.toLowerCase(Locale.ROOT), new RenderSpecial(stack));
        }
    }

    private static ItemStack findItem(ResourceLocation resLoc) {
        Optional block;
        if (BuiltInRegistries.ITEM.containsKey(resLoc)) {
            Optional item = BuiltInRegistries.ITEM.getOptional(resLoc);
            if (item.isPresent()) {
                return new ItemStack((ItemLike)item.get());
            }
        } else if (BuiltInRegistries.BLOCK.containsKey(resLoc) && (block = BuiltInRegistries.BLOCK.getOptional(resLoc)).isPresent()) {
            return new ItemStack((ItemLike)block.get());
        }
        return ItemStack.EMPTY;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerRender(RenderPlayerEvent.Pre event) {
        RenderSpecial render;
        String name;
        String lower;
        if (event.getEntity() != null && SPECIAL_LIST.containsKey(lower = (name = event.getEntity().getName().getString()).toLowerCase(Locale.ROOT)) && (render = SPECIAL_LIST.get(lower)) != null) {
            render.render(event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), event.getEntity(), event.getPartialTick());
        }
    }
}

