/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import de.ellpeck.actuallyadditions.mod.inventory.ItemTagContainer;
import de.ellpeck.actuallyadditions.mod.inventory.gui.AAScreen;
import de.ellpeck.actuallyadditions.mod.network.packet.ButtonToContainerPacket;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;

public class ItemTagScreen
extends AAScreen<ItemTagContainer> {
    private EditBox tagBox;
    private StringWidget testText;
    private boolean validTag = false;

    public ItemTagScreen(ItemTagContainer container, Inventory inventory, Component pTitle) {
        super(container, inventory, pTitle);
    }

    @Override
    protected void init() {
        super.init();
        this.testText = new StringWidget(this.leftPos + 7, this.topPos + 27, 162, 20, (Component)Component.literal((String)""), this.font);
        this.addRenderableWidget((GuiEventListener)this.testText);
        this.tagBox = new EditBox(this.font, this.leftPos + 7, this.topPos + 7, 162, 20, Component.nullToEmpty((String)"Tag"));
        this.tagBox.setMaxLength(128);
        this.tagBox.setCanLoseFocus(false);
        this.setInitialFocus((GuiEventListener)this.tagBox);
        this.tagBox.setValue("");
        this.tagBox.setResponder(this::textChanged);
        this.addRenderableWidget((GuiEventListener)this.tagBox);
    }

    protected void renderBg(@Nonnull GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
    }

    private void textChanged(String text) {
        boolean valid = this.validateTag(text);
        if (valid) {
            this.tagBox.setTextColor(65280);
            TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.tryParse((String)text));
            Optional optionalNamed = BuiltInRegistries.ITEM.getTag(tagKey);
            if (optionalNamed.isPresent()) {
                this.testText.setMessage((Component)Component.literal((String)"Valid Tag"));
                this.testText.setColor(65280);
                this.validTag = true;
            } else {
                this.testText.setMessage((Component)Component.literal((String)"Invalid Tag"));
                this.testText.setColor(0xFF0000);
            }
        } else {
            this.tagBox.setTextColor(0xFF0000);
            this.validTag = false;
        }
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            this.minecraft.player.closeContainer();
        }
        if (pKeyCode == 257 && this.validTag) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ButtonToContainerPacket(this.minecraft.level.dimension().location(), this.minecraft.player.getId(), 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.minecraft.player.closeContainer();
        }
        return this.tagBox.keyPressed(pKeyCode, pScanCode, pModifiers) || this.tagBox.canConsumeInput() || super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    private boolean validateTag(String tag) {
        return ResourceLocation.tryParse((String)tag) != null;
    }
}

