/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.BambooSpikesTippedItem;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.common.items.components.SoftFluidTankView;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModFluids;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class ModCreativeTabs {
    private static final Set<Item> HIDDEN_ITEMS = new HashSet<Item>();
    private static final List<ItemStack> NON_HIDDEN_ITEMS = new ArrayList<ItemStack>();
    public static final RegSupplier<CreativeModeTab> MOD_TAB = CommonConfigs.General.CREATIVE_TAB.get() == false ? null : RegHelper.registerCreativeModeTab((ResourceLocation)Supplementaries.res("supplementaries"), c -> c.title((Component)Component.translatable((String)"tab.supplementaries.supplementaries")).icon(() -> ModRegistry.GLOBE_ITEM.get().getDefaultInstance()));
    public static final RegSupplier<CreativeModeTab> JAR_TAB = CommonConfigs.General.JAR_TAB.get() == false ? null : RegHelper.registerCreativeModeTab((ResourceLocation)Supplementaries.res("jars"), c -> SuppPlatformStuff.searchBar(c).title((Component)Component.translatable((String)"tab.supplementaries.jars")).icon(() -> ModRegistry.JAR_ITEM.get().getDefaultInstance()));
    private static boolean isRunningSetup = false;
    public static final List<Consumer<RegHelper.ItemToTabEvent>> SYNCED_ADD_TO_TABS = new ArrayList<Consumer<RegHelper.ItemToTabEvent>>();

    public static void init() {
        RegHelper.addItemsToTabsRegistration(ModCreativeTabs::registerItemsToTabs);
    }

    public static void populateItemsVisibility() {
        isRunningSetup = true;
        ArrayList<Item> all = new ArrayList<Item>(BuiltInRegistries.ITEM.entrySet().stream().filter(e -> ((ResourceKey)e.getKey()).location().getNamespace().equals("supplementaries")).map(Map.Entry::getValue).toList());
        final HashMap map = new HashMap();
        CreativeModeTabs.tabs().forEach(t -> map.putIfAbsent((ResourceKey)BuiltInRegistries.CREATIVE_MODE_TAB.getResourceKey(t).get(), new ArrayList()));
        RegHelper.ItemToTabEvent dummy = new RegHelper.ItemToTabEvent(){

            public void addItems(ResourceKey<CreativeModeTab> resourceKey, @Nullable Predicate<ItemStack> predicate, boolean reverse, List<ItemStack> list) {
                List l = map.computeIfAbsent(resourceKey, t -> new ArrayList());
                if (reverse) {
                    ArrayList<ItemStack> v = new ArrayList<ItemStack>(list);
                    Collections.reverse(v);
                    l.addAll(v);
                } else {
                    l.addAll(list);
                }
            }
        };
        ModCreativeTabs.registerItemsToTabs(dummy);
        for (List e2 : map.values()) {
            NON_HIDDEN_ITEMS.addAll(e2);
        }
        for (ItemStack v : NON_HIDDEN_ITEMS) {
            all.remove(v.getItem());
        }
        HIDDEN_ITEMS.addAll(all);
        isRunningSetup = false;
    }

    public static boolean isHidden(Item item) {
        return HIDDEN_ITEMS.contains(item);
    }

    public static void registerItemsToTabs(RegHelper.ItemToTabEvent e) {
        WoodType w;
        if (JAR_TAB != null && !isRunningSetup && CommonConfigs.Functional.JAR_ENABLED.get().booleanValue()) {
            e.addAfter((ResourceKey)JAR_TAB.getHolder().unwrapKey().get(), null, ModCreativeTabs.getJars());
        }
        if (MOD_TAB != null && !isRunningSetup) {
            ArrayList<ItemStack> toAdd = new ArrayList<ItemStack>();
            for (ItemStack itemStack : NON_HIDDEN_ITEMS) {
                if (!toAdd.stream().noneMatch(a -> ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)i2))) continue;
                toAdd.add(itemStack);
            }
            e.add((ResourceKey)MOD_TAB.getHolder().unwrapKey().get(), (ItemStack[])toAdd.toArray(ItemStack[]::new));
            return;
        }
        ArrayList<Supplier<Item>> sconces = new ArrayList<Supplier<Item>>(ModRegistry.SCONCES);
        sconces.add(ModRegistry.SCONCE_LEVER);
        ModCreativeTabs.before(e, Items.LANTERN, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "sconce", (Supplier[])sconces.toArray(Supplier[]::new));
        ModCreativeTabs.before(e, Items.CAMPFIRE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "fire_pit", ModRegistry.FIRE_PIT);
        ModCreativeTabs.before(e, Items.CHAIN, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "rope", ModRegistry.ROPE);
        ModCreativeTabs.after(e, Items.PEARLESCENT_FROGLIGHT, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "end_stone_lamp", ModRegistry.END_STONE_LAMP);
        ModCreativeTabs.after(e, Items.PEARLESCENT_FROGLIGHT, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "deepslate_lamp", ModRegistry.DEEPSLATE_LAMP);
        ModCreativeTabs.after(e, Items.PEARLESCENT_FROGLIGHT, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "blackstone_lamp", ModRegistry.BLACKSTONE_LAMP);
        ModCreativeTabs.after(e, Items.PEARLESCENT_FROGLIGHT, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "stone_lamp", ModRegistry.STONE_LAMP);
        ModCreativeTabs.after(e, Items.DAMAGED_ANVIL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "pedestal", ModRegistry.PEDESTAL);
        ModCreativeTabs.before(e, Items.COMPOSTER, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "blackboard", ModRegistry.BLACKBOARD);
        ModCreativeTabs.before(e, Items.COMPOSTER, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "notice_board", ModRegistry.NOTICE_BOARD);
        ModCreativeTabs.before(e, Items.COMPOSTER, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "clock_block", ModRegistry.CLOCK_BLOCK);
        ModCreativeTabs.before(e, Items.COMPOSTER, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "pulley_block", ModRegistry.PULLEY_BLOCK);
        ModCreativeTabs.after(e, Items.JUKEBOX, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "speaker_block", ModRegistry.SPEAKER_BLOCK);
        ModCreativeTabs.after(e, Items.CAULDRON, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "cage", ModRegistry.CAGE);
        ModCreativeTabs.after(e, Items.CAULDRON, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "globe_sepia", ModRegistry.GLOBE_SEPIA);
        ModCreativeTabs.after(e, Items.CAULDRON, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "globe", ModRegistry.GLOBE);
        ModCreativeTabs.after(e, Items.CAULDRON, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "hourglass", ModRegistry.HOURGLASS);
        ModCreativeTabs.after(e, Items.CAULDRON, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "jar", ModRegistry.JAR);
        ModCreativeTabs.after(e, Items.CAULDRON, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "goblet", ModRegistry.GOBLET);
        ModCreativeTabs.after(e, Items.ARMOR_STAND, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "statue", ModRegistry.STATUE);
        ModCreativeTabs.after(e, Items.FLOWER_POT, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "urn", ModRegistry.URN);
        ModCreativeTabs.after(e, Items.FLOWER_POT, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "planter", ModRegistry.PLANTER);
        ModCreativeTabs.after(e, Items.FLOWER_POT, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "flower_box", ModRegistry.FLOWER_BOX);
        ModCreativeTabs.before(e, Items.DRAGON_HEAD, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "enderman_head", ModRegistry.ENDERMAN_SKULL_ITEM);
        ModCreativeTabs.before(e, Items.BOOKSHELF, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "timber_frame", new Supplier[]{ModRegistry.TIMBER_FRAME, ModRegistry.TIMBER_BRACE, ModRegistry.TIMBER_CROSS_BRACE});
        if (CommonConfigs.Building.WAY_SIGN_ENABLED.get().booleanValue()) {
            for (Map.Entry<WoodType, SignPostItem> entry : ModRegistry.WAY_SIGN_ITEMS.entrySet()) {
                w = entry.getKey();
                e.addAfter(CreativeModeTabs.FUNCTIONAL_BLOCKS, i -> {
                    if (i.is(ItemTags.HANGING_SIGNS)) {
                        Block b = w.getBlockOfThis("hanging_sign");
                        return b != null && i.is(b.asItem());
                    }
                    return false;
                }, new ItemLike[]{(ItemLike)entry.getValue()});
            }
        }
        if (CommonConfigs.Functional.CANNON_BOAT_ENABLED.get().booleanValue()) {
            for (Map.Entry<WoodType, Object> entry : ModRegistry.CANNON_BOAT_ITEMS.entrySet()) {
                w = entry.getKey();
                e.addAfter(CreativeModeTabs.TOOLS_AND_UTILITIES, i -> {
                    if (i.is(ItemTags.CHEST_BOATS)) {
                        Item b = w.getItemOfThis("chest_boat");
                        return b != null && i.is(b);
                    }
                    return false;
                }, new ItemLike[]{(ItemLike)entry.getValue()});
            }
        }
        ModCreativeTabs.before(e, Items.CHEST, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "doormat", ModRegistry.DOORMAT);
        ModCreativeTabs.before(e, Items.CHEST, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "item_shelf", ModRegistry.ITEM_SHELF);
        ModCreativeTabs.after(e, (TagKey<Item>)ItemTags.CANDLES, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "candle_holder", (Supplier[])ModRegistry.ALL_CANDLE_HOLDERS.toArray(Supplier[]::new));
        ModCreativeTabs.after(e, (TagKey<Item>)ItemTags.CANDLES, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COLORED_BLOCKS, "candle_holder", (Supplier[])ModRegistry.CANDLE_HOLDERS.values().toArray(Supplier[]::new));
        ModCreativeTabs.after(e, Items.ENDER_CHEST, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "safe", ModRegistry.SAFE);
        ModCreativeTabs.before(e, Items.SHULKER_BOX, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "sack", ModRegistry.SACK);
        ModCreativeTabs.after(e, Items.PINK_SHULKER_BOX, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "trapped_present", (Supplier[])ModRegistry.TRAPPED_PRESENTS.values().toArray(Supplier[]::new));
        ModCreativeTabs.after(e, Items.PINK_SHULKER_BOX, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "present", (Supplier[])ModRegistry.PRESENTS.values().toArray(Supplier[]::new));
        ModCreativeTabs.after(e, Items.PINK_SHULKER_BOX, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COLORED_BLOCKS, "trapped_present", (Supplier[])ModRegistry.TRAPPED_PRESENTS.values().toArray(Supplier[]::new));
        ModCreativeTabs.after(e, Items.PINK_SHULKER_BOX, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COLORED_BLOCKS, "present", (Supplier[])ModRegistry.PRESENTS.values().toArray(Supplier[]::new));
        e.addAfter(CreativeModeTabs.FUNCTIONAL_BLOCKS, i -> i.is(Items.INFESTED_DEEPSLATE), ModCreativeTabs.getSpikeItems());
        ModCreativeTabs.after(e, Items.INFESTED_DEEPSLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "fodder", ModRegistry.FODDER);
        ModCreativeTabs.after(e, Items.INFESTED_DEEPSLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "sugar_cube", ModRegistry.SUGAR_CUBE);
        ModCreativeTabs.after(e, Items.INFESTED_DEEPSLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "feather_block", ModRegistry.FEATHER_BLOCK);
        ModCreativeTabs.after(e, Items.INFESTED_DEEPSLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "flint_block", ModRegistry.FLINT_BLOCK);
        ModCreativeTabs.after(e, Items.INFESTED_DEEPSLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "gravel_bricks", ModRegistry.SUS_GRAVEL_BRICKS);
        ModCreativeTabs.after(e, Items.INFESTED_DEEPSLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "slidy_block", ModRegistry.SLIDY_BLOCK);
        ModCreativeTabs.after(e, (TagKey<Item>)ItemTags.BANNERS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "awning", (Supplier[])ModRegistry.AWNINGS.values().toArray(Supplier[]::new));
        ModCreativeTabs.after(e, (TagKey<Item>)ItemTags.BANNERS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COLORED_BLOCKS, "awning", (Supplier[])ModRegistry.AWNINGS.values().toArray(Supplier[]::new));
        if (CommonConfigs.isEnabled("bunting")) {
            e.addAfter(CreativeModeTabs.FUNCTIONAL_BLOCKS, i -> i.is(ItemTags.BANNERS), new ItemLike[]{(ItemLike)ModRegistry.BUNTING_BLOCKS.get(DyeColor.WHITE).get()});
            e.addAfter(CreativeModeTabs.COLORED_BLOCKS, i -> i.is(ItemTags.BANNERS), (ItemLike[])ModRegistry.BUNTING_BLOCKS.values().stream().map(Supplier::get).toArray(Block[]::new));
        }
        ModCreativeTabs.after(e, (TagKey<Item>)ItemTags.BANNERS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "flag", (Supplier[])ModRegistry.FLAGS.values().toArray(Supplier[]::new));
        ModCreativeTabs.after(e, (TagKey<Item>)ItemTags.BANNERS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COLORED_BLOCKS, "flag", (Supplier[])ModRegistry.FLAGS.values().toArray(Supplier[]::new));
        ModCreativeTabs.before(e, Items.DISPENSER, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "cannon", ModRegistry.CANNON);
        ModCreativeTabs.after(e, (ItemStack i) -> i.getItem().components().get(DataComponents.JUKEBOX_PLAYABLE) != null, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "music_disc_heave_ho", ModRegistry.PIRATE_DISC);
        ModCreativeTabs.after(e, Items.LAVA_BUCKET, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "lumisene", ModFluids.LUMISENE_BUCKET);
        ModCreativeTabs.after(e, Items.HONEY_BOTTLE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FOOD_AND_DRINKS, "lumisene_bottle", ModFluids.LUMISENE_BOTTLE);
        ModCreativeTabs.after(e, Items.FIREWORK_ROCKET, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "confetti_popper", ModRegistry.CONFETTI_POPPER);
        ModCreativeTabs.after(e, Items.TNT_MINECART, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "dispenser_minecart", ModRegistry.DISPENSER_MINECART_ITEM);
        ModCreativeTabs.after(e, Items.REDSTONE_TORCH, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "sconce_lever", ModRegistry.SCONCE_LEVER);
        ModCreativeTabs.before(e, Items.LEVER, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "crank", ModRegistry.CRANK);
        ModCreativeTabs.before(e, Items.PISTON, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "turn_table", ModRegistry.TURN_TABLE);
        ModCreativeTabs.before(e, Items.PISTON, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "spring_launcher", ModRegistry.SPRING_LAUNCHER);
        ModCreativeTabs.after(e, Items.NOTE_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "speaker_block", ModRegistry.SPEAKER_BLOCK);
        ModCreativeTabs.after(e, Items.HOPPER, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "faucet", ModRegistry.FAUCET);
        ModCreativeTabs.before(e, Items.TARGET, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "cog_block", ModRegistry.COG_BLOCK);
        ModCreativeTabs.before(e, Items.NOTE_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "bellows", ModRegistry.BELLOWS);
        ModCreativeTabs.after(e, Items.OBSERVER, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "crystal_display", ModRegistry.CRYSTAL_DISPLAY);
        ModCreativeTabs.after(e, Items.OBSERVER, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "relayer", ModRegistry.RELAYER);
        ModCreativeTabs.after(e, Items.LIGHTNING_ROD, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "wind_vane", ModRegistry.WIND_VANE);
        ModCreativeTabs.after(e, Items.IRON_DOOR, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "netherite_door", ModRegistry.NETHERITE_DOOR);
        ModCreativeTabs.after(e, Items.IRON_DOOR, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "gold_door", ModRegistry.GOLD_DOOR);
        ModCreativeTabs.after(e, Items.IRON_TRAPDOOR, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "netherite_trapdoor", ModRegistry.NETHERITE_TRAPDOOR);
        ModCreativeTabs.after(e, Items.IRON_TRAPDOOR, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "gold_trapdoor", ModRegistry.GOLD_TRAPDOOR);
        ModCreativeTabs.before(e, Items.OAK_DOOR, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "lock_block", ModRegistry.LOCK_BLOCK);
        ModCreativeTabs.before(e, Items.REDSTONE_LAMP, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "redstone_illuminator", ModRegistry.REDSTONE_ILLUMINATOR);
        ModCreativeTabs.after(e, Items.END_CRYSTAL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COMBAT, "cannonball", ModRegistry.CANNONBALL_ITEM);
        ModCreativeTabs.after(e, Items.END_CRYSTAL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COMBAT, "bomb", ModRegistry.BOMB_ITEM, ModRegistry.BOMB_BLUE_ITEM);
        ModCreativeTabs.afterML(e, ModRegistry.BOMB_BLUE_ITEM.get(), (ResourceKey<CreativeModeTab>)CreativeModeTabs.COMBAT, "oreganized", "bomb", ModRegistry.BOMB_SPIKY_ITEM);
        ModCreativeTabs.before(e, Items.BOW, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COMBAT, "quiver", ModRegistry.QUIVER_ITEM);
        ModCreativeTabs.after(e, Items.CLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "altimeter", ModRegistry.ALTIMETER_ITEM);
        ModCreativeTabs.after(e, Items.MAP, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "slice_map", ModRegistry.SLICE_MAP);
        ModCreativeTabs.before(e, Items.LIGHT_WEIGHTED_PRESSURE_PLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "gold_door", ModRegistry.GOLD_DOOR);
        ModCreativeTabs.before(e, Items.LIGHT_WEIGHTED_PRESSURE_PLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "gold_trapdoor", ModRegistry.GOLD_TRAPDOOR);
        ModCreativeTabs.after(e, Items.NETHERITE_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "netherite_trapdoor", ModRegistry.NETHERITE_TRAPDOOR);
        ModCreativeTabs.after(e, Items.NETHERITE_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "netherite_door", ModRegistry.NETHERITE_DOOR);
        ModCreativeTabs.after(e, Items.SMALL_DRIPLEAF, (ResourceKey<CreativeModeTab>)CreativeModeTabs.NATURAL_BLOCKS, "flax", ModRegistry.FLAX_WILD);
        ModCreativeTabs.after(e, Items.BEETROOT_SEEDS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.NATURAL_BLOCKS, "flax", ModRegistry.FLAX_SEEDS_ITEM);
        ModCreativeTabs.after(e, Items.HAY_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.NATURAL_BLOCKS, "flax", ModRegistry.FLAX_BLOCK);
        ModCreativeTabs.after(e, Items.GRAVEL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.NATURAL_BLOCKS, "raked_gravel", ModRegistry.RAKED_GRAVEL);
        ModCreativeTabs.after(e, Items.PUMPKIN_PIE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FOOD_AND_DRINKS, "candy", ModRegistry.CANDY_ITEM);
        ModCreativeTabs.after(e, Items.PUMPKIN_PIE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FOOD_AND_DRINKS, "pancake", ModRegistry.PANCAKE_ITEM);
        ModCreativeTabs.after(e, Items.NETHER_BRICK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.INGREDIENTS, "ash_bricks", ModRegistry.ASH_BRICK_ITEM);
        ModCreativeTabs.after(e, Items.GLOW_INK_SAC, (ResourceKey<CreativeModeTab>)CreativeModeTabs.INGREDIENTS, "antique_ink", ModRegistry.ANTIQUE_INK);
        ModCreativeTabs.after(e, Items.WHEAT, (ResourceKey<CreativeModeTab>)CreativeModeTabs.INGREDIENTS, "flax", ModRegistry.FLAX_ITEM);
        ModCreativeTabs.before(e, Items.PAPER, (ResourceKey<CreativeModeTab>)CreativeModeTabs.INGREDIENTS, "ash", ModRegistry.ASH_BLOCK);
        ModCreativeTabs.before(e, Items.BRICKS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "ash_bricks", (Supplier[])ModRegistry.ASH_BRICKS_BLOCKS.values().toArray(Supplier[]::new));
        ModCreativeTabs.after(e, Items.REINFORCED_DEEPSLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "gravel_bricks", ModRegistry.SUS_GRAVEL_BRICKS);
        ModCreativeTabs.after(e, Items.REINFORCED_DEEPSLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "gravel_bricks", ModRegistry.GRAVEL_BRICKS);
        ModCreativeTabs.after(e, Items.REINFORCED_DEEPSLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "slidy_block", ModRegistry.SLIDY_BLOCK);
        ModCreativeTabs.before(e, Items.FISHING_ROD, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "lunch_basket", ModRegistry.LUNCH_BASKET_ITEM);
        ModCreativeTabs.after(e, Items.GUSTER_BANNER_PATTERN, (ResourceKey<CreativeModeTab>)CreativeModeTabs.INGREDIENTS, "dragon_banner_pattern", ModRegistry.DRAGON_PATTERN);
        ModCreativeTabs.before(e, Items.FLINT_AND_STEEL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "wrench", ModRegistry.WRENCH);
        ModCreativeTabs.before(e, Items.FLINT_AND_STEEL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "key", ModRegistry.KEY_ITEM);
        ModCreativeTabs.before(e, Items.FLINT_AND_STEEL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "slingshot", ModRegistry.SLINGSHOT_ITEM);
        ModCreativeTabs.before(e, Items.FLINT_AND_STEEL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "rope_arrow", ModRegistry.ROPE_ARROW_ITEM);
        ModCreativeTabs.before(e, Items.FLINT_AND_STEEL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "soap", ModRegistry.SOAP);
        ModCreativeTabs.before(e, Items.FLINT_AND_STEEL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "bubble_blower", () -> {
            ItemStack item = ModRegistry.BUBBLE_BLOWER.get().getDefaultInstance();
            item.set(ModComponents.CHARGES.get(), (Object)((Integer)item.get(ModComponents.MAX_CHARGES.get())));
            return item;
        });
        ModCreativeTabs.after(e, (ItemStack i) -> i.getItem() instanceof DyeItem, (ResourceKey<CreativeModeTab>)CreativeModeTabs.INGREDIENTS, "soap", ModRegistry.SOAP);
        ModCreativeTabs.after(e, Items.SPECTRAL_ARROW, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COMBAT, "rope_arrow", ModRegistry.ROPE_ARROW_ITEM);
        ModCreativeTabs.after(e, Items.LEAD, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "flute", ModRegistry.FLUTE_ITEM);
        ModCreativeTabs.after(e, Items.MOSSY_STONE_BRICK_WALL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "stone_tile", (Supplier[])ModRegistry.STONE_TILE_BLOCKS.values().toArray(Supplier[]::new));
        ModCreativeTabs.after(e, Items.POLISHED_BLACKSTONE_BRICK_WALL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "blackstone_tile", (Supplier[])ModRegistry.BLACKSTONE_TILE_BLOCKS.values().toArray(Supplier[]::new));
        ModCreativeTabs.add(e, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "lapis_bricks", (Supplier[])ModRegistry.LAPIS_BRICKS_BLOCKS.values().toArray(Supplier[]::new));
        ModCreativeTabs.add(e, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "checker_block", ModRegistry.CHECKER_BLOCK, ModRegistry.CHECKER_SLAB);
        ModCreativeTabs.add(e, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "fine_wood", ModRegistry.FINE_WOOD, ModRegistry.FINE_WOOD_STAIRS, ModRegistry.FINE_WOOD_SLAB);
        ModCreativeTabs.add(e, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "daub", new Supplier[]{ModRegistry.DAUB});
        ModCreativeTabs.add(e, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "wattle_and_daub", new Supplier[]{ModRegistry.DAUB_FRAME, ModRegistry.DAUB_BRACE, ModRegistry.DAUB_CROSS_BRACE});
        ModCreativeTabs.add(e, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "wicker_fence", ModRegistry.WICKER_FENCE);
        ModCreativeTabs.after(e, Items.IRON_BARS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "iron_gate", ModRegistry.IRON_GATE);
        ModCreativeTabs.afterML(e, "quark:gold_bars", (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "iron_gate", ModRegistry.GOLD_GATE);
        ModCreativeTabs.before(e, Items.COAL_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "soap", ModRegistry.SOAP_BLOCK);
        ModCreativeTabs.before(e, Items.OAK_FENCE_GATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "iron_gate", ModRegistry.IRON_GATE);
        ModCreativeTabs.after(e, Items.ARMOR_STAND, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "hat_stand", ModRegistry.HAT_STAND);
        CompatHandler.addItemsToTabs(e);
        SYNCED_ADD_TO_TABS.forEach(o -> o.accept(e));
    }

    private static void after(RegHelper.ItemToTabEvent event, TagKey<Item> target, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
        ModCreativeTabs.after(event, (ItemStack i) -> i.is(target), tab, key, items);
    }

    private static void after(RegHelper.ItemToTabEvent event, Item target, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
        ModCreativeTabs.after(event, (ItemStack i) -> i.is(target), tab, key, items);
    }

    private static void after(RegHelper.ItemToTabEvent event, Predicate<ItemStack> targetPred, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
        if (CommonConfigs.isEnabled(key)) {
            Object first = items[0].get();
            if (first instanceof ItemStack) {
                ItemStack[] entries = (ItemStack[])Arrays.stream(items).map(s -> (ItemStack)s.get()).toArray(ItemStack[]::new);
                event.addAfter(tab, targetPred, entries);
            } else if (first instanceof Collection) {
                for (Supplier<?> i : items) {
                    if (!(i instanceof Collection)) continue;
                    Collection c = (Collection)((Object)i);
                    ItemLike[] entries = (ItemLike[])c.stream().map(s -> (ItemLike)s).toArray(ItemLike[]::new);
                    event.addAfter(tab, targetPred, entries);
                }
            } else {
                ItemLike[] entries = (ItemLike[])Arrays.stream(items).map(s -> (ItemLike)s.get()).toArray(ItemLike[]::new);
                event.addAfter(tab, targetPred, entries);
            }
        }
    }

    private static void before(RegHelper.ItemToTabEvent event, Item target, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
        ModCreativeTabs.before(event, (ItemStack i) -> i.is(target), tab, key, items);
    }

    private static void before(RegHelper.ItemToTabEvent event, Predicate<ItemStack> targetPred, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
        if (CommonConfigs.isEnabled(key)) {
            if (items[0].get() instanceof ItemStack) {
                ItemStack[] entries = (ItemStack[])Arrays.stream(items).map(s -> (ItemStack)s.get()).toArray(ItemStack[]::new);
                event.addBefore(tab, targetPred, entries);
            } else {
                ItemLike[] entries = (ItemLike[])Arrays.stream(items).map(s -> (ItemLike)s.get()).toArray(ItemLike[]::new);
                event.addBefore(tab, targetPred, entries);
            }
        }
    }

    private static void add(RegHelper.ItemToTabEvent event, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
        if (CommonConfigs.isEnabled(key)) {
            ItemLike[] entries = (ItemLike[])Arrays.stream(items).map(s -> (ItemLike)s.get()).toArray(ItemLike[]::new);
            event.add(tab, entries);
        }
    }

    private static void afterML(RegHelper.ItemToTabEvent event, Item target, ResourceKey<CreativeModeTab> tab, String key, String modLoaded, Supplier<?> ... items) {
        if (PlatHelper.isModLoaded((String)modLoaded)) {
            ModCreativeTabs.after(event, target, tab, key, items);
        }
    }

    private static void afterML(RegHelper.ItemToTabEvent event, String modTarget, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
        ResourceLocation id = ResourceLocation.tryParse((String)modTarget);
        BuiltInRegistries.ITEM.getOptional(id).ifPresent(target -> ModCreativeTabs.after(event, target, tab, key, items));
    }

    private static void afterTL(RegHelper.ItemToTabEvent event, Item target, ResourceKey<CreativeModeTab> tab, String key, List<String> tags, Supplier<?> ... items) {
        if (ModCreativeTabs.isTagOn((String[])tags.toArray(String[]::new))) {
            ModCreativeTabs.after(event, target, tab, key, items);
        }
    }

    private static void beforeML(RegHelper.ItemToTabEvent event, Item target, ResourceKey<CreativeModeTab> tab, String key, String modLoaded, Supplier<?> ... items) {
        if (PlatHelper.isModLoaded((String)modLoaded)) {
            ModCreativeTabs.before(event, target, tab, key, items);
        }
    }

    private static void beforeTL(RegHelper.ItemToTabEvent event, Item target, ResourceKey<CreativeModeTab> tab, String key, List<String> tags, Supplier<?> ... items) {
        if (ModCreativeTabs.isTagOn((String[])tags.toArray(String[]::new))) {
            ModCreativeTabs.after(event, target, tab, key, items);
        }
    }

    private static boolean isTagOn(String ... tags) {
        for (String t : tags) {
            if (!BuiltInRegistries.ITEM.getTag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)t))).isPresent()) continue;
            return true;
        }
        return false;
    }

    public static ItemStack[] getSpikeItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (CommonConfigs.Functional.BAMBOO_SPIKES_ENABLED.get().booleanValue()) {
            items.add(ModRegistry.BAMBOO_SPIKES_ITEM.get().getDefaultInstance());
            if (CommonConfigs.Functional.TIPPED_SPIKES_ENABLED.get().booleanValue() && CommonConfigs.Functional.TIPPED_SPIKES_TAB.get().booleanValue()) {
                items.add(ModCreativeTabs.makeSpikeItem((Holder<Potion>)Potions.POISON));
                items.add(ModCreativeTabs.makeSpikeItem((Holder<Potion>)Potions.LONG_POISON));
                items.add(ModCreativeTabs.makeSpikeItem((Holder<Potion>)Potions.STRONG_POISON));
                for (Holder.Reference potion : BuiltInRegistries.POTION.holders().toList()) {
                    if (potion == Potions.POISON || potion == Potions.LONG_POISON || potion == Potions.STRONG_POISON || !BambooSpikesTippedItem.isPotionValid(new PotionContents((Holder)potion))) continue;
                    items.add(ModCreativeTabs.makeSpikeItem((Holder<Potion>)potion));
                }
            }
        }
        return (ItemStack[])items.toArray(ItemStack[]::new);
    }

    public static ItemStack makeSpikeItem(Holder<Potion> pot) {
        ItemStack stack = ModRegistry.BAMBOO_SPIKES_TIPPED_ITEM.get().getDefaultInstance();
        stack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(pot));
        return stack;
    }

    private static ItemStack[] getJars() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(ModRegistry.JAR_ITEM.get().getDefaultInstance());
        JarBlockTile tempTile = new JarBlockTile(BlockPos.ZERO, ModRegistry.JAR.get().defaultBlockState());
        RegistryAccess registries = Utils.hackyGetRegistryAccess();
        SoftFluidTank fluidHolder = SoftFluidTank.create((int)tempTile.getMaxStackSize(), (HolderLookup.Provider)registries);
        if (CommonConfigs.Functional.JAR_LIQUIDS.get().booleanValue()) {
            for (Holder.Reference h : SoftFluidRegistry.get((RegistryAccess)registries).holders().toList()) {
                SoftFluid s = (SoftFluid)h.value();
                if (!s.isEnabled() || MLBuiltinSoftFluids.POTION.is((Holder)h) || MLBuiltinSoftFluids.EMPTY.is((Holder)h)) continue;
                fluidHolder.clear();
                fluidHolder.setFluid(SoftFluidStack.of((Holder)h, (int)100));
                fluidHolder.capCapacity();
                ModCreativeTabs.tryAddJar(items, fluidHolder);
            }
            for (Holder.Reference potion : BuiltInRegistries.POTION.holders().toList()) {
                SoftFluidStack fluidStack = SoftFluidStack.of((Holder)MLBuiltinSoftFluids.POTION.getHolder((HolderLookup.Provider)registries), (int)100);
                fluidStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents((Holder)potion));
                fluidHolder.setFluid(fluidStack);
                fluidHolder.capCapacity();
                ModCreativeTabs.tryAddJar(items, fluidHolder);
            }
        }
        return (ItemStack[])items.toArray(ItemStack[]::new);
    }

    private static void tryAddJar(List<ItemStack> items, SoftFluidTank tank) {
        if (!tank.isEmpty()) {
            ItemStack returnStack = new ItemStack((ItemLike)ModRegistry.JAR_ITEM.get());
            returnStack.set(ModComponents.SOFT_FLUID_CONTENT.get(), (Object)SoftFluidTankView.of(tank));
            for (ItemStack i : items) {
                if (!i.equals(returnStack)) continue;
                return;
            }
            items.add(returnStack);
        }
    }
}

