/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.events;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.FrameBufferBackedDynamicTexture;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.RenderedTexturesManager;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.client.MobHeadShadersManager;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonController;
import net.mehvahdjukaar.supplementaries.client.hud.SelectableContainerItemHud;
import net.mehvahdjukaar.supplementaries.client.renderers.CapturedMobCache;
import net.mehvahdjukaar.supplementaries.client.screens.ConfigButton;
import net.mehvahdjukaar.supplementaries.client.screens.WelcomeMessageScreen;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractRopeBlock;
import net.mehvahdjukaar.supplementaries.common.entities.IPartyCreeper;
import net.mehvahdjukaar.supplementaries.common.events.overrides.InteractEventsHandler;
import net.mehvahdjukaar.supplementaries.common.events.overrides.SuppAdditionalPlacement;
import net.mehvahdjukaar.supplementaries.common.network.SyncEquippedQuiverPacket;
import net.mehvahdjukaar.supplementaries.common.network.SyncPartyCreeperPacket;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ClientEvents {
    protected static final MutableComponent PLACEABLE_TOOLTIP = Component.translatable((String)"message.supplementaries.placeable").withStyle(ChatFormatting.DARK_GRAY).withStyle(ChatFormatting.ITALIC);
    private static boolean isOnRope;
    private static double wobble;
    private static boolean preventShiftTillNextKeyUp;

    public static void onItemTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipFlag tooltipFlag, List<Component> components) {
        Item item;
        if (ClientConfigs.General.TOOLTIP_HINTS.get().booleanValue()) {
            InteractEventsHandler.addOverrideTooltips(itemStack, tooltipFlag, components);
        }
        if (ClientConfigs.General.PLACEABLE_TOOLTIP.get().booleanValue() && AdditionalItemPlacementsAPI.getBehavior((Item)itemStack.getItem()) instanceof SuppAdditionalPlacement) {
            components.add((Component)PLACEABLE_TOOLTIP);
        }
        if ((item = itemStack.getItem()) == ModRegistry.ROPE_ARROW_ITEM.get() || item == ModRegistry.BUBBLE_BLOWER.get()) {
            Optional<Component> r = components.stream().filter(t -> {
                TranslatableContents tc;
                ComponentContents patt0$temp = t.getContents();
                return patt0$temp instanceof TranslatableContents && (tc = (TranslatableContents)patt0$temp).getKey().equals("item.durability");
            }).findFirst();
            r.ifPresent(components::remove);
        }
    }

    public static void addConfigButton(Screen screen, List<? extends GuiEventListener> listeners, Consumer<GuiEventListener> adder) {
        if (ClientConfigs.General.CONFIG_BUTTON.get().booleanValue()) {
            ConfigButton.setupConfigButton(screen, listeners, adder);
        }
    }

    public static void onFirstScreen(Screen screen) {
        Screen newScreen = screen;
        if (CompatHandler.OPTIFINE) {
            boolean disabled = ClientConfigs.General.NO_OPTIFINE_WARN.get();
            Random random = new Random();
            if (random.nextFloat() < 0.05f) {
                SuppPlatformStuff.disableOFWarn(false);
                boolean bl = disabled = !disabled;
            }
            if (!disabled) {
                newScreen = WelcomeMessageScreen.createOptifine(newScreen);
            }
        }
        if (!CompatHandler.AMENDMENTS && !ClientConfigs.General.NO_AMENDMENTS_WARN.get().booleanValue()) {
            newScreen = WelcomeMessageScreen.createAmendments(newScreen);
        }
        if (!ClientConfigs.General.NO_INCOMPATIBLE_MODS.get().booleanValue() && WelcomeMessageScreen.hasIncompat() && !PlatHelper.isDev()) {
            newScreen = WelcomeMessageScreen.createIncompatibleMods(newScreen);
        }
        if (newScreen != screen) {
            Minecraft.getInstance().setScreen(newScreen);
        }
    }

    public static void generateIcons() {
        if (!PlatHelper.isDev() || Minecraft.getInstance().level == null) {
            return;
        }
        if (Minecraft.getInstance().level.getGameTime() % 400L != 0L) {
            return;
        }
        if (Minecraft.getInstance().level != null) {
            ResourceManager res = Minecraft.getInstance().getResourceManager();
            try {
                TextureImage plus = TextureImage.open((ResourceManager)res, (ResourceLocation)Supplementaries.res("plus"));
                TextureImage unseen = TextureImage.open((ResourceManager)res, (ResourceLocation)Supplementaries.res("unseen"));
                HashSet<Item> items = new HashSet<Item>();
                items.add(ModRegistry.PLANTER.get().asItem());
                items.add(ModRegistry.PEDESTAL.get().asItem());
                for (Item item : items) {
                    ResourceLocation id = Utils.getID((Item)item);
                    ClientEvents.makeTexture("", item, new TextureImage[0]);
                    ClientEvents.makeTexture("_unseen", item, unseen);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static FrameBufferBackedDynamicTexture requestFlatItemTexture(ResourceLocation id, Item item, int size, @Nullable Consumer<NativeImage> postProcessing, boolean updateEachFrame) {
        return RenderedTexturesManager.requestTexture((ResourceLocation)id, (int)size, t -> {
            RenderedTexturesManager.drawAsInGUI((FrameBufferBackedDynamicTexture)t, g -> {
                g.pose().translate(8.0f, 8.0f, 0.0f);
                g.pose().scale(0.8888889f, 0.8888889f, 1.0f);
                g.pose().translate(-8.0f, -8.0f, 0.0f);
                g.renderFakeItem(item.getDefaultInstance(), 0, 0);
            });
            if (postProcessing != null) {
                t.download();
                NativeImage img = t.getPixels();
                postProcessing.accept(img);
                t.upload();
            }
        }, (boolean)updateEachFrame);
    }

    private static void makeTexture(String postfix, Item item, TextureImage ... overlays) {
        BakedModel model = Minecraft.getInstance().getItemRenderer().getModel(item.getDefaultInstance(), null, null, 0);
        int s = model.isGui3d() ? 16 : 1;
        FrameBufferBackedDynamicTexture t = ClientEvents.requestFlatItemTexture(Utils.getID((Item)item).withSuffix(postfix), item, 18 * s, nativeImage -> {
            SpriteUtils.forEachPixel((NativeImage)nativeImage, (x, y) -> {
                if (y < nativeImage.getHeight() / 2) {
                    return;
                }
                int currentColor = nativeImage.getPixelRGBA(x.intValue(), y.intValue());
                int oppositeYColor = nativeImage.getPixelRGBA(x.intValue(), nativeImage.getHeight() - 1 - y);
                nativeImage.setPixelRGBA(x.intValue(), y.intValue(), oppositeYColor);
                nativeImage.setPixelRGBA(x.intValue(), nativeImage.getHeight() - 1 - y, currentColor);
            });
            ClientEvents.addOutline(nativeImage, FastColor.ABGR32.color((int)255, (int)0), s);
            for (TextureImage plus : overlays) {
                SpriteUtils.forEachPixel((NativeImage)nativeImage, (x, y) -> {
                    int xx = -1 + x / s;
                    int yy = -1 + y / s;
                    if (xx >= plus.getImage().getWidth() || yy >= plus.getImage().getHeight() || xx < 0 || yy < 0) {
                        return;
                    }
                    int color = plus.getImage().getPixelRGBA(xx, yy);
                    if (color != 0) {
                        nativeImage.setPixelRGBA(x.intValue(), y.intValue(), color);
                    }
                });
            }
        }, false);
        if (t.isInitialized()) {
            try {
                t.saveTextureToFile(PlatHelper.getGamePath().resolve("guide"));
            }
            catch (Exception e) {
                Supplementaries.LOGGER.error((Object)e);
            }
        }
    }

    private static void addOutline(NativeImage nativeImage, int color, int thickness) {
        int[][] temp = new int[nativeImage.getWidth()][nativeImage.getHeight()];
        SpriteUtils.forEachPixel((NativeImage)nativeImage, (x, y) -> {
            int currentColor = nativeImage.getPixelRGBA(x.intValue(), y.intValue());
            if (FastColor.ABGR32.alpha((int)currentColor) != 0) {
                for (int i = -thickness; i <= thickness; ++i) {
                    for (int j = -thickness; j <= thickness; ++j) {
                        int currentColor2;
                        if (i * i + j * j > thickness * thickness || x + i < 0 || x + i >= nativeImage.getWidth() || y + j < 0 || y + j >= nativeImage.getHeight() || FastColor.ABGR32.alpha((int)(currentColor2 = nativeImage.getPixelRGBA(x + i, y + j))) != 0) continue;
                        temp[x.intValue() + i][y.intValue() + j] = color;
                    }
                }
            }
        });
        for (int x2 = 0; x2 < nativeImage.getWidth(); ++x2) {
            for (int y2 = 0; y2 < nativeImage.getHeight(); ++y2) {
                if (temp[x2][y2] == 0) continue;
                nativeImage.setPixelRGBA(x2, y2, temp[x2][y2]);
            }
        }
    }

    public static void onClientTick(Minecraft minecraft) {
        if (minecraft.isPaused() || minecraft.level == null) {
            return;
        }
        CapturedMobCache.tickCrystal();
        LocalPlayer p = minecraft.player;
        if (p == null) {
            return;
        }
        ClientEvents.checkIfOnRope((Player)p);
        MobHeadShadersManager.INSTANCE.applyMobHeadShaders((Player)p, minecraft);
        CannonController.onClientTick(minecraft);
    }

    public static double getRopeWobble(double partialTicks) {
        LocalPlayer p = Minecraft.getInstance().player;
        if (!(p == null || Minecraft.getInstance().isPaused() || p.isSpectator() || !isOnRope && wobble == 0.0)) {
            double period = ClientConfigs.Blocks.ROPE_WOBBLE_PERIOD.get();
            double newWobble = ((double)p.tickCount + partialTicks) / period % 1.0;
            wobble = !isOnRope && newWobble < wobble ? 0.0 : newWobble;
            return (double)Mth.sin((float)((float)(wobble * 2.0 * Math.PI))) * ClientConfigs.Blocks.ROPE_WOBBLE_AMPLITUDE.get();
        }
        return 0.0;
    }

    private static void checkIfOnRope(Player p) {
        AbstractRopeBlock rb;
        Block block;
        BlockState state = p.getBlockStateOn();
        isOnRope = (p.getX() != p.xOld || p.getZ() != p.zOld) && (block = state.getBlock()) instanceof AbstractRopeBlock && !(rb = (AbstractRopeBlock)block).hasConnection(Direction.UP, state) && (p.getY() + 500.0) % 1.0 >= AbstractRopeBlock.COLLISION_SHAPE.max(Direction.Axis.Y);
    }

    public static void onEntityLoad(Entity entity, Level clientLevel) {
        if (entity instanceof AbstractSkeleton && entity instanceof IQuiverEntity) {
            IQuiverEntity q = (IQuiverEntity)entity;
            NetworkHelper.sendToServer((CustomPacketPayload)new SyncEquippedQuiverPacket(entity, q));
        }
        if (entity instanceof IPartyCreeper && entity instanceof Creeper) {
            Creeper c = (Creeper)entity;
            NetworkHelper.sendToServer((CustomPacketPayload)new SyncPartyCreeperPacket((LivingEntity)c));
        }
    }

    public static void onExplosion(Explosion explosion) {
    }

    public static boolean cancelKeyPress(int key, int scancode, int action, int modifiers) {
        return SelectableContainerItemHud.getInstance().onKeyPressed(key, action, modifiers) || CannonController.onEarlyKeyPress(key, scancode, action, modifiers);
    }

    public static void modifyInputUpdate(Input instance, LocalPlayer player) {
        if (CannonController.isActive()) {
            CannonController.onInputUpdate(instance);
            preventShiftTillNextKeyUp = true;
        } else if (preventShiftTillNextKeyUp) {
            if (!instance.shiftKeyDown) {
                preventShiftTillNextKeyUp = false;
            } else {
                instance.shiftKeyDown = false;
            }
        }
    }

    static {
        preventShiftTillNextKeyUp = false;
    }
}

