/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.goals;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonAccess;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonTrajectory;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonUtils;
import net.mehvahdjukaar.supplementaries.common.block.cannon.ShootingMode;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.entities.CannonBoatEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;

public class ManeuverAndShootCannonBehavior
extends Behavior<LivingEntity> {
    private int attackDelay;
    private CannonAccess access;

    public ManeuverAndShootCannonBehavior() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.HOME, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.LAST_WOKEN, (Object)MemoryStatus.REGISTERED));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, LivingEntity owner) {
        Entity boat = owner.getControlledVehicle();
        if (boat instanceof CannonBoatEntity) {
            CannonBoatEntity cb = (CannonBoatEntity)boat;
            return cb.getInternalCannon().hasFuelAndProjectiles();
        }
        LivingEntity livingentity = ManeuverAndShootCannonBehavior.getAttackTarget(owner);
        return BehaviorUtils.canSee((LivingEntity)owner, (LivingEntity)livingentity);
    }

    private static LivingEntity getAttackTarget(LivingEntity shooter) {
        return (LivingEntity)shooter.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
    }

    protected boolean canStillUse(ServerLevel level, LivingEntity owner, long gameTime) {
        Entity boat = owner.getControlledVehicle();
        if (boat instanceof CannonBoatEntity) {
            CannonBoatEntity cb = (CannonBoatEntity)boat;
            return cb.getInternalCannon().hasFuelAndProjectiles();
        }
        return false;
    }

    protected void start(ServerLevel level, LivingEntity owner, long gameTime) {
        Entity boat = owner.getControlledVehicle();
        if (boat instanceof CannonBoatEntity) {
            CannonBoatEntity cb = (CannonBoatEntity)boat;
            this.access = cb;
        }
    }

    protected boolean timedOut(long gameTime) {
        return false;
    }

    protected void stop(ServerLevel level, LivingEntity entity, long gameTime) {
        this.access = null;
    }

    protected void tick(ServerLevel level, LivingEntity owner, long gameTime) {
        LivingEntity livingentity = ManeuverAndShootCannonBehavior.getAttackTarget(owner);
        this.lookAtTarget(owner, livingentity);
        if (this.attackDelay > 0) {
            --this.attackDelay;
        }
        if (ManeuverAndShootCannonBehavior.aimCannonAndShoot(this.access, owner, livingentity, this.attackDelay <= 0)) {
            this.attackDelay = Mth.randomBetweenInclusive((RandomSource)level.random, (int)20, (int)40);
        }
    }

    public static boolean aimCannonAndShoot(CannonAccess access, LivingEntity shooter, LivingEntity target, boolean canShoot) {
        CannonBlockTile cannonTile = access.getInternalCannon();
        if (cannonTile.isOnCooldown()) {
            return false;
        }
        Vec3 cannonGlobalPosition = access.getCannonGlobalPosition(0.0f);
        Vec3 targetLoc = target.position();
        byte power = 1;
        int maxPower = cannonTile.getFuel().getCount();
        float distance = (float)targetLoc.distanceTo(cannonGlobalPosition);
        if (distance > 64.0f) {
            power = 4;
        } else if (distance > 32.0f) {
            power = 3;
        } else if (distance > 16.0f) {
            power = 2;
        }
        targetLoc = targetLoc.add(target.getDeltaMovement().scale((double)distance * 0.2)).add(0.0, 0.6, 0.0);
        power = (byte)Math.min(power, maxPower);
        cannonTile.setPowerLevel(power);
        Pair<CannonTrajectory, Float> comp = CannonUtils.computeTrajectory(access, targetLoc, ShootingMode.DOWN);
        CannonTrajectory cannonTrajectory = (CannonTrajectory)comp.getFirst();
        float wantedGlobalYawDeg = ((Float)comp.getSecond()).floatValue() * 57.295776f;
        if (cannonTrajectory != null) {
            float newCannonGlobalYaw;
            Vec3 hitLoc;
            double distance1;
            float cannonGlobalYawOffsetDeg = access.getCannonGlobalYawOffset(0.0f);
            float wantedLocalYawDeg = wantedGlobalYawDeg + cannonGlobalYawOffsetDeg;
            ManeuverAndShootCannonBehavior.setCannonAnglesToFollowTrajectory(access, cannonTrajectory, wantedLocalYawDeg);
            if (canShoot && (distance1 = (hitLoc = cannonTrajectory.getHitLocation(cannonGlobalPosition, newCannonGlobalYaw = (cannonTile.getYaw() - cannonGlobalYawOffsetDeg) * ((float)Math.PI / 180))).distanceTo(targetLoc)) < 0.1) {
                cannonTile.ignite((Entity)shooter, access);
                return true;
            }
        }
        return false;
    }

    private static void setCannonAnglesToFollowTrajectory(CannonAccess access, CannonTrajectory trajectory, float wantedLocalYawDeg) {
        if (trajectory != null) {
            float followSpeed = 1.0f;
            CannonBlockTile cannon = access.getInternalCannon();
            cannon.setPitch(access, Mth.rotLerp((float)followSpeed, (float)cannon.getPitch(), (float)(trajectory.pitch() * 57.295776f)));
            cannon.setYaw(access, wantedLocalYawDeg);
            cannon.setChanged();
            access.updateClients();
        }
    }

    private void lookAtTarget(LivingEntity shooter, LivingEntity target) {
        shooter.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)target, true));
    }
}

