/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.items.components.CannonballWhitelist;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.CannonBallExplosion;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundCannonballExplosionPacket;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.mixins.LivingEntityAccessor;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModDamageSources;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlimeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CannonBallEntity
extends ImprovedProjectileEntity {
    private final List<CannonBallEntity> justCollidedWith = new ArrayList<CannonBallEntity>();
    private int bounces = 0;

    public CannonBallEntity(LivingEntity thrower) {
        super(ModEntities.CANNONBALL.get(), thrower, thrower.level());
        this.maxAge = 6000;
        this.blocksBuilding = true;
    }

    public CannonBallEntity(EntityType<CannonBallEntity> type, Level level) {
        super(type, level);
        this.maxAge = 6000;
        this.blocksBuilding = true;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("bounces", this.bounces);
    }

    public void load(CompoundTag compound) {
        super.load(compound);
        this.bounces = compound.getInt("bounces");
    }

    protected Item getDefaultItem() {
        return ModRegistry.CANNONBALL.get().asItem();
    }

    public void tick() {
        super.tick();
        this.justCollidedWith.clear();
    }

    protected double getDefaultGravity() {
        return 0.035f;
    }

    public float getDefaultShootVelocity() {
        return 0.9f;
    }

    public void spawnTrailParticles() {
        Vec3 speed = this.getDeltaMovement();
        Vec3 normalSpeed = speed.normalize();
        double pitch = Math.asin(normalSpeed.y);
        double yaw = Math.atan2(normalSpeed.x, normalSpeed.z);
        double dx = this.getX() - this.xo;
        double dy = this.getY() - this.yo;
        double dz = this.getZ() - this.zo;
        for (int k = 0; k < 2; ++k) {
            if (!((double)this.random.nextFloat() < speed.length() * 0.35)) continue;
            Vector3f offset = new Vector3f(0.0f, this.random.nextFloat() * this.getBbWidth() * 0.7f, 0.0f);
            offset.rotateZ(this.level().random.nextFloat() * ((float)Math.PI * 2));
            offset.rotateX((float)pitch);
            offset.rotateY((float)yaw);
            float j = this.random.nextFloat() * -0.5f;
            this.level().addParticle((ParticleOptions)ModParticles.WIND_STREAM.get(), (double)offset.x + (double)j * dx, (double)offset.y + (double)j * dy + (double)(this.getBbWidth() / 3.0f), (double)offset.z + (double)j * dz, (double)this.getId(), 0.0, 0.0);
        }
    }

    public void handleEntityEvent(byte id) {
        BlockParticleOption particleData;
        super.handleEntityEvent(id);
        Object object = particleData = ClientConfigs.Items.CANNONBALL_3D.get() != false ? new BlockParticleOption(ParticleTypes.BLOCK, ModRegistry.CANNONBALL.get().defaultBlockState()) : new ItemParticleOption(ParticleTypes.ITEM, this.getItem());
        if (id == 3) {
            float speed = 0.05f;
            for (int i = 0; i < 8; ++i) {
                double k = this.random.nextGaussian() * (double)speed;
                double l = this.random.nextGaussian() * (double)speed;
                double m = this.random.nextGaussian() * (double)speed;
                this.level().addParticle((ParticleOptions)particleData, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), k, l, m);
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (this.maybeBounce(result)) {
            return;
        }
        if (!this.level().isClientSide) {
            double radius = CommonConfigs.Functional.CANNONBALL_RADIUS.get();
            Vec3 movement = this.getDeltaMovement();
            double vel = Math.abs(movement.length());
            float scaling = 5.0f;
            float maxAmount = (float)(vel * vel * (double)scaling);
            Vec3 loc = this.position();
            BlockPos pos = result.getBlockPos();
            CannonballWhitelist wl = (CannonballWhitelist)this.getItem().get(ModComponents.CANNONBALL_WHITELIST.get());
            Set<Block> whitelist = wl != null ? wl.blocks() : null;
            CannonBallExplosion exp = new CannonBallExplosion(this.level(), (Entity)this, loc.x(), loc.y(), loc.z(), pos, maxAmount, (float)radius, whitelist);
            exp.explode();
            exp.finalizeExplosion(true);
            float exploded = exp.getExploded();
            if (exploded != 0.0f) {
                double speedUsed = exploded / maxAmount;
                double factor = 1.0 - speedUsed;
                if (factor <= 0.0 || factor > 1.0) {
                    Supplementaries.error();
                }
                this.setDeltaMovement(movement.scale(factor));
                ClientBoundCannonballExplosionPacket message = ClientBoundCannonballExplosionPacket.cannonball(exp, this);
                NetworkHelper.sendToAllClientPlayersInDefaultRange((ServerLevel)((ServerLevel)this.level()), (BlockPos)pos, (CustomPacketPayload)message);
            }
            this.hasImpulse = true;
            if (this.getDeltaMovement().lengthSqr() < 0.04000000000000001 || exploded == 0.0f) {
                this.playSound(ModSounds.CANNONBALL_BREAK.get(), 1.0f, 1.5f);
                this.level().broadcastEntityEvent((Entity)this, (byte)3);
                this.discard();
            } else {
                Vec3 targetPos = new Vec3(this.xo, this.yo, this.zo).add(this.movementOld);
                Vec3 missingMovement = targetPos.subtract(this.position());
                if (missingMovement.lengthSqr() > 1.0E-4) {
                    this.move(MoverType.SELF, missingMovement);
                }
            }
        }
    }

    private boolean maybeBounce(BlockHitResult hit) {
        boolean shouldBounce;
        if (this.bounces >= 3) {
            return false;
        }
        ++this.bounces;
        Direction hitDirection = hit.getDirection();
        BlockPos pos = hit.getBlockPos();
        Vec3 velocity = this.getDeltaMovement();
        Vector3f surfaceNormal = hitDirection.step();
        Level level = this.level();
        BlockState hitBlock = level.getBlockState(pos);
        if (hitBlock.getBlock() instanceof SlimeBlock) {
            shouldBounce = true;
        } else {
            float bounceCosAngle;
            double dot = surfaceNormal.dot((Vector3fc)velocity.toVector3f());
            double cosAngle = Math.abs(dot / velocity.length());
            boolean bl = shouldBounce = cosAngle < (double)(bounceCosAngle = Mth.cos((float)1.3089969f));
        }
        if (shouldBounce) {
            Vec3 newVel = new Vec3(velocity.toVector3f().reflect((Vector3fc)surfaceNormal));
            this.setDeltaMovement(newVel);
            this.hasImpulse = true;
            double missingDistance = velocity.subtract(this.position().subtract(new Vec3(this.xo, this.yo, this.zo))).length();
            this.setPos(this.position().add(newVel.normalize().scale(missingDistance)));
            level.gameEvent((Holder)GameEvent.HIT_GROUND, this.position(), GameEvent.Context.of((Entity)this, (BlockState)hitBlock));
            this.addLandingEffects(hit);
            return true;
        }
        return false;
    }

    private void addLandingEffects(BlockHitResult hit) {
        this.playSound(ModSounds.CANNONBALL_BOUNCE.get(), 2.2f, 1.0f);
        BlockPos pos = hit.getBlockPos();
        BlockState state = this.level().getBlockState(pos);
        double speed = this.getDeltaMovement().lengthSqr();
        double minSpeed = 0.2f;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (!state.isAir() && speed > minSpeed) {
                double x = hit.getLocation().x;
                double y = hit.getLocation().y;
                double z = hit.getLocation().z;
                int count = Math.min(10, (int)(speed * 4.0) + 1);
                BlockParticleOption blockParticleOption = new BlockParticleOption(ParticleTypes.BLOCK, state);
                SuppPlatformStuff.setParticlePos(blockParticleOption, pos);
                sl.sendParticles((ParticleOptions)blockParticleOption, x, y, z, count, 0.0, 0.0, 0.0, 0.15);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        float f;
        Entity target = result.getEntity();
        if (target instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)target;
            f = 0.1f;
        } else {
            f = 0.8f;
        }
        float lossFactor = f;
        float cannonballDensity = 8.0f;
        float m2 = (float)target.getBoundingBox().getSize() * (target instanceof CannonBallEntity ? cannonballDensity : 0.0f);
        float m1 = (float)this.getBoundingBox().getSize() * cannonballDensity;
        Vector3f v2i = target.getDeltaMovement().toVector3f();
        Vector3f v1i = this.getDeltaMovement().toVector3f();
        double initialKineticEnergy = 0.5f * m1 * v1i.lengthSquared() + 0.5f * m2 * v2i.lengthSquared();
        float elasticity = 1.0f;
        if (target instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)target;
            double lostEnergy = initialKineticEnergy * (double)(1.0f - lossFactor);
            double dmgMult = CommonConfigs.Functional.CANNONBALL_POWER_SCALING.get();
            float amount = (float)(lostEnergy * dmgMult);
            float oldHealth = le.getHealth();
            if (le.hurt(ModDamageSources.cannonBallExplosion(this.level(), (Entity)this, this.getOwner()), amount)) {
                elasticity = Mth.sqrt((float)(1.0f - lossFactor));
            }
            if (!this.level().isClientSide && le instanceof Creeper && oldHealth >= le.getMaxHealth()) {
                this.maybeDropDisc(le);
            }
        }
        Vector3f v1f = new Vector3f();
        Vector3f v2f = new Vector3f();
        for (int i = 0; i < 3; ++i) {
            float c1 = (v1i.get(i) * (m1 - m2) + elasticity * 2.0f * m2 * v2i.get(i)) / (m1 + m2);
            float c2 = (v2i.get(i) * (m2 - m1) + elasticity * 2.0f * m1 * v1i.get(i)) / (m1 + m2);
            v1f.setComponent(i, c1);
            v2f.setComponent(i, c2);
        }
        this.setDeltaMovement(new Vec3(v1f));
        target.setDeltaMovement(new Vec3(v2f));
        this.hasImpulse = true;
        Vector3f finalMomentum = v1f.mul(m1, new Vector3f()).add((Vector3fc)v2f.mul(m2, new Vector3f()));
        double finalKineticEnergy = 0.5f * m1 * v1f.lengthSquared() + 0.5f * m2 * v2f.lengthSquared();
        if (target instanceof CannonBallEntity) {
            CannonBallEntity c = (CannonBallEntity)target;
            c.justCollidedWith.add(this);
            this.playSound(ModSounds.CANNONBALL_BOUNCE.get(), 2.2f, 1.0f);
        }
    }

    private void maybeDropDisc(LivingEntity le) {
        if (!le.isAlive() && CommonConfigs.Functional.PIRATE_DISC_ENABLED.get().booleanValue() && this.getOwner() instanceof Player && ((LivingEntityAccessor)le).invokeShouldDropLoot() && this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            le.spawnAtLocation((ItemLike)ModRegistry.PIRATE_DISC.get());
        }
    }

    protected boolean canHitEntity(Entity target) {
        if (target instanceof CannonBallEntity) {
            CannonBallEntity c = (CannonBallEntity)target;
            return !c.justCollidedWith.contains((Object)this);
        }
        return super.canHitEntity(target);
    }

    public boolean canBeHitByProjectile() {
        return true;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return super.hurt(source, amount);
    }
}

