/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.dispenser;

import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.util.DispenserHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.BambooSpikesBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.BucketBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.EmptyBundleItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.EmptyContainerItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.FakePlayerUseItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.FireBehaviorProxy;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.FishBucketJarBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.FlintAndSteelBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.GunpowderBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.KeyBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.PancakeBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.PlaceHatStandBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.ThrowableBricksBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.ThrowableEnderPearlBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.ThrowableSlimeballBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.PopperBehavior;
import net.mehvahdjukaar.supplementaries.common.items.DispenserMinecartItem;
import net.mehvahdjukaar.supplementaries.common.items.KeyItem;
import net.mehvahdjukaar.supplementaries.common.items.SackItem;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BucketHelper;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModFluids;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.dispenser.ProjectileDispenseBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class DispenserBehaviorsManager {
    public static void init() {
        RegHelper.addDynamicDispenserBehaviorRegistration(DispenserBehaviorsManager::registerBehaviors);
    }

    public static void registerBehaviors(DispenserHelper.Event event) {
        boolean isForge = PlatHelper.getPlatform().isForge();
        Supplementaries.LOGGER.info("Registering custom dispenser behaviors");
        if (!CommonConfigs.General.DISPENSERS.get().booleanValue()) {
            return;
        }
        if (CommonConfigs.Tweaks.BUNDLE_DISPENSER.get().booleanValue()) {
            event.register((DispenserHelper.AdditionalDispenserBehavior)new EmptyBundleItemBehavior(Items.BUNDLE));
            event.register((DispenserHelper.AdditionalDispenserBehavior)new EmptyContainerItemBehavior(ModRegistry.LUNCH_BASKET_ITEM.get()));
            event.register((DispenserHelper.AdditionalDispenserBehavior)new EmptyContainerItemBehavior(ModRegistry.QUIVER_ITEM.get()));
        }
        if (CommonConfigs.Building.HAT_STAND_ENABLED.get().booleanValue()) {
            event.register((DispenserHelper.AdditionalDispenserBehavior)new PlaceHatStandBehavior(ModRegistry.HAT_STAND.get()));
        }
        if (CommonConfigs.Tweaks.ENDER_PEAR_DISPENSERS.get().booleanValue()) {
            event.register((DispenserHelper.AdditionalDispenserBehavior)new ThrowableEnderPearlBehavior());
        }
        if (CommonConfigs.Redstone.DISPENSER_MINECART_ENABLED.get().booleanValue()) {
            event.register(ModRegistry.DISPENSER_MINECART_ITEM.get(), DispenserMinecartItem.DISPENSE_ITEM_BEHAVIOR);
        }
        if (CommonConfigs.Redstone.ENDERMAN_HEAD_ENABLED.get().booleanValue()) {
            OptionalDispenseItemBehavior armorBehavior = new OptionalDispenseItemBehavior(){

                protected ItemStack execute(BlockSource source, ItemStack stack) {
                    this.setSuccess(ArmorItem.dispenseArmor((BlockSource)source, (ItemStack)stack));
                    return stack;
                }
            };
            event.register(ModRegistry.ENDERMAN_SKULL_ITEM.get(), (DispenseItemBehavior)armorBehavior);
        }
        if (CommonConfigs.Functional.FODDER_ENABLED.get().booleanValue()) {
            event.registerPlaceBlock((ItemLike)ModRegistry.FODDER.get());
        }
        if (CommonConfigs.Tools.LUNCH_BOX_ENABLED.get().booleanValue()) {
            event.registerPlaceBlock((ItemLike)ModRegistry.LUNCH_BASKET.get());
        }
        if (CommonConfigs.Functional.SOAP_ENABLED.get().booleanValue()) {
            event.registerPlaceBlock((ItemLike)ModRegistry.BUBBLE_BLOCK.get());
        }
        if (CommonConfigs.Functional.LUMISENE_ENABLED.get().booleanValue()) {
            event.register((DispenserHelper.AdditionalDispenserBehavior)new BucketBehavior(ModFluids.LUMISENE_BUCKET.get()));
        }
        if (CommonConfigs.Functional.JAR_ENABLED.get().booleanValue()) {
            event.registerPlaceBlock((ItemLike)ModRegistry.JAR_ITEM.get());
            event.register((DispenserHelper.AdditionalDispenserBehavior)new DispenserHelper.AddItemToInventoryBehavior(Items.COOKIE));
        }
        event.register((DispenserHelper.AdditionalDispenserBehavior)new FlintAndSteelBehavior(Items.FLINT_AND_STEEL));
        if (CommonConfigs.Functional.BAMBOO_SPIKES_ENABLED.get().booleanValue()) {
            event.registerPlaceBlock((ItemLike)ModRegistry.BAMBOO_SPIKES_ITEM.get());
        }
        if (CommonConfigs.Functional.TIPPED_SPIKES_ENABLED.get().booleanValue()) {
            event.registerPlaceBlock((ItemLike)ModRegistry.BAMBOO_SPIKES_TIPPED_ITEM.get());
            event.register((DispenserHelper.AdditionalDispenserBehavior)new BambooSpikesBehavior(Items.LINGERING_POTION));
        }
        if (isForge) {
            event.register((DispenserHelper.AdditionalDispenserBehavior)new FakePlayerUseItemBehavior(ModRegistry.SOAP.get()));
        }
        if (CommonConfigs.Tools.POPPER_ENABLED.get().booleanValue()) {
            event.register((DispenserHelper.AdditionalDispenserBehavior)new FireBehaviorProxy(ModRegistry.CONFETTI_POPPER.get(), new PopperBehavior(), 0.7f, 1, false));
        }
        if (CommonConfigs.Tweaks.THROWABLE_BRICKS_ENABLED.get().booleanValue()) {
            BuiltInRegistries.ITEM.getTagOrEmpty(ModTags.BRICKS).iterator().forEachRemaining(h -> event.register((DispenserHelper.AdditionalDispenserBehavior)new ThrowableBricksBehavior((Item)h.value())));
        }
        if (CommonConfigs.Tweaks.THROWABLE_SLIMEBALLS.get().booleanValue()) {
            BuiltInRegistries.ITEM.getTagOrEmpty(ModTags.SLIMEBALLS).iterator().forEachRemaining(h -> event.register((DispenserHelper.AdditionalDispenserBehavior)new ThrowableSlimeballBehavior((Item)h.value())));
        }
        if (CommonConfigs.Tools.BOMB_ENABLED.get().booleanValue()) {
            event.register(ModRegistry.BOMB_ITEM.get(), (DispenseItemBehavior)new ProjectileDispenseBehavior(ModRegistry.BOMB_ITEM.get()));
            event.register(ModRegistry.BOMB_BLUE_ITEM.get(), (DispenseItemBehavior)new DispenserHelper.AddItemToInventoryBehavior(ModRegistry.BOMB_BLUE_ITEM.get()));
            event.register(ModRegistry.BOMB_SPIKY_ITEM.get(), (DispenseItemBehavior)new DispenserHelper.AddItemToInventoryBehavior(ModRegistry.BOMB_SPIKY_ITEM.get()));
        }
        if (CommonConfigs.Tweaks.PLACEABLE_GUNPOWDER.get().booleanValue()) {
            event.register((DispenserHelper.AdditionalDispenserBehavior)new GunpowderBehavior(Items.GUNPOWDER));
        }
        if (CommonConfigs.Tools.ROPE_ARROW_ENABLED.get().booleanValue()) {
            event.register((Item)ModRegistry.ROPE_ARROW_ITEM.get(), (DispenseItemBehavior)new ProjectileDispenseBehavior((Item)ModRegistry.ROPE_ARROW_ITEM.get()));
        }
        boolean axe = CommonConfigs.Tweaks.AXE_DISPENSER_BEHAVIORS.get();
        boolean jar = CommonConfigs.Functional.JAR_ENABLED.get();
        boolean key = CommonConfigs.isEnabled("key");
        boolean pancake = CommonConfigs.isEnabled("pancake");
        boolean sack = CommonConfigs.Functional.SACK_ENABLED.get();
        if (axe || jar || key) {
            for (Item i : BuiltInRegistries.ITEM) {
                try {
                    if (jar && BucketHelper.isFishBucket(i)) {
                        event.register((DispenserHelper.AdditionalDispenserBehavior)new FishBucketJarBehavior(i));
                    }
                    if (pancake && ModBlockProperties.Topping.fromItem(i).getFirst() != ModBlockProperties.Topping.NONE) {
                        event.register((DispenserHelper.AdditionalDispenserBehavior)new PancakeBehavior(i));
                    }
                    if (isForge && axe && i instanceof AxeItem) {
                        event.register((DispenserHelper.AdditionalDispenserBehavior)new FakePlayerUseItemBehavior(i));
                    }
                    if (key && i instanceof KeyItem) {
                        event.register((DispenserHelper.AdditionalDispenserBehavior)new KeyBehavior(i));
                    }
                    if (!sack || !(i instanceof SackItem)) continue;
                    event.registerPlaceBlock((ItemLike)i);
                }
                catch (Exception e) {
                    Supplementaries.error();
                    Supplementaries.LOGGER.warn("Error white registering dispenser behavior for item {}: {}", (Object)i, (Object)e);
                }
            }
        }
    }
}

