/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GravelBricksBlock
extends Block {
    private static final VoxelShape SHAPE_HACK = Block.box((double)0.0, (double)0.01, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public GravelBricksBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext ec;
        if (context instanceof EntityCollisionContext && (ec = (EntityCollisionContext)context).getEntity() instanceof Player) {
            return SHAPE_HACK;
        }
        return Shapes.block();
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.fallOn(level, state, pos, entity, fallDistance);
        if (!level.isClientSide && !entity.isSteppingCarefully() && fallDistance > 3.0f && GravelBricksBlock.hasEnergyToBreak(entity)) {
            level.destroyBlock(pos, false, entity);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof Container) {
                Container container = (Container)blockEntity;
            }
        }
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.isClientSide && entity.yo < entity.getY() && GravelBricksBlock.hasEnergyToBreak(entity)) {
            level.destroyBlock(pos, false, entity);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof Container) {
                Container container = (Container)blockEntity;
            }
        }
        super.entityInside(state, level, pos, entity);
    }

    private static boolean hasEnergyToBreak(Entity entity) {
        return entity.getBoundingBox().getSize() > 0.5 && (entity instanceof LivingEntity || entity instanceof FallingBlockEntity);
    }
}

