/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.BannerPatternTooltip;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;

public class BannerPatternTooltipComponent
implements ClientTooltipComponent {
    private final int size = ClientConfigs.Tweaks.TOOLTIP_IMAGE_SIZE.get();
    private final Optional<Material> material;

    public BannerPatternTooltipComponent(BannerPatternTooltip tooltip) {
        Registry reg = Minecraft.getInstance().level.registryAccess().registryOrThrow(Registries.BANNER_PATTERN);
        this.material = reg.getTag(tooltip.pattern()).flatMap(n -> n.stream().findAny()).map(Sheets::getBannerMaterial);
    }

    public int getHeight() {
        return this.size + 2;
    }

    public int getWidth(Font pFont) {
        return this.size;
    }

    public void renderImage(Font pFont, int x, int y, GuiGraphics graphics) {
        if (this.material.isPresent()) {
            graphics.pose().pushPose();
            TextureAtlasSprite sprite = this.material.get().sprite();
            RenderSystem.enableBlend();
            SpriteContents contents = sprite.contents();
            int width = contents.width();
            int height = contents.height();
            RenderUtil.blitSpriteSection((GuiGraphics)graphics, (int)x, (int)y, (int)this.size, (int)this.size, (float)(1.0f / (float)width), (float)(1.0f / (float)height * 12.0f), (int)((int)(0.3125f * (float)width)), (int)((int)(0.3125f * (float)height)), (TextureAtlasSprite)sprite);
            graphics.pose().popPose();
        }
    }
}

