/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.core.travel;

import com.pedrorok.hypertube.core.connection.BezierConnection;
import com.pedrorok.hypertube.core.connection.SimpleConnection;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeActionPoint;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnectionEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TravelPathData {
    private final List<Vec3> travelPoints = new ArrayList<Vec3>();
    private final List<UUID> bezierConnections = new ArrayList<UUID>();
    private final List<BlockPos> blockConnections = new ArrayList<BlockPos>();
    private final Set<BlockPos> actionPoints = new HashSet<BlockPos>();

    public TravelPathData(BlockPos firstPipe, Level level, BlockPos entrancePos) {
        this.travelPoints.add(entrancePos.getCenter());
        this.blockConnections.add(entrancePos);
        this.travelPoints.add(firstPipe.getCenter());
        this.blockConnections.add(firstPipe);
        this.addTravelPoint(entrancePos, level);
        this.addTravelPoint(firstPipe, level);
        this.checkAndRemoveNearPoints();
    }

    private void checkAndRemoveNearPoints() {
        if (this.travelPoints.size() < 2) {
            return;
        }
        Vec3 lastPoint = this.travelPoints.getFirst();
        for (int i = 1; i < this.travelPoints.size(); ++i) {
            Vec3 currentPoint = this.travelPoints.get(i);
            double distance = lastPoint.distanceToSqr(currentPoint);
            if (distance < 0.8) {
                this.travelPoints.remove(i);
                --i;
                continue;
            }
            lastPoint = currentPoint;
        }
    }

    private void addTravelPoint(BlockPos pos, Level level) {
        BlockState blockState = level.getBlockState(pos);
        if (this.addCurvedTravelPoint(pos, level)) {
            return;
        }
        Block block = blockState.getBlock();
        if (!(block instanceof ITubeConnection)) {
            return;
        }
        ITubeConnection pipeBlock = (ITubeConnection)block;
        List<Direction> connectedFaces = pipeBlock.getConnectedFaces(blockState);
        for (Direction direction : connectedFaces) {
            ITubeConnectionEntity tubeEntity;
            BlockEntity blockEntity;
            ITubeConnection connection;
            Block block2;
            BlockPos nextPipe = pos.relative(direction);
            if (this.blockConnections.contains(nextPipe) || !((block2 = level.getBlockState(nextPipe).getBlock()) instanceof ITubeConnection) || !(connection = (ITubeConnection)block2).canTravelConnect((LevelAccessor)level, nextPipe, direction) && (blockEntity = level.getBlockEntity(nextPipe)) instanceof ITubeConnectionEntity && !(tubeEntity = (ITubeConnectionEntity)blockEntity).isConnected()) continue;
            this.travelPoints.add(nextPipe.getCenter());
            this.blockConnections.add(nextPipe);
            if (level.getBlockState(nextPipe).getBlock() instanceof ITubeActionPoint) {
                this.actionPoints.add(nextPipe);
            }
            this.addTravelPoint(nextPipe, level);
            break;
        }
    }

    private boolean addCurvedTravelPoint(BlockPos pos, Level level) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof ITubeConnectionEntity)) {
            return false;
        }
        ITubeConnectionEntity hypertubeBlockEntity = (ITubeConnectionEntity)blockEntity;
        boolean connected = false;
        for (IConnection connection : hypertubeBlockEntity.getConnections()) {
            BlockPos fromPosFinal;
            BezierConnection bezier;
            boolean inverse = false;
            if (connection instanceof SimpleConnection) {
                BezierConnection fromTubeBezier;
                ITubeConnectionEntity fromTube;
                IConnection fromTubeConn;
                SimpleConnection simple = (SimpleConnection)connection;
                BlockEntity blockEntity2 = level.getBlockEntity(simple.pos());
                if (!(blockEntity2 instanceof ITubeConnectionEntity) || !((fromTubeConn = (fromTube = (ITubeConnectionEntity)blockEntity2).getThisConnectionFrom(simple)) instanceof BezierConnection)) continue;
                bezier = fromTubeBezier = (BezierConnection)fromTubeConn;
                inverse = true;
            } else {
                BezierConnection bezierConnection;
                if (!(connection instanceof BezierConnection)) continue;
                bezier = bezierConnection = (BezierConnection)connection;
            }
            if (this.bezierConnections.contains(bezier.getUuid())) continue;
            ArrayList<Vec3> bezierPoints = new ArrayList<Vec3>(bezier.getBezierPoints());
            if (inverse) {
                Collections.reverse(bezierPoints);
            }
            bezierPoints.removeLast();
            bezierPoints.removeFirst();
            this.travelPoints.addAll(bezierPoints);
            this.bezierConnections.add(bezier.getUuid());
            BlockPos toPos = bezier.getToPos().pos();
            BlockPos fromPos = bezier.getFromPos().pos();
            BlockPos toPosFinal = inverse ? fromPos : toPos;
            BlockPos blockPos = fromPosFinal = inverse ? toPos : fromPos;
            if (!this.blockConnections.contains(fromPosFinal)) {
                this.blockConnections.add(fromPosFinal);
                if (level.getBlockState(fromPosFinal).getBlock() instanceof ITubeActionPoint) {
                    this.actionPoints.add(fromPosFinal);
                }
            }
            if (!this.blockConnections.contains(toPosFinal)) {
                this.blockConnections.add(toPosFinal);
                if (level.getBlockState(toPosFinal).getBlock() instanceof ITubeActionPoint) {
                    this.actionPoints.add(toPosFinal);
                }
            }
            this.addTravelPoint(toPosFinal, level);
            connected = true;
        }
        return connected;
    }

    public BlockPos getLastBlockPos() {
        if (this.blockConnections.isEmpty()) {
            return null;
        }
        return this.blockConnections.getLast();
    }

    public Vec3 getEndDirection(Level level) {
        if (this.blockConnections.isEmpty()) {
            return null;
        }
        BlockEntity blockEntity = level.getBlockEntity(this.blockConnections.getLast());
        if (blockEntity instanceof ITubeConnectionEntity) {
            ITubeConnectionEntity connection = (ITubeConnectionEntity)blockEntity;
            return connection.getExitDirection();
        }
        return null;
    }

    public List<Vec3> getTravelPoints() {
        return this.travelPoints;
    }

    public Set<BlockPos> getActionPoints() {
        return this.actionPoints;
    }
}

