/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.gui.components;

import com.koteinik.chunksfadein.MathUtils;
import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.gui.GuiUtils;
import com.koteinik.chunksfadein.gui.SettingsScreen;
import com.koteinik.chunksfadein.gui.components.CFIButton;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetTooltipHolder;
import net.minecraft.network.chat.Component;

public class CFISlider
extends AbstractSliderButton {
    private static final int RESET_BUTTON_W = 40;
    private static final int RESET_BUTTON_H = 20;
    private final Function<Double, Component> displayText;
    private final DoubleConsumer applyValue;
    private final DoubleSupplier getValue;
    private final WidgetTooltipHolder tooltip = new WidgetTooltipHolder();

    public CFISlider(int x, int y, int width, int height, DoubleSupplier getValue, DoubleConsumer applyValue, Function<Double, Component> displayText, Component tooltip) {
        super(x, y, width, height, displayText.apply(getValue.getAsDouble()), getValue.getAsDouble());
        this.displayText = displayText;
        this.applyValue = applyValue;
        this.getValue = getValue;
        if (tooltip != null) {
            this.tooltip.set(Tooltip.create((Component)tooltip));
        }
    }

    public void applyValue() {
        this.applyValue.accept(this.value);
    }

    public void updateMessage() {
        this.setMessage(this.displayText.apply(this.getValue.getAsDouble()));
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        this.tooltip.refreshTooltipForNextRenderPass(this.isHovered, this.active, this.getRectangle());
    }

    public CFIButton makeResetButton(String key) {
        return new CFIButton.CFIButtonBuilder().width(40).height(20).text((Component)SettingsScreen.RESET).onPress(() -> {
            Config.reset(key);
            this.updateMessage();
            this.value = this.getValue.getAsDouble();
        }).build();
    }

    public static class CFISliderBuilder {
        private int x = 0;
        private int y = 0;
        private int width = 180;
        private int height = 20;
        private DoubleConsumer applyValue = null;
        private DoubleSupplier getValue = null;
        private Function<Double, Component> displayText = null;
        private Component tooltip = null;

        public CFISliderBuilder x(int x) {
            this.x = x;
            return this;
        }

        public CFISliderBuilder y(int y) {
            this.y = y;
            return this;
        }

        public CFISliderBuilder width(int width) {
            this.width = width;
            return this;
        }

        public CFISliderBuilder height(int height) {
            this.height = height;
            return this;
        }

        public CFISliderBuilder applyValue(DoubleConsumer applyValue) {
            this.applyValue = applyValue;
            return this;
        }

        public CFISliderBuilder getValue(DoubleSupplier getValue) {
            this.getValue = getValue;
            return this;
        }

        public CFISliderBuilder displayText(Function<Double, Component> displayText) {
            this.displayText = displayText;
            return this;
        }

        public CFISliderBuilder tooltip(String key) {
            return this.tooltip((Component)Component.translatable((String)key));
        }

        public CFISliderBuilder tooltip(Component tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public CFISlider build() {
            return new CFISlider(this.x, this.y, this.width, this.height, this.getValue, this.applyValue, this.displayText, this.tooltip);
        }

        public static CFISliderBuilder range(String textKey, String configKey) {
            return CFISliderBuilder.range(textKey, configKey, (Component)Component.empty(), Config.getMin(configKey), Config.getMax(configKey), 0);
        }

        public static CFISliderBuilder range(String textKey, String configKey, int precision) {
            return CFISliderBuilder.range(textKey, configKey, (Component)Component.empty(), Config.getMin(configKey), Config.getMax(configKey), precision);
        }

        public static CFISliderBuilder range(String textKey, String configKey, Component units) {
            return CFISliderBuilder.range(textKey, configKey, units, Config.getMin(configKey), Config.getMax(configKey), 0);
        }

        public static CFISliderBuilder range(String textKey, String configKey, Component units, double min, double max, int precision) {
            return new CFISliderBuilder().displayText(v -> GuiUtils.text(textKey, String.valueOf(MathUtils.round(MathUtils.lerp(min, max, v), precision))).append(units)).getValue(() -> MathUtils.rlerp(min, max, Config.getDouble(configKey))).applyValue(v -> Config.setDouble(configKey, MathUtils.lerp(min, max, v))).tooltip((Component)GuiUtils.tooltip(textKey));
        }
    }
}

