/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class RandomReplaceWithPropertiesProcessor
extends StructureProcessor {
    public static final MapCodec<RandomReplaceWithPropertiesProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("input_block").forGetter(config -> config.inputBlock), (App)BuiltInRegistries.BLOCK.byNameCodec().optionalFieldOf("output_block").forGetter(config -> config.outputBlock), (App)BuiltInRegistries.BLOCK.byNameCodec().listOf().optionalFieldOf("output_blocks", (Object)ImmutableList.of()).forGetter(config -> config.outputBlocks), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(config -> Float.valueOf(config.probability))).apply((Applicative)instance, instance.stable(RandomReplaceWithPropertiesProcessor::new)));
    private final Block inputBlock;
    private final Optional<Block> outputBlock;
    private final List<Block> outputBlocks;
    private final float probability;

    public RandomReplaceWithPropertiesProcessor(Block inputBlock, Optional<Block> outputBlock, List<Block> outputBlocks, float probability) {
        this.inputBlock = inputBlock;
        this.outputBlock = outputBlock;
        this.outputBlocks = outputBlocks;
        this.probability = probability;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader worldReader, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo infoIn1, StructureTemplate.StructureBlockInfo infoIn2, StructurePlaceSettings settings) {
        if (infoIn2.state().getBlock() == this.inputBlock) {
            BlockPos worldPos = infoIn2.pos();
            RandomSource random = RandomSource.create();
            int offSet = settings.getProcessors().indexOf((Object)this) + 1;
            random.setSeed(worldPos.asLong() * worldPos.asLong() * (long)offSet);
            if (random.nextFloat() < this.probability) {
                if (this.outputBlock.isPresent()) {
                    BlockState newBlockState = this.outputBlock.get().defaultBlockState();
                    newBlockState = GeneralUtils.copyBlockProperties(infoIn2.state(), newBlockState);
                    return new StructureTemplate.StructureBlockInfo(infoIn2.pos(), newBlockState, infoIn2.nbt());
                }
                if (!this.outputBlocks.isEmpty()) {
                    BlockState newBlockState = this.outputBlocks.get(random.nextInt(this.outputBlocks.size())).defaultBlockState();
                    newBlockState = GeneralUtils.copyBlockProperties(infoIn2.state(), newBlockState);
                    return new StructureTemplate.StructureBlockInfo(infoIn2.pos(), newBlockState, infoIn2.nbt());
                }
                RepurposedStructures.LOGGER.warn("Repurposed Structures: repurposed_structures:random_replace_with_properties_processor in a processor file has no replacement block of any kind.");
            }
        }
        return infoIn2;
    }

    protected StructureProcessorType<?> getType() {
        return RSProcessors.RANDOM_REPLACE_WITH_PROPERTIES_PROCESSOR.get();
    }
}

