/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine;

import com.google.common.collect.Iterators;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yogpc.qp.FluidStackLike;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.MachineStorageFactory;
import com.yogpc.qp.machine.MachineStorageHolder;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class MachineStorage {
    public static final int ONE_BUCKET = 81000;
    protected final Object2LongLinkedOpenHashMap<ItemKey> items = new Object2LongLinkedOpenHashMap();
    protected final Object2LongLinkedOpenHashMap<FluidKey> fluids = new Object2LongLinkedOpenHashMap();
    List<Runnable> onUpdate = new ArrayList<Runnable>();
    public static final MapCodec<ItemKey> ITEM_KEY_MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)RecordCodecBuilder.of(ItemKey::item, (String)"item", (Codec)BuiltInRegistries.ITEM.byNameCodec()), (App)DataComponentPatch.CODEC.optionalFieldOf("patch", (Object)DataComponentPatch.EMPTY).forGetter(ItemKey::patch)).apply((Applicative)i, ItemKey::new));
    static final MapCodec<ItemKeyCount> ITEM_KEY_COUNT_MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)RecordCodecBuilder.of(ItemKeyCount::key, ITEM_KEY_MAP_CODEC), (App)RecordCodecBuilder.of(ItemKeyCount::count, (String)"count", (Codec)Codec.LONG)).apply((Applicative)i, ItemKeyCount::new));
    static final MapCodec<FluidKeyCount> FLUID_KEY_COUNT_MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)RecordCodecBuilder.of(c -> c.key.fluid, (String)"fluid", (Codec)BuiltInRegistries.FLUID.byNameCodec()), (App)DataComponentPatch.CODEC.optionalFieldOf("patch", (Object)DataComponentPatch.EMPTY).forGetter(c -> c.key.patch), (App)RecordCodecBuilder.of(FluidKeyCount::count, (String)"count", (Codec)Codec.LONG)).apply((Applicative)i, (a, b, c) -> new FluidKeyCount(new FluidKey((Fluid)a, (DataComponentPatch)b), (long)c)));
    public static final MapCodec<MachineStorage> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)RecordCodecBuilder.of(MachineStorage::itemKeyCounts, (String)"items", (Codec)ITEM_KEY_COUNT_MAP_CODEC.codec().listOf()), (App)RecordCodecBuilder.of(MachineStorage::fluidKeyCounts, (String)"fluids", (Codec)FLUID_KEY_COUNT_MAP_CODEC.codec().listOf())).apply((Applicative)i, (itemKeyCounts, fluidKeyCounts) -> MachineStorage.of(ItemKeyCount.list2Map(itemKeyCounts), FluidKeyCount.list2Map(fluidKeyCounts))));
    private static final int MAX_TRANSFER = 4;

    public static MachineStorage of() {
        MachineStorageFactory factory = ServiceLoader.load(MachineStorageFactory.class, MachineStorageFactory.class.getClassLoader()).findFirst().orElseThrow(() -> new IllegalStateException("Could not find Machine Storage implementation"));
        return factory.createMachineStorage();
    }

    static MachineStorage of(Map<ItemKey, Long> items, Map<FluidKey, Long> fluids) {
        MachineStorage storage = MachineStorage.of();
        storage.items.putAll(items);
        storage.fluids.putAll(fluids);
        return storage;
    }

    protected MachineStorage() {
        this.items.defaultReturnValue(0L);
        this.fluids.defaultReturnValue(0L);
    }

    public void onUpdate(Runnable runnable) {
        this.onUpdate.add(runnable);
    }

    protected void notifyUpdate() {
        this.onUpdate.forEach(Runnable::run);
    }

    public void addItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        ItemKey key = ItemKey.of(stack);
        this.items.addTo((Object)key, (long)stack.getCount());
        this.notifyUpdate();
    }

    public void addFluid(Fluid fluid, long amount) {
        if (fluid.isSame(Fluids.EMPTY)) {
            return;
        }
        FluidKey key = new FluidKey(fluid, DataComponentPatch.EMPTY);
        this.fluids.addTo((Object)key, amount);
        this.notifyUpdate();
    }

    public void addBucketFluid(ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        FluidStackLike content = PlatformAccess.getAccess().getFluidInItem(stack);
        if (content.fluid().isSame(Fluids.EMPTY)) {
            return;
        }
        FluidKey key = new FluidKey(content.fluid(), content.patch());
        this.fluids.addTo((Object)key, content.amount());
        this.notifyUpdate();
    }

    long getItemCount(ItemKey key) {
        return this.items.getLong((Object)key);
    }

    public long getItemCount(Item item, DataComponentPatch patch) {
        return this.getItemCount(new ItemKey(item, patch));
    }

    long getFluidCount(FluidKey key) {
        return this.fluids.getLong((Object)key);
    }

    public long getFluidCount(Fluid fluid) {
        return this.getFluidCount(new FluidKey(fluid, DataComponentPatch.EMPTY));
    }

    public String toString() {
        long itemSize = this.items.values().longStream().filter(t -> t != 0L).count();
        long fluidSize = this.fluids.values().longStream().filter(t -> t != 0L).count();
        return "MachineStorage{items=" + itemSize + ", fluids=" + fluidSize + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachineStorage that = (MachineStorage)o;
        return Objects.equals(this.items, that.items) && Objects.equals(this.fluids, that.fluids);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.fluids);
    }

    public List<ItemKeyCount> itemKeyCounts() {
        return this.items.object2LongEntrySet().stream().map(e -> new ItemKeyCount((ItemKey)e.getKey(), e.getLongValue())).toList();
    }

    public List<FluidKeyCount> fluidKeyCounts() {
        return this.fluids.object2LongEntrySet().stream().map(e -> new FluidKeyCount((FluidKey)e.getKey(), e.getLongValue())).toList();
    }

    public void passItems(Level level, BlockPos storagePos) {
        Direction[] directions;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int count = 0;
        block0: for (Direction direction : directions = new Direction[]{Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST, Direction.DOWN, Direction.UP}) {
            BlockPos.MutableBlockPos pos = mutablePos.setWithOffset((Vec3i)storagePos, direction);
            BlockState state = level.getBlockState((BlockPos)pos);
            if (MachineStorage.cantBeStorage(state)) continue;
            ObjectBidirectionalIterator itr = this.items.object2LongEntrySet().fastIterator();
            while (itr.hasNext()) {
                Object2LongMap.Entry entry = (Object2LongMap.Entry)itr.next();
                ItemStack stack = ((ItemKey)entry.getKey()).toStack(Math.clamp(entry.getLongValue(), 0, Integer.MAX_VALUE));
                ItemStack rest = PlatformAccess.getAccess().transfer().transferItem(level, (BlockPos)pos, stack, direction.getOpposite(), false);
                if (rest.getCount() == stack.getCount()) continue;
                if (rest.isEmpty() && (long)stack.getCount() == entry.getLongValue()) {
                    itr.remove();
                } else {
                    entry.setValue(entry.getLongValue() - (long)stack.getCount() + (long)rest.getCount());
                }
                if (count++ <= 4) continue;
                break block0;
            }
        }
        if (count > 0) {
            this.notifyUpdate();
        }
    }

    public void passFluids(Level level, BlockPos storagePos) {
        Direction[] directions;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int count = 0;
        block0: for (Direction direction : directions = new Direction[]{Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST, Direction.DOWN, Direction.UP}) {
            BlockPos.MutableBlockPos pos = mutablePos.setWithOffset((Vec3i)storagePos, direction);
            BlockState state = level.getBlockState((BlockPos)pos);
            if (MachineStorage.cantBeStorage(state)) continue;
            ObjectBidirectionalIterator itr = this.fluids.object2LongEntrySet().fastIterator();
            while (itr.hasNext()) {
                Object2LongMap.Entry entry = (Object2LongMap.Entry)itr.next();
                FluidStackLike stack = ((FluidKey)entry.getKey()).toStack(Math.clamp(entry.getLongValue(), 0, Integer.MAX_VALUE));
                FluidStackLike rest = PlatformAccess.getAccess().transfer().transferFluid(level, (BlockPos)pos, stack, direction.getOpposite(), false);
                if (rest.amount() == stack.amount()) continue;
                if (rest.isEmpty() && stack.amount() == entry.getLongValue()) {
                    itr.remove();
                } else {
                    entry.setValue(entry.getLongValue() - stack.amount() + rest.amount());
                }
                if (count++ <= 4) continue;
                break block0;
            }
        }
        if (count > 0) {
            this.notifyUpdate();
        }
    }

    private static boolean cantBeStorage(BlockState state) {
        return state.isAir() || state.is((Block)PlatformAccess.getAccess().registerObjects().frameBlock().get()) || state.is((Block)PlatformAccess.getAccess().registerObjects().generatorBlock().get());
    }

    public int fluidTanks() {
        return this.fluids.size();
    }

    public FluidStackLike getFluidByIndex(int i) {
        if (i < 0 || i >= this.fluids.size()) {
            return FluidStackLike.EMPTY;
        }
        Object2LongMap.Entry e = (Object2LongMap.Entry)Iterators.get((Iterator)this.fluids.object2LongEntrySet().iterator(), (int)i);
        return new FluidStackLike(((FluidKey)e.getKey()).fluid(), e.getLongValue(), ((FluidKey)e.getKey()).patch());
    }

    public FluidStackLike drainFluid(FluidStackLike toDrain, boolean execute) {
        FluidKey key = new FluidKey(toDrain.fluid(), toDrain.patch());
        long amount = this.fluids.getLong((Object)key);
        long toDrainAmount = Math.min(amount, toDrain.amount());
        if (execute) {
            if (amount - toDrainAmount > 0L) {
                this.fluids.put((Object)key, amount - toDrainAmount);
            } else {
                this.fluids.removeLong((Object)key);
            }
            this.notifyUpdate();
        }
        return toDrain.withAmount(toDrainAmount);
    }

    public FluidStackLike drainFluidByIndex(int index, long amount, boolean execute) {
        FluidStackLike fluid = this.getFluidByIndex(index);
        if (fluid.isEmpty()) {
            return FluidStackLike.EMPTY;
        }
        return this.drainFluid(fluid.withAmount(amount), execute);
    }

    public int itemSlots() {
        return this.items.size();
    }

    public ItemStack getItemByIndex(int i) {
        if (i < 0 || i >= this.items.size()) {
            return ItemStack.EMPTY;
        }
        Object2LongMap.Entry e = (Object2LongMap.Entry)Iterators.get((Iterator)this.items.object2LongEntrySet().iterator(), (int)i);
        return ((ItemKey)e.getKey()).toStack(Math.clamp(e.getLongValue(), 0, Integer.MAX_VALUE));
    }

    public ItemStack extractItemByIndex(int i, int amount, boolean execute) {
        if (i < 0 || i >= this.items.size()) {
            return ItemStack.EMPTY;
        }
        Object2LongMap.Entry e = (Object2LongMap.Entry)Iterators.get((Iterator)this.items.object2LongEntrySet().iterator(), (int)i);
        long toExtractAmount = Math.min((long)amount, e.getLongValue());
        if (execute) {
            if ((long)amount - toExtractAmount > 0L) {
                this.items.put((Object)((ItemKey)e.getKey()), (long)amount - toExtractAmount);
            } else {
                this.items.removeLong(e.getKey());
            }
            this.notifyUpdate();
        }
        return ((ItemKey)e.getKey()).toStack(Math.clamp(toExtractAmount, 0, Integer.MAX_VALUE));
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> pushItemTicker() {
        return (level, blockPos, blockState, blockEntity) -> MachineStorageHolder.getHolder(blockEntity).ifPresent(h -> h.getMachineStorage(blockEntity).passItems(level, blockPos));
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> pushFluidTicker() {
        return (level, blockPos, blockState, blockEntity) -> MachineStorageHolder.getHolder(blockEntity).ifPresent(h -> h.getMachineStorage(blockEntity).passFluids(level, blockPos));
    }

    public record ItemKey(Item item, DataComponentPatch patch) {
        public static ItemKey of(ItemStack stack) {
            return new ItemKey(stack.getItem(), stack.getComponentsPatch());
        }

        public ItemStack toStack(int count) {
            return new ItemStack(Holder.direct((Object)this.item), count, this.patch);
        }
    }

    public record FluidKey(Fluid fluid, DataComponentPatch patch) {
        public FluidStackLike toStack(int amount) {
            return new FluidStackLike(this.fluid, amount, this.patch);
        }
    }

    public record ItemKeyCount(ItemKey key, long count) {
        static Map<ItemKey, Long> list2Map(List<ItemKeyCount> list) {
            return list.stream().collect(Collectors.toMap(ItemKeyCount::key, ItemKeyCount::count));
        }
    }

    public record FluidKeyCount(FluidKey key, long count) {
        static Map<FluidKey, Long> list2Map(List<FluidKeyCount> list) {
            return list.stream().collect(Collectors.toMap(FluidKeyCount::key, FluidKeyCount::count));
        }
    }
}

