/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.events;

import dev.uncandango.alltheleaks.AllTheLeaks;
import dev.uncandango.alltheleaks.config.ATLProperties;
import dev.uncandango.alltheleaks.exceptions.ATLIllegalState;
import dev.uncandango.alltheleaks.exceptions.ATLUnsupportedOperation;
import dev.uncandango.alltheleaks.feature.common.mods.minecraft.MemoryMonitor;
import dev.uncandango.alltheleaks.leaks.IssueManager;
import dev.uncandango.alltheleaks.mixin.Trackable;
import dev.uncandango.alltheleaks.report.ReportManager;
import dev.uncandango.alltheleaks.utils.ReflectionHelper;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.CrashReportCallables;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.throwables.ClassAlreadyLoadedException;
import org.spongepowered.asm.mixin.transformer.Config;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.perf.Profiler;

@EventBusSubscriber(modid="alltheleaks")
public class CommonEvents {
    private static final ClickEvent LINK_TO_REPORT = new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/pietro-lopes/AllTheLeaks/issues/5");
    private static final HoverEvent HOVER_LINK = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click here").withStyle(ChatFormatting.GREEN));
    private static final Component REPORT_TO_DEV = Component.literal((String)"[report to developer]").withStyle(style -> style.withClickEvent(LINK_TO_REPORT).withHoverEvent(HOVER_LINK).withColor(ChatFormatting.GREEN));
    public static int reports = 0;

    @SubscribeEvent
    public static void commonSetup(InterModProcessEvent event) {
        event.enqueueWork(IssueManager::initiateIssues);
    }

    @SubscribeEvent
    public static void onModLoadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            if (ATLProperties.get().ingredientDedupe) {
                ReportManager.registerTask("ingame_ingredient_dedupe_errors", 300, CommonEvents::reportIngameIngredientDedupeErrors);
            }
            ReportManager.registerTask("clear_memory_leak_map", 6000, Trackable::clearNullReferences);
            CrashReportCallables.registerCrashCallable((String)"AllTheLeaks", CommonEvents::generateReportForCrashReport);
            int logIntervalInTicks = ATLProperties.get().logIntervalInMinutes * 60 * 20;
            ReportManager.registerTask("passive_memory_leak_report", logIntervalInTicks, () -> MemoryMonitor.logFullSummary(arg_0 -> ((Logger)AllTheLeaks.LOGGER).info(arg_0)));
            ReportManager.registerTask("update_leak_summary", 100, MemoryMonitor::updateLeakSummary);
            if (ATLProperties.get().memoryUsageWarningPercentage > 0) {
                ReportManager.registerTask("too_much_memory_usage", 100, MemoryMonitor::tooMuchMemoryUsage);
            }
            if (AllTheLeaks.INDEV) {
                CommonEvents.auditMyMixinsOnly();
            }
        });
    }

    private static void auditMyMixinsOnly() {
        try {
            Class<?> MIXIN_CONFIG_CLASS = ReflectionHelper.getClass("org.spongepowered.asm.mixin.transformer.MixinConfig");
            MethodHandle unhandledMixinsMH = ReflectionHelper.getMethodFromClass(MIXIN_CONFIG_CLASS, "getUnhandledTargets", MethodType.methodType(Set.class), false);
            Config config = Config.create((String)"alltheleaks.mixins.json", (MixinEnvironment)MixinEnvironment.getCurrentEnvironment(), null);
            Set unhandled = unhandledMixinsMH.invoke(config.getConfig());
            HashSet unhandledCopy = new HashSet(unhandled);
            ILogger auditLogger = MixinService.getService().getLogger("mixin.audit");
            for (String target : unhandledCopy) {
                try {
                    auditLogger.info("Force-loading class {}", new Object[]{target});
                    MixinService.getService().getClassProvider().findClass(target, true);
                }
                catch (ClassNotFoundException ex) {
                    auditLogger.error("Could not force-load " + target, (Throwable)ex);
                }
            }
            for (String target : unhandledMixinsMH.invoke(config.getConfig())) {
                ClassAlreadyLoadedException ex = new ClassAlreadyLoadedException(target + " was already classloaded");
                auditLogger.error("Could not force-load " + target, (Throwable)ex);
            }
            if (MixinEnvironment.getCurrentEnvironment().getOption(MixinEnvironment.Option.DEBUG_PROFILER)) {
                Profiler.printAuditSummary();
            }
        }
        catch (Throwable e) {
            AllTheLeaks.LOGGER.error("Error while auditing mixins", e);
        }
    }

    private static void reportIngameIngredientDedupeErrors() {
        if (FMLEnvironment.dist.isClient()) {
            int count;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && (count = ATLUnsupportedOperation.getUnreportedErrorCount()) > 0) {
                MutableComponent message = Component.translatable((String)"[AllTheLeaks] There are %s errors related to Ingredient Dedupe, check logs for more info and %s.", (Object[])new Object[]{count, REPORT_TO_DEV}).withStyle(ChatFormatting.RED);
                player.sendSystemMessage((Component)message);
            }
        } else {
            int count;
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null && (count = ATLUnsupportedOperation.getUnreportedErrorCount()) > 0) {
                AllTheLeaks.LOGGER.warn("[AllTheLeaks] There are {} errors related to Ingredient Dedupe, check logs for more info and report to {}.", (Object)count, (Object)"https://github.com/pietro-lopes/AllTheLeaks/issues/5");
            }
        }
    }

    private static String generateReportForCrashReport() {
        if (++reports % 2 == 1) {
            MemoryMonitor.runExplicitGc();
        }
        Trackable.clearNullReferences();
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        if (ATLProperties.get().ingredientDedupe) {
            sb.append("\t\tIngredient Dedupe Errors: ").append(ATLUnsupportedOperation.getErrorCount()).append("\n");
        }
        sb.append("\t\tEvents:\n");
        MemoryMonitor.getEventsSummary().forEach(line -> sb.append("\t\t  ").append((String)line).append("\n"));
        sb.append("\t\tExplicit GC Last Run: ").append((String)(MemoryMonitor.isExplicitGcDisabled() ? "Disabled" : Util.getMillis() - MemoryMonitor.lastRunGc() + "ms ago")).append("\n");
        if (MemoryMonitor.isExplicitGcDisabled()) {
            sb.append("\t\tNote: Values below are not accurate due to -XX:+DisableExplicitGC arguments you are using").append("\n");
        }
        sb.append("\t\tLeaking objects:\n");
        Trackable.getSummary().forEach((baseClazz, mapCount) -> {
            if (!mapCount.isEmpty()) {
                sb.append("\t\t  ").append(baseClazz.getSimpleName()).append(":\n");
            }
            mapCount.forEach((innerClazz, count) -> sb.append("\t\t    ").append(innerClazz.getSimpleName()).append(": ").append(count).append("\n"));
        });
        return sb.toString();
    }

    @SubscribeEvent
    public static void onShutdownServer(ServerStoppingEvent event) {
        Trackable.startTracking(event.getServer());
    }

    @SubscribeEvent
    public static void onClosedServer(ServerStoppedEvent event) {
        MemoryMonitor.runExplicitGc();
        Trackable.clearNullReferences();
        MemoryMonitor.EventStatistics.SERVER_STOP.increment();
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Trackable.startTracking(event.getEntity());
        MemoryMonitor.EventStatistics.SERVER_PLAYER_LOGOUT.increment();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerCloneLowest(PlayerEvent.Clone event) {
        if (event.getOriginal().getRemovalReason() == null) {
            AllTheLeaks.LOGGER.error("Cloned player is invalid, removal reason is null!", (Throwable)new ATLIllegalState(ATLIllegalState.TYPE.NO_REMOVAL_REASON, "Cannot have null removal reason on Clone event!"));
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Trackable.startTracking(event.getOriginal());
        MemoryMonitor.EventStatistics.SERVER_PLAYER_CLONE.increment();
    }

    @SubscribeEvent
    public static void onUnloadChunk(ChunkEvent.Unload event) {
        Trackable.startTracking(event.getChunk());
    }

    @SubscribeEvent
    public static void onUnloadLevel(LevelEvent.Unload event) {
        Trackable.startTracking(event.getLevel());
    }
}

