/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.uncandango.alltheleaks.AllTheLeaks;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.util.GsonHelper;
import net.neoforged.fml.loading.FMLPaths;

public class ATLProperties {
    private static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();
    private static final Path path = FMLPaths.CONFIGDIR.get().resolve("alltheleaks.json");
    private static final JsonObject defaultProperties = ATLProperties.getDefaultProperties();
    private static ATLProperties INSTANCE;
    public boolean ingredientDedupe;
    public boolean debugItemStackModifications;
    public boolean debugNativeImage;
    public boolean disableSearchTree;
    public int logIntervalInMinutes;
    public boolean showSummaryOnDebugScreen;
    public int version;
    private static JsonObject properties;
    public int memoryUsageWarningPercentage;

    private ATLProperties() {
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (!path.toFile().exists()) {
            ATLProperties.save();
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            properties = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            this.version = GsonHelper.getAsInt((JsonObject)properties, (String)"version", (int)0);
            this.ingredientDedupe = this.version == 0 ? false : GsonHelper.getAsBoolean((JsonObject)properties, (String)"ingredientDedupe", (boolean)false);
            this.debugItemStackModifications = GsonHelper.getAsBoolean((JsonObject)properties, (String)"debugItemStackModifications", (boolean)false);
            this.debugNativeImage = GsonHelper.getAsBoolean((JsonObject)properties, (String)"debugNativeImage", (boolean)false);
            this.disableSearchTree = GsonHelper.getAsBoolean((JsonObject)properties, (String)"disableSearchTree", (boolean)false);
            this.logIntervalInMinutes = GsonHelper.getAsInt((JsonObject)properties, (String)"logIntervalInMinutes", (int)10);
            this.showSummaryOnDebugScreen = GsonHelper.getAsBoolean((JsonObject)properties, (String)"showSummaryOnDebugScreen", (boolean)true);
            this.memoryUsageWarningPercentage = GsonHelper.getAsInt((JsonObject)properties, (String)"memoryUsageWarningPercentage", (int)90);
        }
        catch (Throwable e) {
            AllTheLeaks.LOGGER.error("Failed to load config file", e);
        }
        finally {
            ATLProperties.save();
        }
    }

    public static void save() {
        if (properties == null) {
            properties = defaultProperties.deepCopy();
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            defaultProperties.asMap().forEach((key, val) -> properties.asMap().putIfAbsent(key, val));
            GSON.toJson((JsonElement)properties, (Appendable)writer);
        }
        catch (IOException e) {
            AllTheLeaks.LOGGER.error("Failed to save config file", (Throwable)e);
        }
    }

    public static ATLProperties get() {
        if (INSTANCE == null) {
            INSTANCE = new ATLProperties();
        }
        return INSTANCE;
    }

    private static JsonObject getDefaultProperties() {
        JsonObject properties = new JsonObject();
        properties.addProperty("ingredientDedupe", Boolean.valueOf(false));
        properties.addProperty("debugItemStackModifications", Boolean.valueOf(false));
        properties.addProperty("version", (Number)1);
        properties.addProperty("debugNativeImage", Boolean.valueOf(false));
        properties.addProperty("disableSearchTree", Boolean.valueOf(false));
        properties.addProperty("logIntervalInMinutes", (Number)10);
        properties.addProperty("showSummaryOnDebugScreen", Boolean.valueOf(true));
        properties.addProperty("memoryUsageWarningPercentage", (Number)90);
        return properties;
    }
}

