/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.annotation;

import com.google.common.collect.Maps;
import dev.uncandango.alltheleaks.AllTheLeaks;
import dev.uncandango.alltheleaks.utils.ReflectionHelper;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.apache.logging.log4j.util.Cast;

public class AnnotationHelper {
    private static final Map<Class<?>, Map<String, Object>> DEFAULT_VALUES = Maps.newHashMap();

    public static <T> T getValue(ModFileScanData.AnnotationData annotation, String fieldName) {
        Class<?> annotationClass = ReflectionHelper.getClass(annotation.annotationType().getClassName());
        Object defaultValue = AnnotationHelper.getDefaultValue(annotationClass, fieldName);
        return (T)Cast.cast((Object)annotation.annotationData().getOrDefault(fieldName, defaultValue));
    }

    private static Object getDefaultValue(Class<?> annotation, String fieldName) {
        DEFAULT_VALUES.computeIfAbsent(annotation, annot -> Arrays.stream(annot.getDeclaredMethods()).filter(method -> !Objects.isNull(method.getDefaultValue())).collect(Collectors.toMap(Method::getName, AnnotationHelper::returnListIfArray)));
        Map<String, Object> defaultMap = DEFAULT_VALUES.get(annotation);
        if (defaultMap == null) {
            AllTheLeaks.LOGGER.error("Field {} not found in annotation class {}", (Object)fieldName, annotation);
            return null;
        }
        return defaultMap.getOrDefault(fieldName, null);
    }

    private static Object returnListIfArray(Method method) {
        List<Object> value = method.getDefaultValue();
        return value.getClass().isArray() ? List.of((Object[])value) : value;
    }
}

