/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.rituals.forest;

import com.hollingsworth.arsnouveau.api.ritual.FeaturePlacementRitual;
import com.hollingsworth.arsnouveau.api.ritual.features.PlaceBlockFeature;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.LightBlock;
import com.hollingsworth.arsnouveau.common.block.tile.LightTile;
import com.hollingsworth.arsnouveau.common.block.tile.RitualBrazierTile;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class PlaceableLightFeature
extends PlaceBlockFeature {
    public PlaceableLightFeature(double distance, double chance) {
        super(distance, chance, () -> ((LightBlock)((LightBlock)BlockRegistry.LIGHT_BLOCK.get())).defaultBlockState());
    }

    public boolean onPlace(Level level, BlockPos pos, FeaturePlacementRitual placementRitual, RitualBrazierTile brazierTile) {
        BlockState state = (BlockState)this.block.get();
        RandomSource random = level.random;
        if ((double)random.nextFloat() < this.chance && level.getBlockState(pos).isAir()) {
            level.setBlockAndUpdate(pos, state);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof LightTile) {
                LightTile tile = (LightTile)blockEntity;
                tile.color = new ParticleColor(Math.max(10, random.nextInt(255)), Math.max(10, random.nextInt(255)), Math.max(10, random.nextInt(255)));
            }
            return true;
        }
        return false;
    }
}

