/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.integrations;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.generatorgalore.Config;
import cy.jdkdigital.generatorgalore.GeneratorGalore;
import cy.jdkdigital.generatorgalore.common.datamap.FluidFuelMap;
import cy.jdkdigital.generatorgalore.common.datamap.SolidFuelMap;
import cy.jdkdigital.generatorgalore.common.recipe.FluidFuelRecipe;
import cy.jdkdigital.generatorgalore.common.recipe.SolidFuelRecipe;
import cy.jdkdigital.generatorgalore.init.ModTags;
import cy.jdkdigital.generatorgalore.integrations.FluidFuelRecipeCategory;
import cy.jdkdigital.generatorgalore.integrations.SolidFuelRecipeCategory;
import cy.jdkdigital.generatorgalore.registry.GeneratorRegistry;
import cy.jdkdigital.generatorgalore.util.GeneratorObject;
import cy.jdkdigital.generatorgalore.util.GeneratorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiFuelingRecipe;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.library.plugins.vanilla.cooking.fuel.FuelRecipeMaker;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    private static final ResourceLocation pluginId = ResourceLocation.fromNamespaceAndPath((String)"generatorgalore", (String)"generatorgalore");
    public static RecipeType<SolidFuelRecipe> SOLID_FUEL_RECIPE_TYPE = RecipeType.create((String)"generatorgalore", (String)"solid_fuels", SolidFuelRecipe.class);
    public static RecipeType<FluidFuelRecipe> FLUID_FUEL_RECIPE_TYPE = RecipeType.create((String)"generatorgalore", (String)"fluid_fuels", FluidFuelRecipe.class);
    static List<IJeiFuelingRecipe> vanillaFuelRecipes;
    static List<ItemStack> foodList;
    static List<ItemStack> enchantmentList;
    static List<SolidFuelMap.SolidFuel> potionList;

    @Nonnull
    public ResourceLocation getPluginUid() {
        return pluginId;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        GeneratorRegistry.generators.forEach((resourceLocation, generator) -> {
            if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID)) {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)generator.getBlockSupplier().get()), new RecipeType[]{FLUID_FUEL_RECIPE_TYPE});
            } else if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.SOLID) && generator.getFuelTag().equals((Object)GeneratorUtil.EMPTY_TAG) && generator.getFuelList() == null) {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)generator.getBlockSupplier().get()), new RecipeType[]{SOLID_FUEL_RECIPE_TYPE});
            } else {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)generator.getBlockSupplier().get()), new RecipeType[]{SOLID_FUEL_RECIPE_TYPE});
            }
        });
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidFuelRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SolidFuelRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        vanillaFuelRecipes = FuelRecipeMaker.getFuelRecipes((IIngredientManager)registration.getIngredientManager());
        foodList = registration.getIngredientManager().getAllItemStacks().stream().filter(stack -> {
            FoodProperties foodProperties = stack.getItem().getFoodProperties(stack, null);
            return foodProperties != null;
        }).toList();
        enchantmentList = RegistryUtil.getRegistry((ResourceKey)Registries.ENCHANTMENT).holders().map(enchantment -> {
            ArrayList books = new ArrayList();
            IntStream.range(0, ((Enchantment)enchantment.value()).getMaxLevel()).forEach(i -> books.add(EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance((Holder)enchantment, i + 1))));
            return books;
        }).flatMap(Collection::stream).toList();
        List<Item> basePotions = List.of(Items.POTION, Items.SPLASH_POTION, Items.LINGERING_POTION);
        potionList = GeneratorUtil.getPotionFuels((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
        GeneratorRegistry.generators.forEach((resourceLocation, generator) -> {
            this.addGeneratorFuelRecipes(registration, (GeneratorObject)generator, generator.getBlockSupplier().get().asItem().getDefaultInstance(), 1);
            if (generator.has8x()) {
                this.addGeneratorFuelRecipes(registration, (GeneratorObject)generator, ((Item)BuiltInRegistries.ITEM.get(BuiltInRegistries.BLOCK.getKey((Object)generator.getBlockSupplier().get()).withPath(p -> p + "_8x"))).getDefaultInstance(), 8);
            }
            if (generator.has64x()) {
                this.addGeneratorFuelRecipes(registration, (GeneratorObject)generator, ((Item)BuiltInRegistries.ITEM.get(BuiltInRegistries.BLOCK.getKey((Object)generator.getBlockSupplier().get()).withPath(p -> p + "_64x"))).getDefaultInstance(), 64);
            }
        });
    }

    private void addGeneratorFuelRecipes(IRecipeRegistration registration, GeneratorObject generator, ItemStack genIngredient, int modifier) {
        float consumptionModifier;
        SolidFuelMap solidFuelData = (SolidFuelMap)generator.getBlockSupplier().get().builtInRegistryHolder().getData(GeneratorGalore.SOLID_FUEL_MAP);
        FluidFuelMap fluidFuelData = (FluidFuelMap)generator.getBlockSupplier().get().builtInRegistryHolder().getData(GeneratorGalore.FLUID_FUEL_MAP);
        float f = consumptionModifier = (Boolean)Config.SERVER.increasedConsumption.get() != false ? (float)modifier : 1.0f;
        if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID) && fluidFuelData == null) {
            Optional fluids;
            ArrayList<FluidFuelRecipe> fuelRecipes = new ArrayList<FluidFuelRecipe>();
            if (!generator.getFuelTag().equals((Object)GeneratorUtil.EMPTY_TAG) && (fluids = BuiltInRegistries.FLUID.getTag(ModTags.getFluidTag(generator.getFuelTag()))).isPresent()) {
                List<FluidStack> fluidStacks = ((HolderSet.Named)fluids.get()).stream().map(fluid -> new FluidStack(fluid, 10000)).toList();
                fuelRecipes.add(new FluidFuelRecipe(fluidStacks, genIngredient, (float)generator.getGenerationRate() * (float)modifier, (float)generator.getConsumptionRate() * consumptionModifier));
            }
            registration.addRecipes(FLUID_FUEL_RECIPE_TYPE, fuelRecipes);
        } else if (fluidFuelData != null) {
            ArrayList fuelRecipes = new ArrayList();
            fluidFuelData.fuels().forEach(fuel -> fuelRecipes.add(new FluidFuelRecipe(List.of(fuel.fluid().getStacks()), genIngredient, (float)fuel.generationRate() * (float)modifier, (float)fuel.consumptionRate() * consumptionModifier)));
            registration.addRecipes(FLUID_FUEL_RECIPE_TYPE, fuelRecipes);
        } else if (solidFuelData != null) {
            ArrayList fuelRecipes = new ArrayList();
            solidFuelData.fuels().forEach(fuel -> fuelRecipes.add(new SolidFuelRecipe(List.of(fuel.item()), genIngredient, (float)fuel.generationRate() * (float)modifier, (float)fuel.burnTime() / consumptionModifier)));
            registration.addRecipes(SOLID_FUEL_RECIPE_TYPE, fuelRecipes);
        } else if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.SOLID) && generator.getFuelTag().equals((Object)GeneratorUtil.EMPTY_TAG) && generator.getFuelList() == null) {
            ArrayList fuelRecipes = new ArrayList();
            vanillaFuelRecipes.forEach(fuelingRecipe -> fuelRecipes.add(new SolidFuelRecipe(List.of(Ingredient.of((ItemStack[])new ItemStack[]{(ItemStack)fuelingRecipe.getInputs().get(0)})), genIngredient, (float)generator.getGenerationRate() * (float)modifier, (int)((double)fuelingRecipe.getBurnTime() * generator.getConsumptionRate() / (double)consumptionModifier))));
            registration.addRecipes(SOLID_FUEL_RECIPE_TYPE, fuelRecipes);
        } else {
            ArrayList<SolidFuelRecipe> fuelRecipes = new ArrayList<SolidFuelRecipe>();
            if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.SOLID)) {
                if (generator.getFuelList() != null) {
                    generator.getFuelList().forEach((itemId, fuel) -> fuelRecipes.add(new SolidFuelRecipe(List.of(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BuiltInRegistries.ITEM.get(itemId)})), genIngredient, fuel.rate() * (float)modifier, (float)fuel.burnTime() / consumptionModifier)));
                } else if (!generator.getFuelTag().equals((Object)GeneratorUtil.EMPTY_TAG)) {
                    fuelRecipes.add(new SolidFuelRecipe(List.of(Ingredient.of(ModTags.getItemTag(generator.getFuelTag()))), genIngredient, (float)generator.getGenerationRate() * (float)modifier, (float)((int)generator.getConsumptionRate()) * consumptionModifier));
                }
            } else if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FOOD)) {
                foodList.forEach(stack -> {
                    Pair<Float, Integer> rate = GeneratorUtil.calculateFoodGenerationRate(generator, stack);
                    fuelRecipes.add(new SolidFuelRecipe(List.of(Ingredient.of((ItemStack[])new ItemStack[]{stack})), genIngredient, ((Float)rate.getFirst()).floatValue() * (float)modifier, (float)((Integer)rate.getSecond()).intValue() / consumptionModifier));
                });
            } else if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.ENCHANTMENT)) {
                enchantmentList.forEach(stack -> {
                    Pair<Float, Integer> rate = GeneratorUtil.calculateEnchantmentGenerationRate(generator, stack);
                    fuelRecipes.add(new SolidFuelRecipe(List.of(Ingredient.of((ItemStack[])new ItemStack[]{stack})), genIngredient, ((Float)rate.getFirst()).floatValue() * (float)modifier, (float)((Integer)rate.getSecond()).intValue() / consumptionModifier));
                });
            } else if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.POTION)) {
                potionList.forEach(fuel -> fuelRecipes.add(new SolidFuelRecipe(List.of(fuel.item()), genIngredient, fuel.generationRate() * modifier, fuel.consumptionRate() / consumptionModifier)));
            }
            registration.addRecipes(SOLID_FUEL_RECIPE_TYPE, fuelRecipes);
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
    }
}

