/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.mixin.worldgen;

import com.tristankechlo.livingthings.config.entity.NetherKnightConfig;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.mixin.worldgen.NetherFortressStructureAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Structure.class})
public abstract class StructureMixin {
    private Map<MobCategory, StructureSpawnOverride> customSpawnOverrides = null;
    @Shadow
    @Final
    protected Structure.StructureSettings settings;

    @Inject(at={@At(value="HEAD")}, method={"spawnOverrides"}, cancellable=true)
    private void LivingThings$spawnOverrides(CallbackInfoReturnable<Map<MobCategory, StructureSpawnOverride>> cir) {
        if (this.type() != StructureType.FORTRESS) {
            return;
        }
        if (this.customSpawnOverrides != null) {
            cir.setReturnValue(this.customSpawnOverrides);
            return;
        }
        MobSpawnSettings.SpawnerData netherKnightSpawnData = new MobSpawnSettings.SpawnerData(ModEntityTypes.NETHER_KNIGHT.get(), ((Integer)NetherKnightConfig.get().spawnWeight.get()).intValue(), ((Integer)NetherKnightConfig.get().minSpawnCount.get()).intValue(), ((Integer)NetherKnightConfig.get().maxSpawnCount.get()).intValue());
        this.customSpawnOverrides = new HashMap<MobCategory, StructureSpawnOverride>(this.settings.spawnOverrides());
        StructureSpawnOverride oldMonsterSpawns = this.customSpawnOverrides.get(MobCategory.MONSTER);
        ArrayList<MobSpawnSettings.SpawnerData> newMonsterSpawns = new ArrayList<MobSpawnSettings.SpawnerData>();
        if (oldMonsterSpawns != null) {
            newMonsterSpawns = new ArrayList(oldMonsterSpawns.spawns().unwrap());
        }
        newMonsterSpawns.add(netherKnightSpawnData);
        WeightedRandomList weightedRandomList = WeightedRandomList.create(newMonsterSpawns);
        NetherFortressStructureAccessor.setFortressEnemies((WeightedRandomList<MobSpawnSettings.SpawnerData>)weightedRandomList);
        StructureSpawnOverride newOverrides = new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, weightedRandomList);
        this.customSpawnOverrides.put(MobCategory.MONSTER, newOverrides);
        cir.setReturnValue(this.customSpawnOverrides);
    }

    @Shadow
    public abstract StructureType<?> type();
}

