/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.entity.PeacockEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class PeacockModel
extends AdvancedEntityModel<PeacockEntity> {
    private final ModelPart Body;
    private final ModelPart LeftLeg;
    private final ModelPart RightLeg;
    private final ModelPart LeftWing;
    private final ModelPart RightWing;
    private final ModelPart Head;
    private final ModelPart Tail1;
    private final ModelPart Tail2;
    private final ModelPart Tail3;
    private final ModelPart Tail4;
    private final ModelPart Tail5;
    private final ModelPart Tail6;
    private final ModelPart Tail7;

    public PeacockModel(ModelPart root) {
        this.Body = root.getChild("body");
        this.Head = this.Body.getChild("neck");
        this.LeftLeg = this.Body.getChild("legLeft");
        this.RightLeg = this.Body.getChild("legRight");
        this.LeftWing = this.Body.getChild("wingLeft");
        this.RightWing = this.Body.getChild("wingRight");
        ModelPart tail = this.Body.getChild("tail");
        this.Tail1 = tail.getChild("tail1");
        this.Tail2 = tail.getChild("tail2");
        this.Tail3 = tail.getChild("tail3");
        this.Tail4 = tail.getChild("tail4");
        this.Tail5 = tail.getChild("tail5");
        this.Tail6 = tail.getChild("tail6");
        this.Tail7 = tail.getChild("tail7");
    }

    public void setupAnim(PeacockEntity peacock, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.LeftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.0f * limbSwingAmount;
        this.RightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.0f * limbSwingAmount;
        this.LeftWing.yRot = 0.0f;
        this.RightWing.yRot = 0.0f;
        this.setRotationAngle(this.Tail1, -0.436332f, 0.0f, 0.0f);
        this.setRotationAngle(this.Tail2, -0.436332f, 0.0f, 0.0f);
        this.setRotationAngle(this.Tail3, -0.436332f, 0.0f, 0.0f);
        this.setRotationAngle(this.Tail4, -0.436332f, 0.0f, 0.0f);
        this.setRotationAngle(this.Tail5, -0.436332f, 0.0f, 0.0f);
        this.setRotationAngle(this.Tail6, -0.436332f, 0.0f, 0.0f);
        this.setRotationAngle(this.Tail7, -0.436332f, 0.0f, 0.0f);
        if (peacock.isInPanic()) {
            this.LeftWing.yRot = -0.436332f - Mth.cos((float)ageInTicks) * 0.5f;
            this.RightWing.yRot = 0.436332f + Mth.cos((float)ageInTicks) * 0.5f;
        }
        if (peacock.isDestroyingCrops()) {
            this.Head.yRot = 0.0f;
            this.Head.xRot = 1.74533f + Mth.cos((float)ageInTicks) * 0.5f;
            this.LeftWing.yRot = -0.436332f - Mth.cos((float)ageInTicks) * 0.25f;
            this.RightWing.yRot = 0.436332f + Mth.cos((float)ageInTicks) * 0.25f;
        } else {
            this.defaultHeadMovement(this.Head, 0.0f, 0.0f, headPitch, netHeadYaw);
        }
        if (peacock.isTailFluffed()) {
            this.setRotationAngle(this.Tail1, 1.48353f, 0.0f, 0.0f);
            this.setRotationAngle(this.Tail2, 1.481785f, 0.0f, 0.436332f);
            this.setRotationAngle(this.Tail3, 1.481785f, 0.0f, -0.436332f);
            this.setRotationAngle(this.Tail4, 1.480039f, 0.0f, 0.872665f);
            this.setRotationAngle(this.Tail5, 1.480039f, 0.0f, -0.872665f);
            this.setRotationAngle(this.Tail6, 1.478294f, 0.0f, 1.309f);
            this.setRotationAngle(this.Tail7, 1.478294f, 0.0f, -1.309f);
        }
    }

    public void prepareMobModel(PeacockEntity peacock, float limbSwing, float limbSwingAmount, float partialTick) {
        boolean isChild = peacock.isBaby();
        this.Tail1.visible = !isChild;
        this.Tail2.visible = !isChild;
        this.Tail3.visible = !isChild;
        this.Tail4.visible = !isChild;
        this.Tail5.visible = !isChild;
        this.Tail6.visible = !isChild;
        this.Tail7.visible = !isChild;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        if (this.young) {
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.translate(0.0, 1.5, 0.0);
        }
        this.Body.render(poseStack, bufferIn, packedLightIn, packedOverlayIn);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -3.5f, -5.0f, 7.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)14.5f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(20, 17).addBox(-1.5f, -9.0f, -2.0f, 3.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5f, (float)-4.0f));
        PartDefinition crest = neck.addOrReplaceChild("crest", CubeListBuilder.create().texOffs(1, 3).addBox(0.0f, -3.0f, -1.5f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.5f));
        PartDefinition beak = neck.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(1, 1).addBox(-0.5f, -1.0f, -2.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)-2.0f));
        PartDefinition legLeft = body.addOrReplaceChild("legLeft", CubeListBuilder.create().texOffs(35, 22).addBox(-1.5f, 0.0f, -3.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)3.5f, (float)2.0f));
        PartDefinition legRight = body.addOrReplaceChild("legRight", CubeListBuilder.create().texOffs(35, 22).addBox(-1.5f, 0.0f, -3.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)3.5f, (float)2.0f));
        PartDefinition wingLeft = body.addOrReplaceChild("wingLeft", CubeListBuilder.create().texOffs(1, 18).addBox(-1.0f, -2.5f, 0.0f, 1.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)-1.0f, (float)-3.0f));
        PartDefinition wingRight = body.addOrReplaceChild("wingRight", CubeListBuilder.create().texOffs(1, 18).addBox(0.0f, -2.5f, 0.0f, 1.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.5f, (float)-1.0f, (float)-3.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail1 = tail.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(12, 0).addBox(-5.0f, 0.0f, 0.0f, 10.0f, 0.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.5f, (float)5.0f, (float)1.4835f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(12, 0).addBox(-5.0f, 0.0f, 0.0f, 10.0f, 0.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.5f, (float)5.0f, (float)1.4818f, (float)0.0f, (float)0.4363f));
        PartDefinition tail3 = tail.addOrReplaceChild("tail3", CubeListBuilder.create().texOffs(12, 0).addBox(-5.0f, 0.0f, 0.0f, 10.0f, 0.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.5f, (float)5.0f, (float)1.4818f, (float)0.0f, (float)-0.4363f));
        PartDefinition tail4 = tail.addOrReplaceChild("tail4", CubeListBuilder.create().texOffs(12, 0).addBox(-5.0f, 0.0f, 0.0f, 10.0f, 0.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.5f, (float)5.0f, (float)1.48f, (float)0.0f, (float)0.8727f));
        PartDefinition tail5 = tail.addOrReplaceChild("tail5", CubeListBuilder.create().texOffs(12, 0).addBox(-5.0f, 0.0f, 0.0f, 10.0f, 0.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.5f, (float)5.0f, (float)1.48f, (float)0.0f, (float)-0.8727f));
        PartDefinition tail6 = tail.addOrReplaceChild("tail6", CubeListBuilder.create().texOffs(12, 0).addBox(-5.0f, 0.0f, 0.0f, 10.0f, 0.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.5f, (float)5.0f, (float)1.4783f, (float)0.0f, (float)1.309f));
        PartDefinition tail7 = tail.addOrReplaceChild("tail7", CubeListBuilder.create().texOffs(12, 0).addBox(-5.0f, 0.0f, 0.0f, 10.0f, 0.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.5f, (float)5.0f, (float)1.4783f, (float)0.0f, (float)-1.309f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }
}

