/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.items.ItemImpl;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.packet.PacketClient;
import de.ellpeck.naturesaura.packet.PacketHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

public class ItemDeathRing
extends ItemImpl {
    public ItemDeathRing() {
        super("death_ring", new Item.Properties().stacksTo(1));
        NeoForge.EVENT_BUS.register((Object)new Events());
    }

    public static class Events {
        @SubscribeEvent
        public void onDeath(LivingDeathEvent event) {
            ItemStack equipped;
            LivingEntity entity = event.getEntity();
            if (!entity.level().isClientSide && entity instanceof Player && !(equipped = Helper.getEquippedItem(s -> s.getItem() == ModItems.DEATH_RING, (Player)entity, false)).isEmpty()) {
                entity.setHealth(entity.getMaxHealth() / 2.0f);
                entity.removeAllEffects();
                entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 500, 1));
                CompoundTag data = new CompoundTag();
                data.putInt("id", entity.getId());
                PacketHandler.sendToAllAround(entity.level(), entity.blockPosition(), 32, new PacketClient(1, data));
                equipped.shrink(1);
                event.setCanceled(true);
            }
        }
    }
}

